/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.controlsfx.control.ButtonBar;

public class ButtonBarSkin
extends BehaviorSkinBase<ButtonBar, BehaviorBase<ButtonBar>> {
    private static final double GAP_SIZE = 10.0;
    private static final String CATEGORIZED_TYPES = "LRHEYNXBIACO";
    public static final String BUTTON_TYPE_PROPERTY = "controlfx.button.type";
    public static final String BUTTON_SIZE_INDEPENDENCE = "controlfx.button.size.indepenence";
    private HBox layout = new HBox(10.0){

        protected void layoutChildren() {
            ButtonBarSkin.this.resizeButtons();
            super.layoutChildren();
        }
    };

    public ButtonBarSkin(ButtonBar control) {
        super((Control)control, new BehaviorBase((Control)control, Collections.emptyList()));
        this.layout.setAlignment(Pos.CENTER);
        this.getChildren().add((Object)this.layout);
        this.layoutButtons();
        control.getButtons().addListener((ListChangeListener)new ListChangeListener<ButtonBase>(){

            public void onChanged(ListChangeListener.Change<? extends ButtonBase> change) {
                ButtonBarSkin.this.layoutButtons();
            }
        });
        this.registerChangeListener((ObservableValue)control.buttonOrderProperty(), "BUTTON_ORDER");
        this.registerChangeListener((ObservableValue)control.buttonMinWidthProperty(), "BUTTON_MIN_WIDTH");
        this.registerChangeListener((ObservableValue)control.buttonUniformSizeProperty(), "BUTTON_UNIFORM_SIZE");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("BUTTON_ORDER".equals(p)) {
            this.layoutButtons();
        } else if ("BUTTON_MIN_WIDTH".equals(p)) {
            this.resizeButtons();
        } else if ("BUTTON_UNIFORM_SIZE".equals(p)) {
            this.resizeButtons();
        }
    }

    private void layoutButtons() {
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        ObservableList<ButtonBase> buttons = buttonBar.getButtons();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        Map<String, List<ButtonBase>> buttonMap = this.buildButtonMap((List<? extends ButtonBase>)buttons);
        String buttonOrderStr = ((ButtonBar)this.getSkinnable()).getButtonOrder();
        if (buttonOrderStr == null || buttonOrderStr.isEmpty()) {
            throw new IllegalStateException("ButtonBar buttonOrder string can not be null or empty");
        }
        char[] buttonOrder = buttonOrderStr.toCharArray();
        this.layout.getChildren().clear();
        int buttonIndex = 0;
        Spacer spacer = Spacer.NONE;
        int i = 0;
        while (i < buttonOrder.length) {
            boolean hasChildren;
            char type = buttonOrder[i];
            boolean edgeCase = buttonIndex <= 0 && buttonIndex >= buttons.size() - 1;
            boolean bl = hasChildren = !this.layout.getChildren().isEmpty();
            if (type == '+') {
                spacer = spacer.replace(Spacer.DYNAMIC);
            } else if (type == '_' && hasChildren) {
                spacer = spacer.replace(Spacer.FIXED);
            } else {
                List<ButtonBase> buttonList = buttonMap.get(String.valueOf(type).toUpperCase());
                if (buttonList != null) {
                    spacer.add((Pane)this.layout, edgeCase);
                    for (ButtonBase btn : buttonList) {
                        btn.setMinWidth(buttonMinWidth);
                        btn.setMaxWidth(Double.MAX_VALUE);
                        this.layout.getChildren().add((Object)btn);
                        HBox.setHgrow((Node)btn, (Priority)Priority.NEVER);
                        ++buttonIndex;
                    }
                    spacer = spacer.replace(Spacer.NONE);
                }
            }
            ++i;
        }
    }

    private void resizeButtons() {
        ButtonBar buttonBar = (ButtonBar)this.getSkinnable();
        double buttonMinWidth = buttonBar.getButtonMinWidth();
        ObservableList<ButtonBase> buttons = buttonBar.getButtons();
        double widest = buttonMinWidth;
        if (buttonBar.isButtonUniformSize()) {
            for (ButtonBase button : buttons) {
                if (this.isButtonIndependent(button).booleanValue()) continue;
                widest = Math.max(button.prefWidth(-1.0), widest);
            }
        }
        for (ButtonBase button : buttons) {
            if (buttonBar.isButtonUniformSize()) {
                if (this.isButtonIndependent(button).booleanValue()) continue;
                button.setMinWidth(widest);
                continue;
            }
            if (buttonMinWidth > 0.0) {
                button.setMinWidth(buttonMinWidth);
                continue;
            }
            button.setMinWidth(0.0);
            button.setPrefWidth(-1.0);
        }
    }

    private Boolean isButtonIndependent(ButtonBase btn) {
        return Boolean.TRUE.equals(btn.getProperties().get((Object)BUTTON_SIZE_INDEPENDENCE));
    }

    private String getButtonType(ButtonBase btn) {
        String typeCode;
        ButtonBar.ButtonType buttonType = (ButtonBar.ButtonType)((Object)btn.getProperties().get((Object)BUTTON_TYPE_PROPERTY));
        if (buttonType == null) {
            buttonType = ButtonBar.ButtonType.OTHER;
        }
        typeCode = (typeCode = buttonType.getTypeCode()).length() > 0 ? typeCode.substring(0, 1) : "";
        return CATEGORIZED_TYPES.contains(typeCode.toUpperCase()) ? typeCode : ButtonBar.ButtonType.OTHER.getTypeCode();
    }

    private Map<String, List<ButtonBase>> buildButtonMap(List<? extends ButtonBase> buttons) {
        HashMap<String, List<ButtonBase>> buttonMap = new HashMap<String, List<ButtonBase>>();
        for (ButtonBase buttonBase : buttons) {
            if (buttonBase == null) continue;
            String type = this.getButtonType(buttonBase);
            ArrayList<ButtonBase> typedButtons = (ArrayList<ButtonBase>)buttonMap.get(type);
            if (typedButtons == null) {
                typedButtons = new ArrayList<ButtonBase>();
                buttonMap.put(type, typedButtons);
            }
            typedButtons.add(buttonBase);
        }
        return buttonMap;
    }

    private static enum Spacer {
        FIXED{

            @Override
            protected Node create(boolean edgeCase) {
                if (edgeCase) {
                    return null;
                }
                Region spacer = new Region();
                spacer.setMinWidth(10.0);
                HBox.setHgrow((Node)spacer, (Priority)Priority.NEVER);
                return spacer;
            }
        }
        ,
        DYNAMIC{

            @Override
            protected Node create(boolean edgeCase) {
                Region spacer = new Region();
                spacer.setMinWidth(edgeCase ? 0.0 : 10.0);
                HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                return spacer;
            }

            @Override
            public Spacer replace(Spacer spacer) {
                return FIXED == spacer ? this : spacer;
            }
        }
        ,
        NONE;


        protected Node create(boolean edgeCase) {
            return null;
        }

        public Spacer replace(Spacer spacer) {
            return spacer;
        }

        public void add(Pane pane, boolean edgeCase) {
            Node spacer = this.create(edgeCase);
            if (spacer != null) {
                pane.getChildren().add((Object)spacer);
            }
        }
    }
}

