/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.TextFieldBehavior;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import org.controlsfx.control.CustomTextField;

public class CustomTextFieldSkin
extends TextFieldSkin {
    private static final PseudoClass HAS_NO_SIDE_NODE = PseudoClass.getPseudoClass((String)"no-side-nodes");
    private static final PseudoClass HAS_LEFT_NODE = PseudoClass.getPseudoClass((String)"left-node-visible");
    private static final PseudoClass HAS_RIGHT_NODE = PseudoClass.getPseudoClass((String)"right-node-visible");
    private Node left;
    private StackPane leftPane;
    private Node right;
    private StackPane rightPane;
    private final CustomTextField control;

    public CustomTextFieldSkin(CustomTextField control) {
        super((TextField)control, new TextFieldBehavior((TextField)control));
        this.control = control;
        this.updateChildren();
        this.registerChangeListener((ObservableValue)control.leftProperty(), "LEFT_NODE");
        this.registerChangeListener((ObservableValue)control.rightProperty(), "RIGHT_NODE");
        this.registerChangeListener((ObservableValue)control.focusedProperty(), "FOCUSED");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if (p == "LEFT_NODE" || p == "RIGHT_NODE") {
            this.updateChildren();
        }
    }

    private void updateChildren() {
        Node newRight;
        Node newLeft = this.control.getLeft();
        if (newLeft != null) {
            this.leftPane = new StackPane(new Node[]{newLeft});
            this.leftPane.setAlignment(Pos.CENTER_LEFT);
            this.leftPane.getStyleClass().add((Object)"left-pane");
            this.getChildren().remove((Object)this.left);
            this.getChildren().add((Object)this.leftPane);
            this.left = newLeft;
        }
        if ((newRight = this.control.getRight()) != null) {
            this.rightPane = new StackPane(new Node[]{newRight});
            this.rightPane.setAlignment(Pos.CENTER_RIGHT);
            this.rightPane.getStyleClass().add((Object)"right-pane");
            this.getChildren().remove((Object)this.right);
            this.getChildren().add((Object)this.rightPane);
            this.right = newRight;
        }
        this.control.pseudoClassStateChanged(HAS_LEFT_NODE, this.left != null);
        this.control.pseudoClassStateChanged(HAS_RIGHT_NODE, this.right != null);
        this.control.pseudoClassStateChanged(HAS_NO_SIDE_NODE, this.left == null && this.right == null);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double fullHeight = h + this.snappedTopInset() + this.snappedBottomInset();
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(fullHeight));
        double rightWidth = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefWidth(fullHeight));
        double textFieldStartX = this.snapPosition(x) + this.snapSize(leftWidth);
        double textFieldWidth = w - this.snapSize(leftWidth) - this.snapSize(rightWidth);
        super.layoutChildren(textFieldStartX, 0.0, textFieldWidth, fullHeight);
        if (this.leftPane != null) {
            double leftStartX = 0.0;
            this.leftPane.resizeRelocate(0.0, 0.0, leftWidth, fullHeight);
        }
        if (this.rightPane != null) {
            double rightStartX = this.rightPane == null ? 0.0 : w - rightWidth + this.snappedLeftInset();
            this.rightPane.resizeRelocate(rightStartX, 0.0, rightWidth, fullHeight);
        }
    }

    protected double computePrefWidth(double h, double topInset, double rightInset, double bottomInset, double leftInset) {
        double pw = super.computePrefWidth(h, topInset, rightInset, bottomInset, leftInset);
        double leftWidth = this.leftPane == null ? 0.0 : this.snapSize(this.leftPane.prefWidth(h));
        double rightWidth = this.rightPane == null ? 0.0 : this.snapSize(this.rightPane.prefWidth(h));
        return pw + leftWidth + rightWidth + leftInset + rightInset;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }
}

