/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import impl.org.controlsfx.skin.GridRow;
import java.util.Collections;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.controlsfx.control.GridCell;
import org.controlsfx.control.GridView;

public class GridRowSkin<T>
extends CellSkinBase<GridRow<T>, CellBehaviorBase<GridRow<T>>> {
    public GridRowSkin(GridRow<T> control) {
        super(control, new CellBehaviorBase(control, Collections.emptyList()));
        this.updateCells();
        this.registerChangeListener((ObservableValue)((GridRow)this.getSkinnable()).indexProperty(), "INDEX");
        this.registerChangeListener((ObservableValue)((GridRow)this.getSkinnable()).widthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)((GridRow)this.getSkinnable()).heightProperty(), "HEIGHT");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("INDEX".equals(p)) {
            this.updateCells();
        } else if ("WIDTH".equals(p)) {
            this.updateCells();
        } else if ("HEIGHT".equals(p)) {
            this.updateCells();
        }
    }

    public void updateCells() {
        this.getChildren().clear();
        int startCellIndex = ((GridRow)this.getSkinnable()).indexProperty().get() * this.computeMaxCellsInRow();
        int endCellIndex = startCellIndex + this.computeMaxCellsInRow() - 1;
        if (((GridRow)this.getSkinnable()).indexProperty().get() >= 0) {
            int cellIndex = startCellIndex;
            while (cellIndex <= endCellIndex) {
                if (cellIndex < ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getItems().size()) {
                    GridCell<T> cell = this.createCell();
                    cell.updateGridView(((GridRow)this.getSkinnable()).getGridView());
                    cell.updateIndex(cellIndex);
                    this.getChildren().add(cell);
                }
                ++cellIndex;
            }
        }
        ((GridRow)this.getSkinnable()).requestLayout();
    }

    private GridCell<T> createCell() {
        GridCell cell = ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getCellFactory() != null ? (GridCell)((Object)((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getCellFactory().call((Object)((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())))) : this.createDefaultCellImpl();
        return cell;
    }

    private GridCell<T> createDefaultCellImpl() {
        return new GridCell<T>(){

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setText(item.toString());
                }
            }
        };
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        GridView gv = (GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get());
        return gv.getCellHeight() + gv.getVerticalCellSpacing() * 2.0;
    }

    public int computeMaxCellsInRow() {
        return this.computeMaxCellsInRow(((GridRow)this.getSkinnable()).getWidth());
    }

    protected int computeMaxCellsInRow(double width) {
        return Math.max((int)Math.floor(width / this.computeCellWidth()), 1);
    }

    protected double computeCellWidth() {
        return ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).cellWidthProperty().doubleValue() + ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).horizontalCellSpacingProperty().doubleValue() + ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).horizontalCellSpacingProperty().doubleValue();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double cellWidth = ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getCellWidth();
        double cellHeight = ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getCellHeight();
        double horizontalCellSpacing = ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getHorizontalCellSpacing();
        double verticalCellSpacing = ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getVerticalCellSpacing();
        double xPos = 0.0;
        double yPos = 0.0;
        for (Node child : this.getChildren()) {
            child.relocate(xPos + horizontalCellSpacing, yPos + verticalCellSpacing);
            child.resize(cellWidth, cellHeight);
            xPos = xPos + horizontalCellSpacing + cellWidth + horizontalCellSpacing;
        }
    }
}

