/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import impl.org.controlsfx.behavior.GridViewBehavior;
import impl.org.controlsfx.skin.GridRow;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.util.Callback;
import org.controlsfx.control.GridView;

public class GridViewSkin<T>
extends VirtualContainerBase<GridView<T>, GridViewBehavior<T>, GridRow<T>> {
    private final ListChangeListener<T> gridViewItemsListener = new ListChangeListener<T>(){

        public void onChanged(ListChangeListener.Change<? extends T> change) {
            GridViewSkin.this.updateRowCount();
            ((GridView)GridViewSkin.this.getSkinnable()).requestLayout();
        }
    };
    private final WeakListChangeListener<T> weakGridViewItemsListener = new WeakListChangeListener(this.gridViewItemsListener);

    public GridViewSkin(GridView<T> control) {
        super(control, new GridViewBehavior<T>(control));
        this.updateGridViewItems();
        this.flow.setId("virtual-flow");
        this.flow.setPannable(false);
        this.flow.setVertical(true);
        this.flow.setFocusTraversable(((GridView)this.getSkinnable()).isFocusTraversable());
        this.flow.setCreateCell(new Callback<VirtualFlow, GridRow<T>>(){

            public GridRow<T> call(VirtualFlow flow) {
                return GridViewSkin.this.createCell();
            }
        });
        this.getChildren().add((Object)this.flow);
        this.updateRowCount();
        this.registerChangeListener((ObservableValue)control.itemsProperty(), "ITEMS");
        this.registerChangeListener((ObservableValue)control.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener((ObservableValue)control.parentProperty(), "PARENT");
        this.registerChangeListener((ObservableValue)control.cellHeightProperty(), "CELL_HEIGHT");
        this.registerChangeListener((ObservableValue)control.cellWidthProperty(), "CELL_WIDTH");
        this.registerChangeListener((ObservableValue)control.horizontalCellSpacingProperty(), "HORIZONZAL_CELL_SPACING");
        this.registerChangeListener((ObservableValue)control.verticalCellSpacingProperty(), "VERTICAL_CELL_SPACING");
        this.registerChangeListener((ObservableValue)control.widthProperty(), "WIDTH_PROPERTY");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if (p == "ITEMS") {
            this.updateGridViewItems();
        } else if (p == "CELL_FACTORY") {
            this.flow.recreateCells();
        } else if (p == "CELL_HEIGHT") {
            this.flow.recreateCells();
        } else if (p == "CELL_WIDTH") {
            this.updateRowCount();
            this.flow.recreateCells();
        } else if (p == "HORIZONZAL_CELL_SPACING") {
            this.updateRowCount();
            this.flow.recreateCells();
        } else if (p == "VERTICAL_CELL_SPACING") {
            this.flow.recreateCells();
        } else if (p == "PARENT") {
            if (((GridView)this.getSkinnable()).getParent() != null && ((GridView)this.getSkinnable()).isVisible()) {
                ((GridView)this.getSkinnable()).requestLayout();
            }
        } else if (p == "WIDTH_PROPERTY") {
            this.updateRowCount();
        }
    }

    public void updateGridViewItems() {
        if (((GridView)this.getSkinnable()).getItems() != null) {
            ((GridView)this.getSkinnable()).getItems().removeListener(this.weakGridViewItemsListener);
        }
        if (((GridView)this.getSkinnable()).getItems() != null) {
            ((GridView)this.getSkinnable()).getItems().addListener(this.weakGridViewItemsListener);
        }
        this.updateRowCount();
        ((GridView)this.getSkinnable()).requestLayout();
    }

    protected void updateRowCount() {
        if (this.flow == null) {
            return;
        }
        int oldCount = this.flow.getCellCount();
        int newCount = this.getItemCount();
        if (newCount != oldCount) {
            this.flow.setCellCount(newCount);
            this.flow.recreateCells();
        } else {
            this.flow.reconfigureCells();
        }
        this.updateRows(newCount);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double x1 = ((GridView)this.getSkinnable()).getInsets().getLeft();
        double y1 = ((GridView)this.getSkinnable()).getInsets().getTop();
        double w1 = ((GridView)this.getSkinnable()).getWidth() - (((GridView)this.getSkinnable()).getInsets().getLeft() + ((GridView)this.getSkinnable()).getInsets().getRight());
        double h1 = ((GridView)this.getSkinnable()).getHeight() - (((GridView)this.getSkinnable()).getInsets().getTop() + ((GridView)this.getSkinnable()).getInsets().getBottom());
        this.flow.resizeRelocate(x1, y1, w1, h1);
    }

    public GridRow<T> createCell() {
        GridRow row = new GridRow();
        row.updateGridView((GridView)this.getSkinnable());
        return row;
    }

    public int getItemCount() {
        GridView gv = (GridView)this.getSkinnable();
        ObservableList items = gv.getItems();
        return items == null ? 0 : items.size() / this.computeMaxCellsInRow(gv.getWidth());
    }

    public int computeMaxCellsInRow(double width) {
        return Math.max((int)Math.floor(width / this.computeCellWidth()), 1);
    }

    protected double computeCellWidth() {
        return ((GridView)this.getSkinnable()).cellWidthProperty().doubleValue() + ((GridView)this.getSkinnable()).horizontalCellSpacingProperty().doubleValue() + ((GridView)this.getSkinnable()).horizontalCellSpacingProperty().doubleValue();
    }

    protected void updateRows(int rowCount) {
        int i = 0;
        while (i < rowCount) {
            GridRow row = (GridRow)this.flow.getVisibleCell(i);
            if (row != null) {
                row.updateIndex(-1);
                row.updateIndex(i);
            }
            ++i;
        }
    }

    protected boolean areRowsVisible() {
        if (this.flow == null) {
            return false;
        }
        if (this.flow.getFirstVisibleCell() == null) {
            return false;
        }
        return this.flow.getLastVisibleCell() != null;
    }

    protected double computeMinHeight(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 0.0;
    }
}

