/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.Collections;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.controlsfx.control.ButtonBar;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.action.ActionUtils;

public class NotificationPaneSkin
extends BehaviorSkinBase<NotificationPane, BehaviorBase<NotificationPane>> {
    private NotificationBar notificationBar;
    private Node content;

    public NotificationPaneSkin(NotificationPane control) {
        super((Control)control, new BehaviorBase((Control)control, Collections.emptyList()));
        this.notificationBar = new NotificationBar(control);
        this.updateContent();
        this.registerChangeListener((ObservableValue)control.contentProperty(), "CONTENT");
        this.registerChangeListener((ObservableValue)control.textProperty(), "TEXT");
        this.registerChangeListener((ObservableValue)control.graphicProperty(), "GRAPHIC");
        this.registerChangeListener((ObservableValue)control.showingProperty(), "SHOWING");
        this.registerChangeListener((ObservableValue)control.showFromTopProperty(), "SHOW_FROM_TOP");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("CONTENT".equals(p)) {
            this.updateContent();
        } else if ("TEXT".equals(p)) {
            this.notificationBar.label.setText(((NotificationPane)this.getSkinnable()).getText());
        } else if ("GRAPHIC".equals(p)) {
            this.notificationBar.label.setGraphic(((NotificationPane)this.getSkinnable()).getGraphic());
        } else if ("SHOWING".equals(p)) {
            if (((NotificationPane)this.getSkinnable()).isShowing()) {
                this.notificationBar.show();
            } else {
                this.notificationBar.hide();
            }
        } else if ("SHOW_FROM_TOP".equals(p) && ((NotificationPane)this.getSkinnable()).isShowing()) {
            ((NotificationPane)this.getSkinnable()).requestLayout();
        }
    }

    private void updateContent() {
        if (this.content != null) {
            this.getChildren().remove((Object)this.content);
        }
        this.content = ((NotificationPane)this.getSkinnable()).getContent();
        if (this.content == null) {
            this.getChildren().setAll((Object[])new Node[]{this.notificationBar});
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.content, this.notificationBar});
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double notificationBarHeight = this.notificationBar.prefHeight(w);
        if (((NotificationPane)this.getSkinnable()).isShowFromTop()) {
            this.notificationBar.resizeRelocate(x, y - (1.0 - this.notificationBar.transition.get()) * notificationBarHeight, w, notificationBarHeight);
        } else {
            this.notificationBar.resizeRelocate(x, h - notificationBarHeight, w, notificationBarHeight);
        }
        if (this.content != null) {
            this.content.resizeRelocate(x, y, w, h);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.minWidth(height);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.minHeight(width);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.prefWidth(height);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.prefHeight(width);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.maxWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.content == null ? 0.0 : this.content.maxHeight(width);
    }

    static class NotificationBar
    extends Region {
        private static final double MIN_HEIGHT = 40.0;
        private final NotificationPane notificationPane;
        private final Label label;
        private ButtonBar actionsBar;
        private final Button closeBtn;
        private final GridPane pane;
        private final Duration TRANSITION_DURATION = new Duration(350.0);
        private Timeline timeline;
        private double transitionStartValue;
        private DoubleProperty transition = new SimpleDoubleProperty(){

            protected void invalidated() {
                NotificationBar.this.notificationPane.requestLayout();
            }
        };

        public NotificationBar(final NotificationPane notificationPane) {
            this.notificationPane = notificationPane;
            this.pane = new GridPane();
            this.pane.getStyleClass().add((Object)"notification-bar");
            this.pane.setAlignment(Pos.BASELINE_LEFT);
            this.pane.setVisible(notificationPane.isShowing());
            this.getChildren().setAll((Object[])new Node[]{this.pane});
            this.label = new Label();
            this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            GridPane.setVgrow((Node)this.label, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
            this.label.setText(notificationPane.getText());
            this.label.setGraphic(notificationPane.getGraphic());
            this.label.opacityProperty().bind((ObservableValue)this.transition);
            notificationPane.getActions().addListener(new InvalidationListener(){

                public void invalidated(Observable arg0) {
                    NotificationBar.this.updatePane();
                }
            });
            this.closeBtn = new Button();
            this.closeBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    notificationPane.hide();
                }
            });
            this.closeBtn.getStyleClass().setAll((Object[])new String[]{"close-button"});
            StackPane graphic = new StackPane();
            graphic.getStyleClass().setAll((Object[])new String[]{"graphic"});
            this.closeBtn.setGraphic((Node)graphic);
            this.closeBtn.setMinSize(17.0, 17.0);
            this.closeBtn.setPrefSize(17.0, 17.0);
            this.closeBtn.opacityProperty().bind((ObservableValue)this.transition);
            GridPane.setMargin((Node)this.closeBtn, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
            this.updatePane();
        }

        private void updatePane() {
            this.actionsBar = ActionUtils.createButtonBar(this.notificationPane.getActions());
            this.actionsBar.opacityProperty().bind((ObservableValue)this.transition);
            GridPane.setHgrow((Node)this.actionsBar, (Priority)Priority.SOMETIMES);
            this.pane.getChildren().clear();
            this.pane.add((Node)this.label, 0, 0);
            this.pane.add((Node)this.actionsBar, 1, 0);
            this.pane.add((Node)this.closeBtn, 2, 0);
        }

        protected void layoutChildren() {
            double w = this.getWidth();
            double h = this.computePrefHeight(-1.0);
            this.pane.resize(w, h);
        }

        protected double computeMinHeight(double width) {
            return super.computePrefHeight(width);
        }

        protected double computePrefHeight(double width) {
            if (this.notificationPane.isShowFromTop()) {
                return 40.0;
            }
            return Math.max(this.pane.prefHeight(width), 40.0) * this.transition.get();
        }

        private void show() {
            this.transitionStartValue = 0.0;
            this.doAnimationTransition();
        }

        private void hide() {
            this.transitionStartValue = 1.0;
            this.doAnimationTransition();
        }

        private void doAnimationTransition() {
            KeyFrame k2;
            KeyFrame k1;
            Duration duration;
            if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
                duration = this.timeline.getCurrentTime();
                duration = duration == Duration.ZERO ? this.TRANSITION_DURATION : duration;
                this.transitionStartValue = this.transition.get();
                this.timeline.stop();
            } else {
                duration = this.TRANSITION_DURATION;
            }
            this.timeline = new Timeline();
            this.timeline.setCycleCount(1);
            if (this.notificationPane.isShowing()) {
                k1 = new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        NotificationBar.this.pane.setCache(true);
                        NotificationBar.this.pane.setVisible(true);
                        NotificationBar.this.pane.fireEvent(new Event(NotificationPane.ON_SHOWING));
                    }
                }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
                k2 = new KeyFrame(duration, (EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        NotificationBar.this.pane.setCache(false);
                        NotificationBar.this.pane.fireEvent(new Event(NotificationPane.ON_SHOWN));
                    }
                }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)1, Interpolator.EASE_OUT)});
            } else {
                k1 = new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        NotificationBar.this.pane.setCache(true);
                        NotificationBar.this.pane.fireEvent(new Event(NotificationPane.ON_HIDING));
                    }
                }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
                k2 = new KeyFrame(duration, (EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        NotificationBar.this.pane.setCache(false);
                        NotificationBar.this.pane.setVisible(false);
                        NotificationBar.this.pane.fireEvent(new Event(NotificationPane.ON_HIDDEN));
                    }
                }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)0, Interpolator.EASE_IN)});
            }
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{k1, k2});
            this.timeline.play();
        }
    }
}

