/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.Collections;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.controlsfx.control.SegmentedButton;

public class SegmentedButtonSkin
extends BehaviorSkinBase<SegmentedButton, BehaviorBase<SegmentedButton>> {
    private final ToggleGroup group = new ToggleGroup();
    private final HBox container = new HBox();

    public SegmentedButtonSkin(SegmentedButton control) {
        super((Control)control, new BehaviorBase((Control)control, Collections.emptyList()));
        this.getChildren().add((Object)this.container);
        this.updateButtons();
        this.getButtons().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                SegmentedButtonSkin.this.updateButtons();
            }
        });
    }

    private ObservableList<ToggleButton> getButtons() {
        return ((SegmentedButton)this.getSkinnable()).getButtons();
    }

    private void updateButtons() {
        ObservableList<ToggleButton> buttons = this.getButtons();
        int i = 0;
        while (i < this.getButtons().size()) {
            ToggleButton t = (ToggleButton)buttons.get(i);
            t.setToggleGroup(this.group);
            this.container.getChildren().add((Object)t);
            if (i == buttons.size() - 1) {
                if (i == 0) {
                    t.getStyleClass().add((Object)"only-button");
                } else {
                    t.getStyleClass().add((Object)"right-pill");
                }
            } else if (i == 0) {
                t.getStyleClass().add((Object)"left-pill");
            } else {
                t.getStyleClass().add((Object)"center-pill");
            }
            ++i;
        }
    }
}

