/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.GridCellEditor;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class CellView
extends TableCell<ObservableList<SpreadsheetCell>, SpreadsheetCell> {
    private final SpreadsheetHandle handle;
    private static final String ANCHOR_PROPERTY_KEY = "table.anchor";

    static TablePositionBase<?> getAnchor(Control table, TablePositionBase<?> focusedCell) {
        return CellView.hasAnchor(table) ? (TablePositionBase)table.getProperties().get((Object)ANCHOR_PROPERTY_KEY) : focusedCell;
    }

    static boolean hasAnchor(Control table) {
        return table.getProperties().get((Object)ANCHOR_PROPERTY_KEY) != null;
    }

    public CellView(SpreadsheetHandle handle) {
        this.handle = handle;
        this.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                int row = CellView.this.getIndex();
                if (CellView.this.getItem() == null) {
                    CellView.this.getTableRow().requestLayout();
                } else if (((SpreadsheetCell)CellView.this.getItem()).getRowSpan() > 1) {
                    if (t1.booleanValue() && row != ((SpreadsheetCell)CellView.this.getItem()).getRow()) {
                        CellView.this.hoverGridCell((SpreadsheetCell)CellView.this.getItem());
                    } else if (!t1.booleanValue() && row != ((SpreadsheetCell)CellView.this.getItem()).getRow()) {
                        CellView.this.unHoverGridCell();
                    }
                }
            }
        });
        this.addEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                CellView.this.startFullDrag();
            }
        });
        this.setOnMouseDragEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                CellView.this.dragSelect(arg0);
            }
        });
    }

    public void startEdit() {
        if (!this.isEditable()) {
            return;
        }
        int column = this.getTableView().getColumns().indexOf((Object)this.getTableColumn());
        int row = this.getIndex();
        SpreadsheetView spv = this.handle.getView();
        GridViewSkin gvs = this.handle.getCellsViewSkin();
        Grid grid = spv.getGrid();
        SpreadsheetView.SpanType type = grid.getSpanType(spv, row, column);
        if (type == SpreadsheetView.SpanType.NORMAL_CELL || type == SpreadsheetView.SpanType.ROW_VISIBLE) {
            GridCellEditor editor;
            if (spv.getFixedRows().contains((Object)row)) {
                boolean flag = false;
                int j = 0;
                while (j < gvs.getCellsSize()) {
                    if (gvs.getRow(j) == this.getTableRow()) {
                        flag = true;
                    }
                    ++j;
                }
                if (!flag) {
                    this.getTableRow().setManaged(false);
                    return;
                }
            }
            if ((editor = this.getEditor((SpreadsheetCell)this.getItem(), spv)) != null) {
                super.startEdit();
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                editor.startEdit();
            }
        }
    }

    private GridCellEditor getEditor(SpreadsheetCell cell, SpreadsheetView spv) {
        SpreadsheetCellType<?> cellType = cell.getCellType();
        SpreadsheetCellEditor<?> cellEditor = spv.getEditor(cellType);
        GridCellEditor editor = this.handle.getCellsViewSkin().getSpreadsheetCellEditorImpl();
        if (editor.isEditing()) {
            return null;
        }
        editor.updateSpreadsheetCell(this);
        editor.updateDataCell(cell);
        editor.updateSpreadsheetCellEditor(cellEditor);
        return editor;
    }

    public void commitEdit(SpreadsheetCell newValue) {
        if (!this.isEditing()) {
            return;
        }
        super.commitEdit((Object)newValue);
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.updateItem(newValue, false);
    }

    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        super.cancelEdit();
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                CellView.this.getTableView().requestFocus();
            }
        };
        Platform.runLater((Runnable)r);
    }

    public void updateItem(SpreadsheetCell item, boolean empty) {
        boolean emptyRow;
        boolean bl = emptyRow = this.getTableView().getItems().size() < this.getIndex() + 1;
        if (!this.isEditing()) {
            super.updateItem((Object)item, empty && emptyRow);
        }
        if (empty && this.isSelected()) {
            this.updateSelected(false);
        }
        if (empty && emptyRow) {
            this.setText(null);
            this.setContentDisplay(null);
        } else if (!this.isEditing() && item != null) {
            this.show(item);
            if (this.isHover()) {
                this.setHoverPublic(false);
            }
        }
    }

    void setHoverPublic(boolean hover) {
        this.setHover(hover);
        ((GridRow)this.getTableRow()).setHoverPublic(hover);
    }

    public String toString() {
        return String.valueOf(((SpreadsheetCell)this.getItem()).getRow()) + "/" + ((SpreadsheetCell)this.getItem()).getColumn();
    }

    public void show(SpreadsheetCell item) {
        this.setText(item.getText());
        this.setEditable(item.isEditable());
        this.getStyleClass().clear();
        this.getStyleClass().add((Object)"spreadsheet-cell");
        this.getStyleClass().addAll(item.getStyleClass());
    }

    public void show() {
        if (this.getItem() != null) {
            this.show((SpreadsheetCell)this.getItem());
        }
    }

    private void hoverGridCell(SpreadsheetCell cell) {
        GridRow rightRow;
        SpreadsheetView spv = this.handle.getView();
        GridViewSkin sps = this.handle.getCellsViewSkin();
        GridRow row = sps.getRow(spv.getFixedRows().size());
        CellView gridCell = sps.getCellsSize() != 0 && row.getIndex() <= cell.getRow() ? ((rightRow = sps.getRow(spv.getFixedRows().size() + cell.getRow() - row.getIndex())) != null ? rightRow.getGridCell(cell.getColumn()) : row.getGridCell(cell.getColumn())) : row.getGridCell(cell.getColumn());
        if (gridCell != null) {
            gridCell.setHoverPublic(true);
            GridCellEditor editor = sps.getSpreadsheetCellEditorImpl();
            editor.setLastHover(gridCell);
        }
    }

    private void unHoverGridCell() {
        GridViewSkin sps = this.handle.getCellsViewSkin();
        GridCellEditor editor = sps.getSpreadsheetCellEditorImpl();
        CellView lastHover = editor.getLastHover();
        if (editor.getLastHover() != null) {
            lastHover.setHoverPublic(false);
        }
    }

    private void dragSelect(MouseEvent e) {
        if (!this.contains(e.getX(), e.getY())) {
            return;
        }
        TableView tableView = this.getTableView();
        if (tableView == null) {
            return;
        }
        int count = tableView.getItems().size();
        if (this.getIndex() >= count) {
            return;
        }
        TableView.TableViewSelectionModel sm = tableView.getSelectionModel();
        if (sm == null) {
            return;
        }
        int row = this.getIndex();
        int column = tableView.getVisibleLeafIndex(this.getTableColumn());
        SpreadsheetCell cell = (SpreadsheetCell)this.getItem();
        int rowCell = cell.getRow() + cell.getRowSpan() - 1;
        int columnCell = cell.getColumn() + cell.getColumnSpan() - 1;
        TableView.TableViewFocusModel fm = tableView.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePosition focusedCell = fm.getFocusedCell();
        MouseButton button = e.getButton();
        if (button == MouseButton.PRIMARY) {
            TablePositionBase<?> anchor = CellView.getAnchor((Control)tableView, focusedCell);
            int minRow = Math.min(anchor.getRow(), row);
            minRow = Math.min(minRow, rowCell);
            int maxRow = Math.max(anchor.getRow(), row);
            maxRow = Math.max(maxRow, rowCell);
            int minColumn = Math.min(anchor.getColumn(), column);
            minColumn = Math.min(minColumn, columnCell);
            int maxColumn = Math.max(anchor.getColumn(), column);
            maxColumn = Math.max(maxColumn, columnCell);
            sm.clearSelection();
            int _row = minRow;
            while (_row <= maxRow) {
                int _col = minColumn;
                while (_col <= maxColumn) {
                    sm.select(_row, (TableColumnBase)tableView.getVisibleLeafColumn(_col));
                    ++_col;
                }
                ++_row;
            }
        }
    }
}

