/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.scene.Node;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridCellEditor {
    private final SpreadsheetHandle handle;
    private SpreadsheetCell modelCell;
    private CellView viewCell;
    private SpreadsheetEditor spreadsheetEditor;
    private InvalidationListener editorListener;
    private InvalidationListener il;
    private boolean editing = false;
    private SpreadsheetCellEditor<?> spreadsheetCellEditor;
    private CellView lastHover = null;

    public GridCellEditor(SpreadsheetHandle handle) {
        this.handle = handle;
        this.spreadsheetEditor = new SpreadsheetEditor();
    }

    public void updateDataCell(SpreadsheetCell cell) {
        this.modelCell = cell;
    }

    public void updateSpreadsheetCell(CellView cell) {
        this.viewCell = cell;
    }

    public void updateSpreadsheetCellEditor(SpreadsheetCellEditor<?> spreadsheetCellEditor2) {
        this.spreadsheetCellEditor = spreadsheetCellEditor2;
    }

    public CellView getLastHover() {
        return this.lastHover;
    }

    public void setLastHover(CellView lastHover) {
        this.lastHover = lastHover;
    }

    public void endEdit(boolean b) {
        if (b) {
            SpreadsheetView view = this.handle.getView();
            Object value = this.modelCell.getCellType().convertValue(this.spreadsheetCellEditor.getControlValue());
            if (value != null && this.viewCell != null) {
                if (!this.modelCell.getItem().equals(value) && !view.getModifiedCells().contains((Object)this.modelCell)) {
                    view.getModifiedCells().add((Object)this.modelCell);
                }
                this.modelCell.setItem(value);
                this.viewCell.commitEdit(this.modelCell);
                this.end();
                this.spreadsheetCellEditor.end();
            }
        } else if (this.viewCell != null) {
            this.viewCell.cancelEdit();
            this.end();
            this.spreadsheetCellEditor.end();
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    public SpreadsheetCell getModelCell() {
        return this.modelCell;
    }

    void startEdit() {
        this.editing = true;
        this.spreadsheetEditor.startEdit();
        this.il = new InvalidationListener(){

            public void invalidated(Observable observable) {
                GridCellEditor.this.endEdit(false);
            }
        };
        this.viewCell.selectedProperty().addListener(this.il);
        this.editorListener = new InvalidationListener(){

            public void invalidated(Observable arg0) {
                GridCellEditor.this.endEdit(false);
            }
        };
        this.handle.getCellsViewSkin().getVBar().valueProperty().addListener(this.editorListener);
        this.handle.getView().disabledProperty().addListener(this.editorListener);
        this.viewCell.setGraphic((Node)this.spreadsheetCellEditor.getEditor());
        Object value = this.modelCell.getItem();
        this.spreadsheetCellEditor.startEdit(value);
    }

    private void end() {
        this.editing = false;
        this.spreadsheetEditor.end();
        if (this.viewCell != null) {
            this.viewCell.selectedProperty().removeListener(this.il);
        }
        this.il = null;
        this.handle.getCellsViewSkin().getVBar().valueProperty().removeListener(this.editorListener);
        this.handle.getView().disabledProperty().removeListener(this.editorListener);
        this.editorListener = null;
        this.modelCell = null;
        this.viewCell = null;
    }

    private class SpreadsheetEditor {
        private GridRow original;
        private boolean isMoved;

        private SpreadsheetEditor() {
        }

        private int getCellCount() {
            return GridCellEditor.this.handle.getCellsViewSkin().getCellsSize();
        }

        private boolean addCell(CellView cell) {
            GridRow temp = GridCellEditor.this.handle.getCellsViewSkin().getRow(this.getCellCount() - 1 - GridCellEditor.this.handle.getView().getFixedRows().size());
            if (temp != null) {
                temp.addCell(cell);
                return true;
            }
            return false;
        }

        public void startEdit() {
            if (GridCellEditor.this.modelCell != null && GridCellEditor.this.modelCell.getRowSpan() > 1 && GridCellEditor.this.modelCell.getRow() != this.getCellCount() - 1) {
                this.original = (GridRow)GridCellEditor.this.viewCell.getTableRow();
                double temp = GridCellEditor.this.viewCell.getLocalToSceneTransform().getTy();
                this.isMoved = this.addCell(GridCellEditor.this.viewCell);
                if (this.isMoved) {
                    GridCellEditor.this.viewCell.setTranslateY(temp - GridCellEditor.this.viewCell.getLocalToSceneTransform().getTy());
                    this.original.putFixedColumnToBack();
                }
            }
        }

        public void end() {
            if (GridCellEditor.this.modelCell != null && GridCellEditor.this.modelCell.getRowSpan() > 1) {
                GridCellEditor.this.viewCell.setTranslateY(0.0);
                if (this.isMoved) {
                    this.original.addCell(GridCellEditor.this.viewCell);
                    this.original.putFixedColumnToBack();
                }
            }
        }
    }
}

