/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRowSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.TableRow;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridRow
extends TableRow<ObservableList<SpreadsheetCell>> {
    private final SpreadsheetHandle handle;
    private int indexVirtualFlow = -1;
    private boolean layoutFixedColumns = false;
    private boolean currentlyFixed = false;

    public GridRow(SpreadsheetHandle handle) {
        this.handle = handle;
    }

    public int getIndexVirtualFlow() {
        return this.indexVirtualFlow < 0 ? this.getIndex() : this.indexVirtualFlow;
    }

    public void setIndexVirtualFlow(int i) {
        this.indexVirtualFlow = i;
    }

    public Boolean getCurrentlyFixed() {
        return this.currentlyFixed;
    }

    public void setCurrentlyFixed(boolean currentlyFixed) {
        this.currentlyFixed = currentlyFixed;
    }

    public void setLayoutFixedColumns(boolean b) {
        this.layoutFixedColumns = b;
    }

    public boolean getLayoutFixedColumns() {
        return this.layoutFixedColumns;
    }

    public void putFixedColumnToBack() {
        ArrayList<Node> tset = new ArrayList<Node>((Collection<Node>)this.getChildren());
        tset.sort(new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                int rhs;
                if (((CellView)o1).getItem() == null || ((CellView)o2).getItem() == null) {
                    return -1;
                }
                int lhs = GridRow.this.getTableView().getColumns().indexOf((Object)((CellView)o1).getTableColumn());
                if (lhs < (rhs = GridRow.this.getTableView().getColumns().indexOf((Object)((CellView)o2).getTableColumn()))) {
                    return -1;
                }
                if (lhs > rhs) {
                    return 1;
                }
                return 0;
            }
        });
        this.getChildren().setAll(tset);
    }

    public void addCell(CellView cell) {
        this.getChildren().add((Object)cell);
    }

    public void removeCell(CellView gc) {
        this.getChildren().remove((Object)gc);
    }

    SpreadsheetView getSpreadsheetView() {
        return this.handle.getView();
    }

    void setHoverPublic(boolean hover) {
        this.setHover(hover);
    }

    CellView getGridCell(int col) {
        for (Node node : this.getChildrenUnmodifiable()) {
            CellView cellView = (CellView)node;
            SpreadsheetCell cell = (SpreadsheetCell)cellView.getItem();
            if (cell.getColumn() != col) continue;
            return cellView;
        }
        return null;
    }

    protected Skin<?> createDefaultSkin() {
        return new GridRowSkin(this.handle, this);
    }
}

