/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.TableRowSkin;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridRowSkin
extends TableRowSkin<ObservableList<SpreadsheetCell>> {
    private final SpreadsheetHandle handle;

    public GridRowSkin(SpreadsheetHandle handle, GridRow gridRow) {
        super((TableRow)gridRow);
        this.handle = handle;
    }

    protected void handleControlPropertyChanged(String p) {
        if ("ITEM".equals(p)) {
            this.updateCells = true;
            ((TableRow)this.getSkinnable()).requestLayout();
        } else if (!"INDEX".equals(p)) {
            super.handleControlPropertyChanged(p);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        SpreadsheetView spreadsheetView = this.handle.getView();
        SpreadsheetGridView gridView = this.handle.getGridView();
        Grid grid = spreadsheetView.getGrid();
        GridRow control = (GridRow)this.getSkinnable();
        int index = control.getIndex();
        if (index < 0 || index >= gridView.getItems().size()) {
            control.setOpacity(0.0);
            return;
        }
        control.setOpacity(1.0);
        this.checkState(true);
        if (this.cellsMap.isEmpty()) {
            return;
        }
        ObservableList visibleLeafColumns = this.getVisibleLeafColumns();
        if (visibleLeafColumns.isEmpty()) {
            super.layoutChildren(x, y, w, h);
            return;
        }
        double headerWidth = gridView.getWidth();
        double verticalPadding = this.snappedTopInset() + this.snappedBottomInset();
        double horizontalPadding = this.snappedLeftInset() + this.snappedRightInset();
        double controlHeight = control.getHeight();
        double tableCellY = 0.0;
        int positionY = spreadsheetView.getFixedRows().indexOf((Object)index);
        if (positionY != -1 && ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy() <= (double)positionY * GridViewSkin.DEFAULT_CELL_HEIGHT) {
            tableCellY = (double)positionY * GridViewSkin.DEFAULT_CELL_HEIGHT - ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy();
            ((GridRow)this.getSkinnable()).setCurrentlyFixed(true);
        } else {
            ((GridRow)this.getSkinnable()).setCurrentlyFixed(false);
        }
        int rightPlace = 0;
        double fixedColumnWidth = 0.0;
        int column = 0;
        while (column < this.cells.size()) {
            block21: {
                double width;
                block22: {
                    CellView tableCell;
                    block20: {
                        boolean isVisible;
                        tableCell = (CellView)((Object)this.cells.get(column));
                        tableCell.setOpacity(1.0);
                        width = this.snapSize(tableCell.prefWidth(-1.0)) - this.snapSize(horizontalPadding);
                        double height = Math.max(controlHeight, tableCell.prefHeight(-1.0));
                        height = this.snapSize(height) - this.snapSize(verticalPadding);
                        double tableCellX = 0.0;
                        double hbarValue = this.handle.getCellsViewSkin().getHBar().getValue();
                        SpreadsheetCell cellSpan = (SpreadsheetCell)((ObservableList)grid.getRows().get(index)).get(column);
                        boolean bl = isVisible = !this.isInvisible(x, width, hbarValue, headerWidth, cellSpan.getColumnSpan());
                        if (((SpreadsheetColumn)spreadsheetView.getColumns().get(column)).isFixed() && hbarValue + fixedColumnWidth > x) {
                            tableCellX = Math.abs(hbarValue - x + fixedColumnWidth);
                            tableCell.toFront();
                            fixedColumnWidth += tableCell.getWidth();
                            isVisible = true;
                        }
                        if (!isVisible) break block20;
                        if (tableCell.getParent() == null) {
                            this.getChildren().add(rightPlace, (Object)tableCell);
                        }
                        ++rightPlace;
                        SpreadsheetView.SpanType spanType = grid.getSpanType(spreadsheetView, index, column);
                        switch (spanType) {
                            case ROW_SPAN_INVISIBLE: 
                            case BOTH_INVISIBLE: {
                                tableCell.setOpacity(0.0);
                                tableCell.resize(width, height);
                                tableCell.relocate(x + tableCellX, this.snappedTopInset() + tableCellY);
                                x += width;
                                break block21;
                            }
                            case COLUMN_SPAN_INVISIBLE: {
                                tableCell.setOpacity(0.0);
                                tableCell.resize(width, height);
                                tableCell.relocate(x + tableCellX, this.snappedTopInset() + tableCellY);
                                break block21;
                            }
                            case ROW_VISIBLE: {
                                TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> sm = spreadsheetView.getSelectionModel();
                                TableColumn col = (TableColumn)gridView.getColumns().get(column);
                                TablePosition<ObservableList<SpreadsheetCell>, ?> selectedPosition = this.isSelectedRange(index, col, column);
                                if (selectedPosition != null && selectedPosition.getRow() != index) {
                                    sm.clearSelection(selectedPosition.getRow(), selectedPosition.getTableColumn());
                                    sm.select(index, col);
                                }
                            }
                            case NORMAL_CELL: {
                                tableCell.show();
                            }
                            default: {
                                if (cellSpan != null) {
                                    if (cellSpan.getColumnSpan() > 1) {
                                        int i = 1;
                                        int colSpan = cellSpan.getColumnSpan();
                                        int max1 = this.cells.size() - column;
                                        while (i < colSpan && i < max1) {
                                            width += this.snapSize(((SpreadsheetColumn)spreadsheetView.getColumns().get(column + i)).getWidth());
                                            ++i;
                                        }
                                    }
                                    if (cellSpan.getRowSpan() > 1) {
                                        int i = 1;
                                        while (i < cellSpan.getRowSpan()) {
                                            double rowHeight = GridViewSkin.DEFAULT_CELL_HEIGHT;
                                            height += this.snapSize(rowHeight);
                                            ++i;
                                        }
                                    }
                                }
                                tableCell.resize(width, height);
                                double spaceBetweenTopAndMe = (double)(index - cellSpan.getRow()) * GridViewSkin.DEFAULT_CELL_HEIGHT;
                                tableCell.relocate(x + tableCellX, this.snappedTopInset() - spaceBetweenTopAndMe + tableCellY);
                                break;
                            }
                        }
                        break block22;
                    }
                    this.getChildren().remove((Object)tableCell);
                }
                x += width;
            }
            ++column;
        }
    }

    private boolean isInvisible(double x, double width, double hbarValue, double headerWidth, int columnSpan) {
        return x + width < hbarValue && columnSpan == 1 || x > hbarValue + headerWidth;
    }

    public TablePosition<ObservableList<SpreadsheetCell>, ?> isSelectedRange(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column, int col) {
        SpreadsheetGridView tableView = this.handle.getGridView();
        SpreadsheetView spreadsheetView = this.handle.getView();
        SpreadsheetCell cellSpan = (SpreadsheetCell)((ObservableList)tableView.getItems().get(row)).get(col);
        int infRow = cellSpan.getRow();
        int supRow = infRow + cellSpan.getRowSpan();
        int infCol = cellSpan.getColumn();
        int supCol = infCol + cellSpan.getColumnSpan();
        for (Object tp : spreadsheetView.getSelectionModel().getSelectedCells()) {
            TablePosition tp1 = (TablePosition)tp;
            if (tp1.getRow() < infRow || tp1.getRow() >= supRow || tp1.getColumn() < infCol || tp1.getColumn() >= supCol) continue;
            return tp1;
        }
        return null;
    }
}

