/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.CellSkinBase;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.scene.control.skin.VirtualScrollBar;
import impl.org.controlsfx.spreadsheet.GridCellEditor;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridVirtualFlow;
import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.VerticalHeader;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridViewSkin
extends TableViewSkin<ObservableList<SpreadsheetCell>> {
    static final double DEFAULT_CELL_HEIGHT;
    static final double DATE_CELL_MIN_WIDTH = 105.0;
    private final double DEFAULT_ROWHEADER_WIDTH = 50.0;
    private GridCellEditor spreadsheetCellEditorImpl;
    private final double rowHeaderWidth = 50.0;
    protected final SpreadsheetHandle handle;
    protected SpreadsheetView spreadsheetView;
    protected VerticalHeader rowHeader;
    final InvalidationListener vbarValueListener = new InvalidationListener(){

        public void invalidated(Observable valueModel) {
            GridViewSkin.this.verticalScroll();
        }
    };
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> c) {
            GridViewSkin.this.getFlow().layoutTotal();
        }
    };
    private final ListChangeListener<SpreadsheetColumn<?>> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn<?>>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn<?>> c) {
            if (GridViewSkin.this.spreadsheetView.getFixedColumns().size() > c.getList().size()) {
                int i = 0;
                while (i < GridViewSkin.this.getFlow().getCells().size()) {
                    ((GridRow)((Object)GridViewSkin.this.getFlow().getCells().get(i))).putFixedColumnToBack();
                    ++i;
                }
            }
            GridViewSkin.this.getFlow().layoutTotal();
        }
    };
    private final ObservableList<Integer> selectedRows = FXCollections.observableArrayList();
    private final ObservableList<Integer> selectedColumns = FXCollections.observableArrayList();

    static {
        double cell_size = 24.0;
        try {
            Class<CellSkinBase> clazz = CellSkinBase.class;
            Field f = clazz.getDeclaredField("DEFAULT_CELL_SIZE");
            f.setAccessible(true);
            cell_size = f.getDouble(null);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        DEFAULT_CELL_HEIGHT = cell_size;
    }

    public double getRowHeaderWidth() {
        return 50.0;
    }

    public GridViewSkin(final SpreadsheetHandle handle) {
        super((TableView)handle.getGridView());
        this.handle = handle;
        this.spreadsheetView = handle.getView();
        this.spreadsheetCellEditorImpl = new GridCellEditor(handle);
        SpreadsheetGridView tableView = handle.getGridView();
        tableView.setEditable(true);
        tableView.setRowFactory((Callback)new Callback<TableView<ObservableList<SpreadsheetCell>>, TableRow<ObservableList<SpreadsheetCell>>>(){

            public TableRow<ObservableList<SpreadsheetCell>> call(TableView<ObservableList<SpreadsheetCell>> p) {
                return new GridRow(handle);
            }
        });
        tableView.setFixedCellSize(this.getDefaultCellSize());
        tableView.getStyleClass().add((Object)"cell-spreadsheet");
        this.spreadsheetView.getFixedRows().addListener(this.fixedRowsListener);
        this.spreadsheetView.getFixedColumns().addListener(this.fixedColumnsListener);
        this.init();
    }

    protected void init() {
        this.getFlow().getVerticalBar().valueProperty().addListener(this.vbarValueListener);
        this.rowHeader = new VerticalHeader(this.handle, 50.0);
        this.getChildren().addAll((Object[])new Node[]{this.rowHeader});
        this.rowHeader.init(this);
        ((HorizontalHeader)this.getTableHeaderRow()).init();
        this.getFlow().init(this.spreadsheetView);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.spreadsheetView == null) {
            return;
        }
        if (this.spreadsheetView.showRowHeaderProperty().get()) {
            x += 50.0;
            w -= 50.0;
        }
        super.layoutChildren(x, y, w, h);
        double baselineOffset = ((TableView)this.getSkinnable()).getLayoutBounds().getHeight() / 2.0;
        double tableHeaderRowHeight = 0.0;
        if (this.spreadsheetView.showColumnHeaderProperty().get()) {
            tableHeaderRowHeight = this.getTableHeaderRow().prefHeight(-1.0);
            this.layoutInArea((Node)this.getTableHeaderRow(), x, y, w, tableHeaderRowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
            y += tableHeaderRowHeight;
        }
        if (this.spreadsheetView.showRowHeaderProperty().get()) {
            this.layoutInArea((Node)this.rowHeader, x - 50.0, y - tableHeaderRowHeight, w, h, baselineOffset, HPos.CENTER, VPos.CENTER);
        }
    }

    protected void verticalScroll() {
        this.rowHeader.updateScrollY();
    }

    protected void onFocusPreviousCell() {
        TableView.TableViewFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int row = fm.getFocusedIndex();
        if (!this.getFlow().getCells().isEmpty() && ((IndexedCell)this.getFlow().getCells().get(this.getFlow().getFixedRows().size())).getIndex() > row && !this.getFlow().getFixedRows().contains((Object)row)) {
            this.flow.scrollTo(row);
        } else {
            this.flow.show(row);
        }
        this.scrollHorizontally();
    }

    protected void onFocusNextCell() {
        TableView.TableViewFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int row = fm.getFocusedIndex();
        if (!this.getFlow().getCells().isEmpty() && ((IndexedCell)this.getFlow().getCells().get(this.getFlow().getFixedRows().size())).getIndex() > row && !this.getFlow().getFixedRows().contains((Object)row)) {
            this.flow.scrollTo(row);
        } else {
            this.flow.show(row);
        }
        this.scrollHorizontally();
    }

    protected void onSelectPreviousCell() {
        super.onSelectPreviousCell();
        this.scrollHorizontally();
    }

    protected void onSelectNextCell() {
        super.onSelectNextCell();
        this.scrollHorizontally();
    }

    public double getDefaultCellSize() {
        return DEFAULT_CELL_HEIGHT;
    }

    protected VirtualFlow<TableRow<ObservableList<SpreadsheetCell>>> createVirtualFlow() {
        return new GridVirtualFlow<TableRow<ObservableList<SpreadsheetCell>>>();
    }

    protected TableHeaderRow createTableHeaderRow() {
        return new HorizontalHeader(this);
    }

    BooleanProperty getTableMenuButtonVisibleProperty() {
        return this.tableMenuButtonVisibleProperty();
    }

    protected void scrollHorizontally(TableColumn<ObservableList<SpreadsheetCell>, ?> col) {
        double newPos;
        if (col == null || !col.isVisible()) {
            return;
        }
        double start = 0.0;
        for (TableColumnBase c : this.getVisibleLeafColumns()) {
            if (c.equals(col)) break;
            start += c.getWidth();
        }
        double fixedColumnWidth = this.getFixedColumnWidth();
        double end = start + col.getWidth();
        double headerWidth = ((TableView)this.getSkinnable()).getWidth() - this.snappedLeftInset() - this.snappedRightInset();
        double pos = this.getFlow().getHorizontalBar().getValue();
        double max = this.getFlow().getHorizontalBar().getMax();
        if (start < pos + fixedColumnWidth && start >= 0.0 && start >= fixedColumnWidth) {
            newPos = start - fixedColumnWidth < 0.0 ? start : start - fixedColumnWidth;
        } else {
            double delta = start < 0.0 || end > headerWidth ? start - pos - fixedColumnWidth : 0.0;
            newPos = pos + delta > max ? max : pos + delta;
        }
        this.getFlow().getHorizontalBar().setValue(newPos);
    }

    private double getFixedColumnWidth() {
        double fixedColumnWidth = 0.0;
        if (!this.spreadsheetView.getFixedColumns().isEmpty()) {
            int i = 0;
            int max = this.spreadsheetView.getFixedColumns().size();
            while (i < max) {
                TableColumn c = this.getVisibleLeafColumn(i);
                fixedColumnWidth += c.getWidth();
                ++i;
            }
        }
        return fixedColumnWidth;
    }

    public GridVirtualFlow<?> getFlow() {
        return (GridVirtualFlow)this.flow;
    }

    public GridRow getCell(int index) {
        return (GridRow)((Object)this.getFlow().getCells().get(index));
    }

    public int getCellsSize() {
        return this.getFlow().getCells().size();
    }

    public VirtualScrollBar getHBar() {
        return this.getFlow().getHorizontalBar();
    }

    public VirtualScrollBar getVBar() {
        return this.getFlow().getVerticalBar();
    }

    public GridRow getRow(int index) {
        return this.handle.getCellsViewSkin().getCell(index);
    }

    public ObservableList<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    public ObservableList<Integer> getSelectedColumns() {
        return this.selectedColumns;
    }

    public GridCellEditor getSpreadsheetCellEditorImpl() {
        return this.spreadsheetCellEditorImpl;
    }

    void resize(TableColumnBase<?, ?> tc) {
        this.resizeColumnToFitContent((TableColumn)this.getColumns().get(this.getColumns().indexOf(tc)), -1);
    }

    public void resizeColumnToFitContent(TableColumn<ObservableList<SpreadsheetCell>, ?> tc, int maxRows) {
        Node n;
        TableColumn<ObservableList<SpreadsheetCell>, ?> col = tc;
        List items = (List)this.itemsProperty().get();
        if (items == null || items.isEmpty()) {
            return;
        }
        Callback cellFactory = col.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        TableCell cell = (TableCell)cellFactory.call(col);
        if (cell == null) {
            return;
        }
        cell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
        double padding = 10.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedLeftInset() + r.snappedRightInset();
        }
        int rows = maxRows == -1 ? items.size() : Math.min(items.size(), maxRows);
        double maxWidth = 0.0;
        boolean datePresent = false;
        boolean listPresent = false;
        int row = 0;
        while (row < rows) {
            cell.updateTableColumn(col);
            cell.updateTableView((TableView)this.handle.getGridView());
            cell.updateIndex(row);
            if (cell.getText() != null && !cell.getText().isEmpty() || cell.getGraphic() != null) {
                this.getChildren().add((Object)cell);
                if (((SpreadsheetCell)cell.getItem()).getItem() instanceof LocalDate) {
                    datePresent = true;
                }
                cell.impl_processCSS(false);
                maxWidth = Math.max(maxWidth, cell.prefWidth(-1.0));
                this.getChildren().remove((Object)cell);
            }
            ++row;
        }
        cell.updateIndex(-1);
        double widthMax = maxWidth + padding;
        if (this.handle.getGridView().getColumnResizePolicy() == TableView.CONSTRAINED_RESIZE_POLICY) {
            widthMax = Math.max(widthMax, col.getWidth());
        }
        if (datePresent && widthMax < 105.0) {
            widthMax = 105.0;
        }
        col.impl_setWidth(widthMax);
    }
}

