/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.scene.control.skin.VirtualScrollBar;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.Helper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableRow;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

final class GridVirtualFlow<T extends IndexedCell<?>>
extends VirtualFlow<T> {
    private static final Comparator<GridRow> ROWCMP = new Comparator<GridRow>(){

        @Override
        public int compare(GridRow o1, GridRow o2) {
            int rhs;
            int lhs = o1.getIndex();
            return lhs < (rhs = o2.getIndex()) ? -1 : 1;
        }
    };
    private SpreadsheetView spreadSheetView;
    private int cellFixedAdded = 0;
    private boolean cellIndexCall = false;

    public GridVirtualFlow() {
        ChangeListener<Number> listenerY = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                GridVirtualFlow.this.layoutTotal();
            }
        };
        this.getVbar().valueProperty().addListener((ChangeListener)listenerY);
        this.getHbar().setUnitIncrement(10.0);
    }

    public void init(SpreadsheetView spv) {
        this.spreadSheetView = spv;
        spv.getModifiedCells().addListener((ListChangeListener)new ListChangeListener<SpreadsheetCell>(){

            public void onChanged(ListChangeListener.Change<? extends SpreadsheetCell> arg0) {
                GridVirtualFlow.this.layoutTotal();
                GridVirtualFlow.this.layoutFixedRows();
            }
        });
    }

    public void show(int index) {
        super.show(index);
        this.layoutTotal();
        this.layoutFixedRows();
    }

    public void scrollTo(int index) {
        if (!this.getCells().isEmpty() && index < ((IndexedCell)this.getCells().get(0 + this.getFixedRows().size())).getIndex()) {
            index -= this.getCells().size() - this.getFixedRows().size();
        }
        super.scrollTo(index);
        this.layoutTotal();
        this.layoutFixedRows();
    }

    public double adjustPixels(double delta) {
        this.cellIndexCall = true;
        double returnValue = super.adjustPixels(delta);
        this.layoutTotal();
        this.layoutFixedRows();
        return returnValue;
    }

    public ObservableList<Integer> getFixedRows() {
        return this.spreadSheetView.getFixedRows();
    }

    public T getFirstVisibleCellWithinViewPort() {
        if (this.getCells().isEmpty() || this.getHeight() <= 0.0) {
            return null;
        }
        boolean isVertical = this.isVertical();
        int i = 0 + this.getFixedRows().size();
        while (i < this.getCells().size()) {
            IndexedCell cell = (IndexedCell)this.getCells().get(i);
            if (!cell.isEmpty()) {
                if (isVertical && cell.getLayoutY() + cell.getHeight() > 0.0) {
                    return (T)cell;
                }
                if (!isVertical && cell.getLayoutX() + cell.getWidth() > 0.0) {
                    return (T)cell;
                }
            }
            ++i;
        }
        return null;
    }

    protected void layoutChildren() {
        if (this.spreadSheetView != null && (this.spreadSheetView.getEditingCell() == null || this.spreadSheetView.getEditingCell().getRow() == -1)) {
            this.sortRows();
            super.layoutChildren();
            this.layoutTotal();
            this.layoutFixedRows();
        }
    }

    protected T getAvailableCell(int prefIndex) {
        this.cellIndexCall = true;
        IndexedCell tmp = super.getAvailableCell(prefIndex);
        return (T)tmp;
    }

    protected void layoutTotal() {
        this.sortRows();
        if (this.getCells().isEmpty()) {
            this.reconfigureCells();
        }
        for (Cell cell : this.getCells()) {
            if (cell == null) continue;
            cell.requestLayout();
        }
    }

    protected VirtualScrollBar getVerticalBar() {
        return this.getVbar();
    }

    protected VirtualScrollBar getHorizontalBar() {
        return this.getHbar();
    }

    protected List<T> getCells() {
        return super.getCells();
    }

    protected int getCellIndex(T cell) {
        if (this.cellIndexCall) {
            this.cellIndexCall = false;
            return cell.getIndex();
        }
        return ((GridRow)((Object)cell)).getIndexVirtualFlow();
    }

    protected void addLeadingCells(int currentIndex, double startOffset) {
        this.addLeadingCells(new Helper(this), currentIndex, startOffset);
    }

    private void addLeadingCells(Helper<T> ch, int currentIndex, double startOffset) {
        double offset = startOffset;
        int index = currentIndex;
        boolean first = true;
        Object cell = null;
        int cellToAdd = 0;
        while (index >= 0 && (offset > 0.0 || first)) {
            if (first) {
                first = false;
            } else {
                offset -= this.getCellLength(0);
            }
            --index;
            ++cellToAdd;
        }
        offset = startOffset;
        index = currentIndex;
        first = true;
        this.cellFixedAdded = 0;
        int numberOfCellsBelowIndex = 0;
        boolean flag = false;
        while (index >= 0 && (offset > 0.0 || first)) {
            if (index >= this.getCellCount()) {
                if (first) {
                    first = false;
                }
                --index;
                --cellToAdd;
                continue;
            }
            if (!flag && !this.getFixedRows().isEmpty() && index >= (Integer)this.getFixedRows().get(this.cellFixedAdded)) {
                flag = true;
                while (numberOfCellsBelowIndex < this.getFixedRows().size() && index >= (Integer)this.getFixedRows().get(numberOfCellsBelowIndex) && numberOfCellsBelowIndex < cellToAdd) {
                    ++numberOfCellsBelowIndex;
                }
                --numberOfCellsBelowIndex;
            }
            if (!this.getFixedRows().isEmpty() && cellToAdd <= this.getFixedRows().size()) {
                if (flag && cellToAdd <= numberOfCellsBelowIndex + 1) {
                    int realIndex = (Integer)this.getFixedRows().get(numberOfCellsBelowIndex);
                    cell = this.getAvailableCell(realIndex);
                    this.setCellIndex(cell, realIndex);
                    this.setCellIndexVirtualFlow(cell, index);
                    --numberOfCellsBelowIndex;
                    ++this.cellFixedAdded;
                } else {
                    if (numberOfCellsBelowIndex >= 0 && index == (Integer)this.getFixedRows().get(numberOfCellsBelowIndex)) {
                        --numberOfCellsBelowIndex;
                        ++this.cellFixedAdded;
                    }
                    cell = this.getAvailableCell(index);
                    this.setCellIndex(cell, index);
                }
            } else {
                if (!this.getFixedRows().isEmpty() && numberOfCellsBelowIndex >= 0 && index == (Integer)this.getFixedRows().get(numberOfCellsBelowIndex)) {
                    --numberOfCellsBelowIndex;
                    ++this.cellFixedAdded;
                }
                cell = this.getAvailableCell(index);
                this.setCellIndex(cell, index);
            }
            this.resizeCellSize((IndexedCell)cell);
            ch.addFirst((IndexedCell)cell);
            if (first) {
                first = false;
            } else {
                offset -= this.getCellLength((IndexedCell)cell);
            }
            this.positionCell((IndexedCell)cell, offset);
            this.setMaxPrefBreadth(Math.max(ch.getMaxPrefBreadth(this), this.getCellBreadth((Cell)cell)));
            cell.setVisible(true);
            --index;
            --cellToAdd;
        }
        cell = ch.getFirst();
        int firstIndex = this.getCellIndex(cell);
        double firstCellPos = this.getCellPosition((IndexedCell)cell);
        if (firstIndex == 0 && firstCellPos > 0.0) {
            this.setPosition(0.0);
            offset = 0.0;
            int i = 0;
            while (i < this.getCells().size()) {
                cell = (IndexedCell)this.getCells().get(i);
                this.positionCell((IndexedCell)cell, offset);
                offset += this.getCellLength((IndexedCell)cell);
                ++i;
            }
        }
    }

    protected boolean addTrailingCells(boolean fillEmptyCells) {
        return this.addTrailingCells(new Helper(this), fillEmptyCells);
    }

    private boolean addTrailingCells(Helper<T> ch, boolean fillEmptyCells) {
        if (this.getCells().isEmpty()) {
            return false;
        }
        T startCell = ch.getLast();
        double offset = this.getCellPosition((IndexedCell)startCell) + this.getCellLength((IndexedCell)startCell);
        int index = this.getCellIndex(startCell) + 1;
        boolean filledWithNonEmpty = index <= this.getCellCount();
        double viewportLength = this.getViewportLength();
        while (offset < viewportLength) {
            if (index >= this.getCellCount()) {
                if (offset < viewportLength) {
                    filledWithNonEmpty = false;
                }
                if (!fillEmptyCells) {
                    return filledWithNonEmpty;
                }
            }
            T cell = null;
            if (!this.getFixedRows().isEmpty() && this.cellFixedAdded < this.getFixedRows().size() && fillEmptyCells) {
                if (index >= (Integer)this.getFixedRows().get(this.cellFixedAdded)) {
                    int realIndex = (Integer)this.getFixedRows().get(this.cellFixedAdded);
                    cell = this.getAvailableCell(realIndex);
                    this.setCellIndex(cell, realIndex);
                    this.setCellIndexVirtualFlow(cell, index);
                    ++this.cellFixedAdded;
                } else {
                    cell = this.getAvailableCell(index);
                    this.setCellIndex(cell, index);
                }
            } else {
                cell = this.getAvailableCell(index);
                this.setCellIndex(cell, index);
            }
            this.resizeCellSize((IndexedCell)cell);
            ch.addLast(cell);
            this.positionCell((IndexedCell)cell, offset);
            this.setMaxPrefBreadth(Math.max(ch.getMaxPrefBreadth(this), this.getCellBreadth((Cell)cell)));
            offset += this.getCellLength((IndexedCell)cell);
            cell.setVisible(true);
            ++index;
        }
        T firstCell = ch.getFirst();
        index = this.getCellIndex(firstCell);
        IndexedCell lastNonEmptyCell = this.getLastVisibleCell();
        double start = this.getCellPosition((IndexedCell)firstCell);
        double end = this.getCellPosition(lastNonEmptyCell) + this.getCellLength(lastNonEmptyCell);
        if ((index != 0 || index == 0 && start < 0.0) && fillEmptyCells && lastNonEmptyCell != null && this.getCellIndex(lastNonEmptyCell) == this.getCellCount() - 1 && end < viewportLength) {
            if (!this.getFixedRows().isEmpty()) {
                int currentIndex = (int)(this.getPosition() * (double)this.getCellCount());
                ch.addAllToPile(this);
                double p = Utils.clamp((double)0.0, (double)this.getPosition(), (double)1.0);
                double fractionalPosition = p * (double)this.getCellCount();
                int cellIndex = (int)fractionalPosition;
                double fraction = fractionalPosition - (double)cellIndex;
                double cellSize = this.getCellLength(cellIndex);
                double pixelOffset = cellSize * fraction;
                double viewportOffset = this.getViewportLength() * p;
                double offset2 = pixelOffset - viewportOffset;
                this.addLeadingCells(currentIndex, -offset2);
                this.addTrailingCells(true);
            } else {
                double prospectiveEnd = end;
                double distance = viewportLength - end;
                while (prospectiveEnd < viewportLength && index != 0 && -start < distance) {
                    T cell = this.getAvailableCell(--index);
                    this.setCellIndex(cell, index);
                    this.resizeCellSize((IndexedCell)cell);
                    ch.addFirst(cell);
                    double cellLength = this.getCellLength((IndexedCell)cell);
                    prospectiveEnd += cellLength;
                    this.positionCell((IndexedCell)cell, start -= cellLength);
                    this.setMaxPrefBreadth(Math.max(ch.getMaxPrefBreadth(this), this.getCellBreadth((Cell)cell)));
                    cell.setVisible(true);
                }
                firstCell = ch.getFirst();
                start = this.getCellPosition((IndexedCell)firstCell);
                double delta = viewportLength - end;
                if (this.getCellIndex(firstCell) == 0 && delta > -start) {
                    delta = -start;
                }
                int i = 0;
                while (i < ch.size()) {
                    T cell = ch.get(i);
                    this.positionCell((IndexedCell)cell, this.getCellPosition((IndexedCell)cell) + delta);
                    ++i;
                }
                start = this.getCellPosition((IndexedCell)firstCell);
                if (this.getCellIndex(firstCell) == 0 && start == 0.0) {
                    this.setPosition(0.0);
                } else if (this.getPosition() != 1.0) {
                    this.setPosition(1.0);
                }
            }
        }
        return filledWithNonEmpty;
    }

    protected void setCellIndex(T cell, int index) {
        super.setCellIndex(cell, index);
        this.setCellIndexVirtualFlow(cell, index);
    }

    private void setCellIndexVirtualFlow(T cell, int index) {
        if (cell == null) {
            return;
        }
        ((GridRow)((Object)cell)).setIndexVirtualFlow(index);
    }

    private void layoutFixedRows() {
        this.sortRows();
        if (!this.getCells().isEmpty() && !this.getFixedRows().isEmpty()) {
            int i = this.getFixedRows().size() - 1;
            while (i >= 0) {
                GridRow cell = (GridRow)((Object)this.getCells().get(i));
                if (cell != null && this.getFixedRows().contains((Object)cell.getIndex())) {
                    cell.toFront();
                    cell.requestLayout();
                }
                --i;
            }
        }
    }

    private void sortRows() {
        List<T> temp = this.getCells();
        ArrayList<T> tset = new ArrayList<T>(temp);
        Collections.sort(tset, ROWCMP);
        for (TableRow r : tset) {
            r.toFront();
        }
    }
}

