/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.HorizontalHeaderColumn;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class HorizontalHeader
extends TableHeaderRow {
    final GridViewSkin gridViewSkin;
    private boolean working = true;
    private final ChangeListener<Boolean> rowHeaderListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
            HorizontalHeader.this.updateTableWidth();
        }
    };
    private final ListChangeListener<SpreadsheetColumn<?>> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn<?>>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn<?>> arg0) {
            while (arg0.next()) {
                for (SpreadsheetColumn remitem : arg0.getRemoved()) {
                    HorizontalHeader.this.unfixColumn(remitem);
                }
                for (SpreadsheetColumn additem : arg0.getAddedSubList()) {
                    HorizontalHeader.this.fixColumn(additem);
                }
            }
            HorizontalHeader.this.updateHighlightSelection();
        }
    };
    private final InvalidationListener selectionListener = new InvalidationListener(){

        public void invalidated(Observable valueModel) {
            HorizontalHeader.this.updateHighlightSelection();
        }
    };

    public HorizontalHeader(GridViewSkin skin) {
        super((TableViewSkinBase)skin);
        this.gridViewSkin = skin;
    }

    public void init() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SpreadsheetView view = HorizontalHeader.this.gridViewSkin.spreadsheetView;
                view.showRowHeaderProperty().addListener(HorizontalHeader.this.rowHeaderListener);
                HorizontalHeader.this.gridViewSkin.getSelectedColumns().addListener(HorizontalHeader.this.selectionListener);
                view.getFixedColumns().addListener(HorizontalHeader.this.fixedColumnsListener);
                for (SpreadsheetColumn column : view.getFixedColumns()) {
                    HorizontalHeader.this.fixColumn(column);
                }
                HorizontalHeader.this.gridViewSkin.getTableMenuButtonVisibleProperty().addListener(new InvalidationListener(){

                    public void invalidated(Observable valueModel) {
                        if (HorizontalHeader.this.working) {
                            HorizontalHeader.this.requestLayout();
                        }
                    }
                });
                view.showColumnHeaderProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                        HorizontalHeader.this.working = arg2;
                        HorizontalHeader.this.requestLayout();
                        HorizontalHeader.this.getRootHeader().layoutFixedColumns();
                        HorizontalHeader.this.updateHighlightSelection();
                    }
                });
                for (final TableColumnHeader i : HorizontalHeader.this.getRootHeader().getColumnHeaders()) {
                    ((Node)i.getChildrenUnmodifiable().get(0)).setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                        public void handle(MouseEvent arg0) {
                            if (arg0.isPrimaryButtonDown()) {
                                TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> sm = (this).HorizontalHeader.this.gridViewSkin.handle.getView().getSelectionModel();
                                TableView.TableViewFocusModel fm = (this).HorizontalHeader.this.gridViewSkin.handle.getGridView().getFocusModel();
                                sm.clearAndSelect(fm.getFocusedCell().getRow(), i.getTableColumn());
                            }
                        }
                    });
                }
            }
        };
        Platform.runLater((Runnable)r);
    }

    protected void updateTableWidth() {
        Rectangle clip;
        super.updateTableWidth();
        double padding = 0.0;
        if (this.gridViewSkin != null && this.gridViewSkin.spreadsheetView != null && this.gridViewSkin.spreadsheetView.showRowHeaderProperty().get()) {
            padding += this.gridViewSkin.getRowHeaderWidth();
        }
        clip.setWidth((clip = (Rectangle)this.getClip()).getWidth() == 0.0 ? 0.0 : clip.getWidth() - padding);
    }

    protected void updateScrollX() {
        super.updateScrollX();
        if (this.working) {
            this.requestLayout();
            this.getRootHeader().layoutFixedColumns();
        }
    }

    private void fixColumn(SpreadsheetColumn<?> column) {
        this.addStyleHeader(this.gridViewSkin.spreadsheetView.getColumns().indexOf(column));
        column.setText(String.valueOf(column.getText().replace(".", "")) + ":");
    }

    private void unfixColumn(SpreadsheetColumn<?> column) {
        this.removeStyleHeader(this.gridViewSkin.spreadsheetView.getColumns().indexOf(column));
        column.setText(column.getText().replace(":", "."));
    }

    private void removeStyleHeader(Integer i) {
        ((Node)((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(i.intValue())).getChildrenUnmodifiable().get(0)).getStyleClass().removeAll((Object[])new String[]{"fixed"});
    }

    private void addStyleHeader(Integer i) {
        ((Node)((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(i.intValue())).getChildrenUnmodifiable().get(0)).getStyleClass().addAll((Object[])new String[]{"fixed"});
    }

    private void updateHighlightSelection() {
        for (TableColumnHeader i : this.getRootHeader().getColumnHeaders()) {
            ((Node)i.getChildrenUnmodifiable().get(0)).getStyleClass().removeAll((Object[])new String[]{"selected"});
        }
        ObservableList<Integer> selectedColumns = this.gridViewSkin.getSelectedColumns();
        for (Object i : selectedColumns) {
            ((Node)((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(((Integer)i).intValue())).getChildrenUnmodifiable().get(0)).getStyleClass().addAll((Object[])new String[]{"selected"});
        }
    }

    protected NestedTableColumnHeader createRootHeader() {
        return new HorizontalHeaderColumn(this.getTableSkin(), null);
    }

    public HorizontalHeaderColumn getRootHeader() {
        return (HorizontalHeaderColumn)super.getRootHeader();
    }
}

