/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.VirtualScrollBar;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class VerticalHeader
extends StackPane {
    private final SpreadsheetHandle handle;
    private final SpreadsheetView spreadsheetView;
    private double prefHeight = 24.0;
    private double prefWidth = 50.0;
    private boolean working = true;
    private Rectangle clip;
    private ContextMenu blankContextMenu;
    private final InvalidationListener layout = new InvalidationListener(){

        public void invalidated(Observable arg0) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    VerticalHeader.this.requestLayout();
                }
            };
            Platform.runLater((Runnable)r);
        }
    };

    public VerticalHeader(SpreadsheetHandle handle, double rowHeaderWidth) {
        this.handle = handle;
        this.spreadsheetView = handle.getView();
        this.prefWidth = rowHeaderWidth;
    }

    void init(GridViewSkin skin) {
        this.prefHeight = skin.getDefaultCellSize();
        this.clip = new Rectangle(this.prefWidth, this.snapSize(((TableView)skin.getSkinnable()).getHeight()));
        this.clip.relocate(this.snappedTopInset(), this.snappedLeftInset());
        this.clip.setSmooth(false);
        this.clip.heightProperty().bind((ObservableValue)((TableView)skin.getSkinnable()).heightProperty());
        this.setClip((Node)this.clip);
        this.spreadsheetView.showRowHeaderProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                VerticalHeader.this.working = arg2;
                VerticalHeader.this.requestLayout();
            }
        });
        this.spreadsheetView.showColumnHeaderProperty().addListener(this.layout);
        this.spreadsheetView.getFixedRows().addListener(this.layout);
        this.spreadsheetView.heightProperty().addListener(this.layout);
        skin.getSelectedRows().addListener(this.layout);
        this.blankContextMenu = new ContextMenu();
        this.requestLayout();
    }

    protected void layoutChildren() {
        if (this.working) {
            VirtualScrollBar hbar;
            ObservableList css;
            Label label;
            GridViewSkin skin = this.handle.getCellsViewSkin();
            double x = this.snappedLeftInset();
            int cellSize = skin.getCellsSize();
            double y = this.snappedTopInset();
            if (this.spreadsheetView.showColumnHeaderProperty().get()) {
                y += this.prefHeight;
            }
            if (cellSize != 0) {
                y += skin.getCell(0).getLocalToParentTransform().getTy();
            }
            int rowCount = 0;
            int i = 0;
            int modelRowCount = this.spreadsheetView.getGrid().getRowCount();
            while (cellSize != 0 && skin.getCell(i) != null && i < modelRowCount) {
                GridRow row = skin.getCell(i);
                label = this.getLabel(rowCount++);
                if (this.spreadsheetView.getFixedRows().contains((Object)row.getIndexVirtualFlow())) {
                    label.setText(String.valueOf(String.valueOf(row.getIndexVirtualFlow() + 1)) + ":");
                } else if (this.spreadsheetView.isRowFixable(row.getIndexVirtualFlow())) {
                    label.setText(String.valueOf(String.valueOf(row.getIndexVirtualFlow() + 1)) + ".");
                } else {
                    label.setText(String.valueOf(String.valueOf(row.getIndexVirtualFlow() + 1)) + " ");
                }
                label.resize(this.prefWidth, this.prefHeight);
                label.relocate(x, y);
                label.setContextMenu(this.getRowContextMenu(row.getIndexVirtualFlow()));
                css = label.getStyleClass();
                if (skin.getSelectedRows().contains((Object)row.getIndex())) {
                    css.addAll((Object[])new String[]{"selected"});
                } else {
                    css.removeAll((Object[])new String[]{"selected"});
                }
                if (this.spreadsheetView.getFixedRows().contains((Object)row.getIndex())) {
                    css.addAll((Object[])new String[]{"fixed"});
                } else {
                    css.removeAll((Object[])new String[]{"fixed"});
                }
                y += this.prefHeight;
                ++i;
            }
            if (!this.spreadsheetView.getFixedRows().isEmpty() && cellSize != 0) {
                i = 0;
                while (i < this.spreadsheetView.getFixedRows().size()) {
                    if (skin.getCell(i).getCurrentlyFixed().booleanValue()) {
                        label = this.getLabel(rowCount++);
                        label.setText(String.valueOf(String.valueOf((Integer)this.spreadsheetView.getFixedRows().get(i) + 1)) + ":");
                        label.resize(this.prefWidth, this.prefHeight);
                        label.setContextMenu(this.getRowContextMenu((Integer)this.spreadsheetView.getFixedRows().get(i)));
                        if (this.spreadsheetView.showColumnHeaderProperty().get()) {
                            label.relocate(x, this.snappedTopInset() + this.prefHeight * (double)(i + 1));
                        } else {
                            label.relocate(x, this.snappedTopInset() + this.prefHeight * (double)i);
                        }
                        css = label.getStyleClass();
                        if (skin.getSelectedRows().contains((Object)skin.getCell(i).getIndex())) {
                            css.addAll((Object[])new String[]{"selected"});
                        } else {
                            css.removeAll((Object[])new String[]{"selected"});
                        }
                        css.addAll((Object[])new String[]{"fixed"});
                        y += this.prefHeight;
                    }
                    ++i;
                }
            }
            if (this.spreadsheetView.showColumnHeaderProperty().get()) {
                label = this.getLabel(rowCount++);
                label.setText("");
                label.resize(this.prefWidth, this.prefHeight);
                label.relocate(x, 0.0);
                label.getStyleClass().clear();
                label.setContextMenu(this.blankContextMenu);
            }
            if ((hbar = this.handle.getCellsViewSkin().getHBar()).isVisible()) {
                label = this.getLabel(rowCount++);
                label.setText("");
                label.resize(this.prefWidth, hbar.getHeight());
                label.relocate(this.snappedLeftInset(), this.getHeight() - hbar.getHeight());
                label.getStyleClass().clear();
                label.setContextMenu(this.blankContextMenu);
            }
            while (this.getChildren().size() > rowCount) {
                this.getChildren().remove(rowCount);
            }
        } else {
            this.getChildren().clear();
        }
    }

    void updateScrollY() {
        if (this.working) {
            this.requestLayout();
        }
    }

    private Label getLabel(int rowNumber) {
        if (this.getChildren().isEmpty() || this.getChildren().size() <= rowNumber) {
            final Label label = new Label();
            label.resize(this.prefWidth, this.prefHeight);
            this.getChildren().add((Object)label);
            label.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    if (arg0.isPrimaryButtonDown()) {
                        try {
                            int row = Integer.parseInt(label.getText().substring(0, label.getText().length() - 1));
                            TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> sm = VerticalHeader.this.spreadsheetView.getSelectionModel();
                            TableView.TableViewFocusModel fm = VerticalHeader.this.handle.getGridView().getFocusModel();
                            sm.clearAndSelect(row - 1, fm.getFocusedCell().getTableColumn());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            });
            return label;
        }
        return (Label)this.getChildren().get(rowNumber);
    }

    private ContextMenu getRowContextMenu(final Integer i) {
        if (this.spreadsheetView.isRowFixable(i)) {
            ContextMenu contextMenu = new ContextMenu();
            CheckMenuItem fixItem = new CheckMenuItem("Fix");
            fixItem.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                    if (VerticalHeader.this.spreadsheetView.getFixedRows().contains((Object)i)) {
                        VerticalHeader.this.spreadsheetView.getFixedRows().remove((Object)i);
                    } else {
                        VerticalHeader.this.spreadsheetView.getFixedRows().add((Object)i);
                    }
                    FXCollections.sort(VerticalHeader.this.spreadsheetView.getFixedRows());
                }
            });
            contextMenu.getItems().addAll((Object[])new MenuItem[]{fixItem});
            return contextMenu;
        }
        return this.blankContextMenu;
    }
}

