/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.Sample;
import org.controlsfx.control.HyperlinkLabel;

public class HelloControlsFX
extends Application {
    private static final String SAMPLES_ROOT_PACKAGE = "org.controlsfx.samples";
    private final Map<String, TreeItem<Sample>> packageTreeItemMap = new HashMap<String, TreeItem<Sample>>();
    private GridPane grid;
    private TabPane tabPane;
    private Tab welcomeTab;
    private Tab sampleTab;
    private Tab webViewTab;
    private WebView webview;

    public static void main(String[] args) {
        HelloControlsFX.launch((String[])args);
    }

    public void start(final Stage primaryStage) throws Exception {
        Class<?>[] sampleClasses;
        HelloControlsFX.setUserAgentStylesheet((String)"MODENA");
        primaryStage.getIcons().add((Object)new Image("/org/controlsfx/samples/controlsfx-logo.png"));
        final TreeItem root = new TreeItem((Object)new EmptySample("ControlsFX"));
        root.setExpanded(true);
        Class<?>[] classArray = sampleClasses = HelloControlsFX.getClasses(SAMPLES_ROOT_PACKAGE);
        int n = sampleClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Sample sample;
            Class<?> sampleClass = classArray[n2];
            if (Sample.class.isAssignableFrom(sampleClass) && (sample = (Sample)sampleClass.newInstance()).includeInSamples()) {
                String packageName = sampleClass.getPackage().getName();
                String displayName = packageName.substring(packageName.lastIndexOf(".") + 1);
                displayName = String.valueOf(displayName.substring(0, 1).toUpperCase()) + displayName.substring(1);
                displayName = displayName.replace("_", " ");
                if (SAMPLES_ROOT_PACKAGE.equals(packageName)) {
                    root.getChildren().add((Object)new TreeItem((Object)sample));
                } else {
                    TreeItem packageTreeItem;
                    if (this.packageTreeItemMap.containsKey(displayName)) {
                        packageTreeItem = this.packageTreeItemMap.get(displayName);
                    } else {
                        packageTreeItem = new TreeItem((Object)new EmptySample(displayName));
                        this.packageTreeItemMap.put(displayName, (TreeItem<Sample>)packageTreeItem);
                    }
                    TreeItem sampleTreeItem = new TreeItem((Object)sample);
                    packageTreeItem.getChildren().add((Object)sampleTreeItem);
                    packageTreeItem.setExpanded(true);
                }
            }
            ++n2;
        }
        root.getChildren().addAll(this.packageTreeItemMap.values());
        Collections.sort(root.getChildren(), new Comparator<TreeItem<Sample>>(){

            @Override
            public int compare(TreeItem<Sample> o1, TreeItem<Sample> o2) {
                return ((Sample)o1.getValue()).getSampleName().compareTo(((Sample)o2.getValue()).getSampleName());
            }
        });
        this.grid = new GridPane();
        this.grid.setPadding(new Insets(5.0, 10.0, 10.0, 10.0));
        this.grid.setHgap(10.0);
        this.grid.setVgap(10.0);
        TreeView samplesTreeView = new TreeView(root);
        samplesTreeView.setMinWidth(200.0);
        samplesTreeView.setMaxWidth(200.0);
        samplesTreeView.setCellFactory((Callback)new Callback<TreeView<Sample>, TreeCell<Sample>>(){

            public TreeCell<Sample> call(TreeView<Sample> param) {
                return new TreeCell<Sample>(){

                    protected void updateItem(Sample item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setText("");
                        } else {
                            this.setText(item.getSampleName());
                        }
                    }
                };
            }
        });
        samplesTreeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<Sample>>(){

            public void changed(ObservableValue<? extends TreeItem<Sample>> observable, TreeItem<Sample> oldValue, TreeItem<Sample> newSample) {
                if (newSample == root) {
                    HelloControlsFX.this.changeToWelcomeTab();
                    return;
                }
                if (newSample.getValue() instanceof EmptySample) {
                    return;
                }
                HelloControlsFX.this.changeSample((Sample)newSample.getValue(), primaryStage);
            }
        });
        GridPane.setVgrow((Node)samplesTreeView, (Priority)Priority.ALWAYS);
        GridPane.setMargin((Node)samplesTreeView, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        this.grid.add((Node)samplesTreeView, 0, 0);
        this.tabPane = new TabPane();
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tabPane.getStyleClass().add((Object)"floating");
        GridPane.setHgrow((Node)this.tabPane, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.tabPane, (Priority)Priority.ALWAYS);
        this.grid.add((Node)this.tabPane, 1, 0, 1, 1);
        this.sampleTab = new Tab("Sample");
        this.webViewTab = new Tab("JavaDoc");
        this.webview = new WebView();
        this.webViewTab.setContent((Node)this.webview);
        this.changeToWelcomeTab();
        Scene scene = new Scene((Parent)this.grid);
        primaryStage.setScene(scene);
        primaryStage.setMinWidth(1000.0);
        primaryStage.setMinHeight(600.0);
        primaryStage.setWidth(1000.0);
        primaryStage.setHeight(600.0);
        primaryStage.setTitle("ControlsFX!");
        primaryStage.show();
        samplesTreeView.requestFocus();
    }

    private void changeSample(Sample newSample, Stage stage) {
        if (newSample == null) {
            return;
        }
        if (this.tabPane.getTabs().contains((Object)this.welcomeTab)) {
            this.tabPane.getTabs().setAll((Object[])new Tab[]{this.sampleTab, this.webViewTab});
        }
        this.sampleTab.setContent(newSample.getPanel(stage));
        this.webview.getEngine().load(newSample.getJavaDocURL());
    }

    private void changeToWelcomeTab() {
        Label welcomeLabel1 = new Label("Welcome to ControlsFX!");
        welcomeLabel1.setStyle("-fx-font-size: 2em; -fx-padding: 0 0 0 5;");
        HyperlinkLabel welcomeLabel2 = new HyperlinkLabel("Explore the available UI controls by clicking on the options to the left.\n\nThere have been many contributors to this project, including:\n   Jonathan Giles\n   Eugene Ryzhikov\n   Hendrik Ebbers\n   Danno Ferrin\n   Paru Somashekar\n\nIf you ever meet any of these wonderful contributors, tell them how great they are! :-)\n\nTo keep up to date with the ControlsFX project, visit the website at [http://www.controlsfx.org]");
        welcomeLabel2.setStyle("-fx-font-size: 1.25em; -fx-padding: 0 0 0 5;");
        welcomeLabel2.setOnAction(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                HelloControlsFX.this.webViewTab.setText("ControlsFX Website");
                HelloControlsFX.this.webview.getEngine().load("http://www.controlsfx.org");
                HelloControlsFX.this.tabPane.getTabs().add((Object)HelloControlsFX.this.webViewTab);
                HelloControlsFX.this.tabPane.getSelectionModel().select((Object)HelloControlsFX.this.webViewTab);
            }
        });
        VBox initialVBox = new VBox(5.0, new Node[]{welcomeLabel1, welcomeLabel2});
        this.welcomeTab = new Tab("Welcome to ControlsFX!");
        this.welcomeTab.setContent((Node)initialVBox);
        this.tabPane.getTabs().setAll((Object[])new Tab[]{this.welcomeTab});
    }

    private static Class<?>[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        Class<?>[] results = HelloControlsFX.loadFromEnumeratedFile();
        if (results == null) {
            results = HelloControlsFX.loadFromJarSniffing(packageName);
        }
        return results;
    }

    private static Class<?>[] loadFromEnumeratedFile() throws ClassNotFoundException, IOException {
        ClassLoader classLoader = HelloControlsFX.class.getClassLoader();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(HelloControlsFX.class.getResourceAsStream("samples/samples.txt")));){
                ArrayList classes = new ArrayList();
                String sample = br.readLine();
                while (sample != null) {
                    if (sample.endsWith(".java")) {
                        sample = sample.substring(0, sample.length() - ".java".length());
                        classes.add(classLoader.loadClass(sample.replace("/", ".")));
                    }
                    sample = br.readLine();
                }
                return classes.toArray(new Class[classes.size()]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    private static Class<?>[] loadFromJarSniffing(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            String fileName;
            int sep;
            URL next = resources.nextElement();
            String protocol = next.getProtocol().toLowerCase();
            if ("file".equals(protocol)) {
                dirs.add(new File(next.getFile()));
                continue;
            }
            if (!"jar".equals(protocol) || (sep = (fileName = new URL(next.getFile()).getFile()).indexOf("!/")) <= 0) continue;
            dirs.add(new File(fileName.substring(0, sep)));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            String fullPath = directory.getAbsolutePath();
            if (fullPath.toLowerCase().endsWith(".jar")) {
                classes.addAll(HelloControlsFX.findClassesInJar(new File(fullPath), packageName));
                continue;
            }
            classes.addAll(HelloControlsFX.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            System.out.println("Directory does not exist: " + directory.getAbsolutePath());
            return classes;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    assert (!file.getName().contains("."));
                    classes.addAll(HelloControlsFX.findClasses(file, String.valueOf(packageName) + "." + file.getName()));
                } else if (file.getName().endsWith(".class")) {
                    String className = String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6);
                    classes.add(Class.forName(className));
                }
                ++n2;
            }
        }
        return classes;
    }

    private static List<Class<?>> findClassesInJar(File jarFile, String packageName) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!jarFile.exists()) {
            System.out.println("Jar file does not exist here: " + jarFile.getAbsolutePath());
            return classes;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zip = new ZipInputStream(new FileInputStream(jarFile));){
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (entry.getName().endsWith(".class") && !entry.isDirectory()) {
                    StringBuilder className = new StringBuilder();
                    String[] stringArray = entry.getName().split("/");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String part = stringArray[n2];
                        if (className.length() != 0) {
                            className.append(".");
                        }
                        className.append(part);
                        if (part.endsWith(".class")) {
                            className.setLength(className.length() - ".class".length());
                        }
                        ++n2;
                    }
                    if (className.toString().contains(packageName)) {
                        classes.add(Class.forName(className.toString()));
                    }
                }
                entry = zip.getNextEntry();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return classes;
    }

    private static class EmptySample
    implements Sample {
        private final String name;

        public EmptySample(String name) {
            this.name = name;
        }

        @Override
        public String getSampleName() {
            return this.name;
        }

        @Override
        public Node getPanel(Stage stage) {
            return null;
        }

        @Override
        public String getJavaDocURL() {
            return null;
        }

        @Override
        public boolean includeInSamples() {
            return true;
        }
    }
}

