/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.CheckComboBoxSkin;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.Skin;
import org.controlsfx.control.CheckBitSetModelBase;

public class CheckComboBox<T>
extends Control {
    private final ObservableList<T> items;
    private final Map<T, BooleanProperty> itemBooleanMap;
    private ObjectProperty<MultipleSelectionModel<T>> checkModel = new SimpleObjectProperty((Object)this, "checkModel");

    public CheckComboBox() {
        this(null);
    }

    public CheckComboBox(ObservableList<T> items) {
        int initialSize = items == null ? 32 : items.size();
        this.itemBooleanMap = new HashMap<T, BooleanProperty>(initialSize);
        this.items = items == null ? FXCollections.observableArrayList() : items;
        this.setCheckModel(new CheckComboBoxBitSetCheckModel<T>(items, this.itemBooleanMap));
    }

    protected Skin<?> createDefaultSkin() {
        return new CheckComboBoxSkin(this);
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    public BooleanProperty getItemBooleanProperty(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        return this.getItemBooleanProperty(this.getItems().get(index));
    }

    public BooleanProperty getItemBooleanProperty(T item) {
        return this.itemBooleanMap.get(item);
    }

    public final void setCheckModel(MultipleSelectionModel<T> value) {
        this.checkModelProperty().set(value);
    }

    public final MultipleSelectionModel<T> getCheckModel() {
        return this.checkModel == null ? null : (MultipleSelectionModel)this.checkModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<T>> checkModelProperty() {
        return this.checkModel;
    }

    private static class CheckComboBoxBitSetCheckModel<T>
    extends CheckBitSetModelBase<T> {
        private final ObservableList<T> items;

        CheckComboBoxBitSetCheckModel(ObservableList<T> items, Map<T, BooleanProperty> itemBooleanMap) {
            super(itemBooleanMap);
            this.items = items;
            this.items.addListener(new ListChangeListener<T>(){

                public void onChanged(ListChangeListener.Change<? extends T> c) {
                    CheckComboBoxBitSetCheckModel.this.updateMap();
                }
            });
            this.updateMap();
        }

        @Override
        public T getItem(int index) {
            return (T)this.items.get(index);
        }

        @Override
        public int getItemCount() {
            return this.items.size();
        }

        @Override
        public int getItemIndex(T item) {
            return this.items.indexOf(item);
        }
    }
}

