/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.util.Callback;
import org.controlsfx.control.CheckBitSetModelBase;

public class CheckListView<T>
extends ListView<T> {
    private final Map<T, BooleanProperty> itemBooleanMap;
    private ObjectProperty<MultipleSelectionModel<T>> checkModel = new SimpleObjectProperty((Object)this, "checkModel");

    public CheckListView() {
        this(null);
    }

    public CheckListView(ObservableList<T> items) {
        super(items);
        int initialSize = items == null ? 32 : items.size();
        this.itemBooleanMap = new HashMap<T, BooleanProperty>(initialSize);
        this.setCheckModel(new CheckListViewBitSetCheckModel<T>(items, this.itemBooleanMap));
        this.setCellFactory(new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> listView) {
                return new CheckBoxListCell(new Callback<T, ObservableValue<Boolean>>(){

                    public ObservableValue<Boolean> call(T item) {
                        return CheckListView.this.getItemBooleanProperty(item);
                    }
                });
            }
        });
    }

    public BooleanProperty getItemBooleanProperty(int index) {
        if (index < 0 || index >= this.getItems().size()) {
            return null;
        }
        return this.getItemBooleanProperty(this.getItems().get(index));
    }

    public BooleanProperty getItemBooleanProperty(T item) {
        return this.itemBooleanMap.get(item);
    }

    public final void setCheckModel(MultipleSelectionModel<T> value) {
        this.checkModelProperty().set(value);
    }

    public final MultipleSelectionModel<T> getCheckModel() {
        return this.checkModel == null ? null : (MultipleSelectionModel)this.checkModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<T>> checkModelProperty() {
        return this.checkModel;
    }

    private static class CheckListViewBitSetCheckModel<T>
    extends CheckBitSetModelBase<T> {
        private final ObservableList<T> items;

        CheckListViewBitSetCheckModel(ObservableList<T> items, Map<T, BooleanProperty> itemBooleanMap) {
            super(itemBooleanMap);
            this.items = items;
            this.items.addListener(new ListChangeListener<T>(){

                public void onChanged(ListChangeListener.Change<? extends T> c) {
                    CheckListViewBitSetCheckModel.this.updateMap();
                }
            });
            this.updateMap();
        }

        @Override
        public T getItem(int index) {
            return (T)this.items.get(index);
        }

        @Override
        public int getItemCount() {
            return this.items.size();
        }

        @Override
        public int getItemIndex(T item) {
            return this.items.indexOf(item);
        }
    }
}

