/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.controlsfx.control.CustomTextField;

public class TextFields {
    private static final Duration FADE_DURATION = Duration.millis((double)350.0);

    private TextFields() {
    }

    public static TextField createSearchField() {
        final CustomTextField searchField = new CustomTextField();
        searchField.getStyleClass().add((Object)"search-field");
        Region clearButton = new Region();
        clearButton.getStyleClass().addAll((Object[])new String[]{"graphic"});
        StackPane clearButtonPane = new StackPane(new Node[]{clearButton});
        clearButtonPane.getStyleClass().addAll((Object[])new String[]{"clear-button"});
        clearButtonPane.setOpacity(0.0);
        clearButtonPane.setCursor(Cursor.DEFAULT);
        clearButtonPane.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                searchField.clear();
            }
        });
        searchField.setRight((Node)clearButtonPane);
        final FadeTransition fader = new FadeTransition(FADE_DURATION, (Node)clearButtonPane);
        fader.setCycleCount(1);
        searchField.textProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                boolean isButtonVisible;
                String text = searchField.getText();
                boolean isTextEmpty = text == null || text.isEmpty();
                boolean bl = isButtonVisible = fader.getNode().getOpacity() > 0.0;
                if (isTextEmpty && isButtonVisible) {
                    this.setButtonVisible(false);
                } else if (!isTextEmpty && !isButtonVisible) {
                    this.setButtonVisible(true);
                }
            }

            private void setButtonVisible(boolean visible) {
                fader.setFromValue(visible ? 0.0 : 1.0);
                fader.setToValue(visible ? 1.0 : 0.0);
                fader.play();
            }
        });
        return searchField;
    }
}

