/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.event.ActionEvent;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionProxy;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.action.AnnotatedAction;

public class ActionMap {
    private static Map<String, AnnotatedAction> actions = new HashMap<String, AnnotatedAction>();

    private ActionMap() {
    }

    public static void register(Object target) {
        Method[] methodArray = target.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] annotations;
            Method method = methodArray[n2];
            int paramCount = method.getParameterCount();
            if (paramCount <= 1 && (paramCount != 1 || method.getParameterTypes()[0] == ActionEvent.class) && (annotations = method.getAnnotationsByType(ActionProxy.class)).length > 0) {
                String id;
                ActionProxy annotation = (ActionProxy)annotations[0];
                String string = id = annotation.id().isEmpty() ? method.getName() : annotation.id();
                if (actions.containsKey(id)) {
                    throw new IllegalArgumentException(String.format("Action proxy with key = '%s' already exists", id));
                }
                actions.put(id, new AnnotatedAction(annotation, method, target));
            }
            ++n2;
        }
    }

    public void unregister(Object target) {
        if (target != null) {
            for (String key : actions.keySet()) {
                if (actions.get(key).getTarget() != target) continue;
                actions.remove(key);
            }
        }
    }

    public static Action action(String id) {
        return actions.get(id);
    }

    public static Collection<Action> actions(String ... ids) {
        ArrayList<Action> result = new ArrayList<Action>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Action action;
            String id = stringArray[n2];
            if (id.startsWith("---")) {
                result.add(ActionUtils.ACTION_SEPARATOR);
            }
            if ((action = ActionMap.action(id)) != null) {
                result.add(action);
            }
            ++n2;
        }
        return result;
    }
}

