/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import org.controlsfx.control.ButtonBar;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionGroup;
import org.controlsfx.tools.Duplicatable;

public class ActionUtils {
    public static Action ACTION_SEPARATOR = new Action(){

        @Override
        public StringProperty textProperty() {
            return null;
        }

        @Override
        public BooleanProperty disabledProperty() {
            return null;
        }

        @Override
        public StringProperty longTextProperty() {
            return null;
        }

        @Override
        public ObjectProperty<Node> graphicProperty() {
            return null;
        }

        @Override
        public ObjectProperty<KeyCombination> acceleratorProperty() {
            return null;
        }

        @Override
        public ObservableMap<Object, Object> getProperties() {
            return null;
        }

        @Override
        public void execute(ActionEvent ae) {
        }

        public String toString() {
            return "Separator";
        }
    };

    private ActionUtils() {
    }

    public static Button createButton(Action action, ActionTextBehavior textBehavior) {
        return ActionUtils.configure(new Button(), action, textBehavior);
    }

    public static Button createButton(Action action) {
        return ActionUtils.configure(new Button(), action, ActionTextBehavior.SHOW);
    }

    public static MenuButton createMenuButton(Action action, ActionTextBehavior textBehavior) {
        return ActionUtils.configure(new MenuButton(), action, textBehavior);
    }

    public static MenuButton createMenuButton(Action action) {
        return ActionUtils.configure(new MenuButton(), action, ActionTextBehavior.SHOW);
    }

    public static Hyperlink createHyperlink(Action action) {
        return ActionUtils.configure(new Hyperlink(), action, ActionTextBehavior.SHOW);
    }

    public static ToggleButton createToggleButton(Action action, ActionTextBehavior textBehavior) {
        return ActionUtils.configure(new ToggleButton(), action, textBehavior);
    }

    public static ToggleButton createToggleButton(Action action) {
        return ActionUtils.createToggleButton(action, ActionTextBehavior.SHOW);
    }

    public static SegmentedButton createSegmentedButton(ActionTextBehavior textBehavior, Collection<? extends Action> actions) {
        ObservableList buttons = FXCollections.observableArrayList();
        for (Action action : actions) {
            buttons.add((Object)ActionUtils.createToggleButton(action, textBehavior));
        }
        return new SegmentedButton((ObservableList<ToggleButton>)buttons);
    }

    public static SegmentedButton createSegmentedButton(Collection<? extends Action> actions) {
        return ActionUtils.createSegmentedButton(ActionTextBehavior.SHOW, actions);
    }

    public static SegmentedButton createSegmentedButton(ActionTextBehavior textBehavior, Action ... actions) {
        return ActionUtils.createSegmentedButton(textBehavior, Arrays.asList(actions));
    }

    public static SegmentedButton createSegmentedButton(Action ... actions) {
        return ActionUtils.createSegmentedButton(ActionTextBehavior.SHOW, Arrays.asList(actions));
    }

    public static CheckBox createCheckBox(Action action) {
        return ActionUtils.configure(new CheckBox(), action, ActionTextBehavior.SHOW);
    }

    public static RadioButton createRadioButton(Action action) {
        return ActionUtils.configure(new RadioButton(), action, ActionTextBehavior.SHOW);
    }

    public static MenuItem createMenuItem(Action action) {
        return ActionUtils.configure(new MenuItem(), action);
    }

    public static Menu createMenu(Action action) {
        return ActionUtils.configure(new Menu(), action);
    }

    public static CheckMenuItem createCheckMenuItem(Action action) {
        return ActionUtils.configure(new CheckMenuItem(), action);
    }

    public static RadioMenuItem createRadioMenuItem(Action action) {
        return ActionUtils.configure(new RadioMenuItem((String)action.textProperty().get()), action);
    }

    public static ToolBar createToolBar(Collection<? extends Action> actions, ActionTextBehavior textBehavior) {
        ToolBar toolbar = new ToolBar();
        for (Action action : actions) {
            if (action instanceof ActionGroup) {
                MenuButton menu = ActionUtils.createMenuButton(action, textBehavior);
                menu.getItems().addAll(ActionUtils.toMenuItems(((ActionGroup)action).getActions()));
                toolbar.getItems().add((Object)menu);
                continue;
            }
            if (action == ACTION_SEPARATOR) {
                toolbar.getItems().add((Object)new Separator());
                continue;
            }
            if (action == null) continue;
            toolbar.getItems().add((Object)ActionUtils.createButton(action, textBehavior));
        }
        return toolbar;
    }

    public static MenuBar createMenuBar(Collection<? extends Action> actions) {
        MenuBar menuBar = new MenuBar();
        for (Action action : actions) {
            if (action == ACTION_SEPARATOR) continue;
            Menu menu = ActionUtils.createMenu(action);
            if (action instanceof ActionGroup) {
                menu.getItems().addAll(ActionUtils.toMenuItems(((ActionGroup)action).getActions()));
            }
            menuBar.getMenus().add((Object)menu);
        }
        return menuBar;
    }

    public static ButtonBar createButtonBar(Collection<? extends Action> actions) {
        ButtonBar buttonBar = new ButtonBar();
        for (Action action : actions) {
            if (action instanceof ActionGroup || action == ACTION_SEPARATOR || action == null) continue;
            buttonBar.getButtons().add((Object)ActionUtils.createButton(action, ActionTextBehavior.SHOW));
        }
        return buttonBar;
    }

    public static ContextMenu createContextMenu(Collection<? extends Action> actions) {
        ContextMenu menu = new ContextMenu();
        menu.getItems().addAll(ActionUtils.toMenuItems(actions));
        return menu;
    }

    private static Collection<MenuItem> toMenuItems(Collection<? extends Action> actions) {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (Action action : actions) {
            if (action instanceof ActionGroup) {
                Menu menu = ActionUtils.createMenu(action);
                menu.getItems().addAll(ActionUtils.toMenuItems(((ActionGroup)action).getActions()));
                items.add((MenuItem)menu);
                continue;
            }
            if (action == ACTION_SEPARATOR) {
                items.add((MenuItem)new SeparatorMenuItem());
                continue;
            }
            if (action == null) continue;
            items.add(ActionUtils.createMenuItem(action));
        }
        return items;
    }

    private static Node copyNode(Node node) {
        if (node instanceof ImageView) {
            return new ImageView(((ImageView)node).getImage());
        }
        if (node instanceof Duplicatable) {
            return (Node)((Duplicatable)node).duplicate();
        }
        return null;
    }

    private static <T extends ButtonBase> T configure(final T btn, final Action action, ActionTextBehavior textBahavior) {
        if (action == null) {
            throw new NullPointerException("Action can not be null");
        }
        if (textBahavior == ActionTextBehavior.SHOW) {
            btn.textProperty().bind((ObservableValue)action.textProperty());
        }
        btn.disableProperty().bind((ObservableValue)action.disabledProperty());
        btn.graphicProperty().bind((ObservableValue)new ObjectBinding<Node>(){
            {
                this.bind(new Observable[]{action2.graphicProperty()});
            }

            protected Node computeValue() {
                return ActionUtils.copyNode((Node)action.graphicProperty().get());
            }
        });
        btn.getProperties().putAll(action.getProperties());
        action.getProperties().addListener((MapChangeListener)new MapChangeListener<Object, Object>(){

            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                btn.getProperties().clear();
                btn.getProperties().putAll(action.getProperties());
            }
        });
        btn.tooltipProperty().bind((ObservableValue)new ObjectBinding<Tooltip>(){
            private Tooltip tooltip = new Tooltip();
            {
                this.bind(new Observable[]{action2.longTextProperty()});
                this.tooltip.textProperty().bind((ObservableValue)action2.longTextProperty());
            }

            protected Tooltip computeValue() {
                String longText = (String)action.longTextProperty().get();
                return longText == null || longText.isEmpty() ? null : this.tooltip;
            }
        });
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent ae) {
                if (!action.disabledProperty().get()) {
                    action.execute(ae);
                }
            }
        });
        return btn;
    }

    private static <T extends MenuItem> T configure(final T btn, final Action action) {
        if (action == null) {
            throw new NullPointerException("Action can not be null");
        }
        btn.textProperty().bind((ObservableValue)action.textProperty());
        btn.disableProperty().bind((ObservableValue)action.disabledProperty());
        btn.acceleratorProperty().bind(action.acceleratorProperty());
        btn.graphicProperty().bind((ObservableValue)new ObjectBinding<Node>(){
            {
                this.bind(new Observable[]{action2.graphicProperty()});
            }

            protected Node computeValue() {
                return ActionUtils.copyNode((Node)action.graphicProperty().get());
            }
        });
        btn.getProperties().putAll(action.getProperties());
        action.getProperties().addListener((MapChangeListener)new MapChangeListener<Object, Object>(){

            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                btn.getProperties().clear();
                btn.getProperties().putAll(action.getProperties());
            }
        });
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent ae) {
                if (!action.disabledProperty().get()) {
                    action.execute(ae);
                }
            }
        });
        return btn;
    }

    public static enum ActionTextBehavior {
        SHOW,
        HIDE;

    }
}

