/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.cell;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.controlsfx.control.GridCell;

public class ImageGridCell
extends GridCell<Image> {
    private final ImageView imageView;
    private final boolean preserveImageProperties;

    public ImageGridCell() {
        this(true);
    }

    public ImageGridCell(boolean preserveImageProperties) {
        this.getStyleClass().add((Object)"image-grid-cell");
        this.preserveImageProperties = preserveImageProperties;
        this.imageView = new ImageView();
        this.imageView.fitHeightProperty().bind((ObservableValue)this.heightProperty());
        this.imageView.fitWidthProperty().bind((ObservableValue)this.widthProperty());
    }

    protected void updateItem(Image item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.getChildren().clear();
        if (empty) {
            this.setGraphic(null);
        } else {
            if (this.preserveImageProperties) {
                this.imageView.setPreserveRatio(item.isPreserveRatio());
                this.imageView.setSmooth(item.isSmooth());
            }
            this.imageView.setImage(item);
            this.setGraphic((Node)this.imageView);
        }
    }
}

