/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.spreadsheet.GridViewSkin;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridBase
implements Grid {
    private ObservableList<ObservableList<SpreadsheetCell>> rows;
    private int rowCount;
    private int columnCount;

    public GridBase() {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public GridBase(int rowCount, int columnCount) {
        this(rowCount, columnCount, (ObservableList<ObservableList<SpreadsheetCell>>)FXCollections.emptyObservableList());
    }

    public GridBase(int rowCount, int columnCount, ObservableList<ObservableList<SpreadsheetCell>> rows) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.rows = rows;
    }

    @Override
    public ObservableList<ObservableList<SpreadsheetCell>> getRows() {
        return this.rows;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public SpreadsheetView.SpanType getSpanType(SpreadsheetView spv, int row, int column) {
        if (row < 0 || column < 0 || !this.containsRow(spv, row)) {
            return SpreadsheetView.SpanType.NORMAL_CELL;
        }
        SpreadsheetCell cellSpan = (SpreadsheetCell)((ObservableList)this.getRows().get(row)).get(column);
        int cellSpanColumn = cellSpan.getColumn();
        int cellSpanRow = cellSpan.getRow();
        int cellSpanRowSpan = cellSpan.getRowSpan();
        int cellSpanColumnSpan = cellSpan.getColumnSpan();
        boolean containsRowMinusOne = this.containsRow(spv, row - 1);
        if (cellSpanColumn == column && cellSpanRow == row && cellSpanRowSpan == 1) {
            return SpreadsheetView.SpanType.NORMAL_CELL;
        }
        if (containsRowMinusOne && cellSpanColumnSpan > 1 && cellSpanColumn != column && cellSpanRowSpan > 1 && cellSpanRow != row) {
            return SpreadsheetView.SpanType.BOTH_INVISIBLE;
        }
        if (cellSpanRowSpan > 1 && cellSpanColumn == column) {
            if (cellSpanRow == row || !containsRowMinusOne) {
                return SpreadsheetView.SpanType.ROW_VISIBLE;
            }
            return SpreadsheetView.SpanType.ROW_SPAN_INVISIBLE;
        }
        if (!(cellSpanColumnSpan <= 1 || cellSpanColumn == column || cellSpanRow != row && containsRowMinusOne)) {
            return SpreadsheetView.SpanType.COLUMN_SPAN_INVISIBLE;
        }
        return SpreadsheetView.SpanType.NORMAL_CELL;
    }

    public void spanRow(int count, int rowIndex, int colIndex) {
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.rows.get(rowIndex)).get(colIndex);
        int colSpan = cell.getColumnSpan();
        int rowSpan = count;
        cell.setRowSpan(rowSpan);
        int row = rowIndex;
        while (row < rowIndex + rowSpan && row < this.rowCount) {
            int col = colIndex;
            while (col < colIndex + colSpan && col < this.columnCount) {
                if (row != rowIndex || col != colIndex) {
                    ((ObservableList)this.rows.get(row)).set(col, (Object)cell);
                }
                ++col;
            }
            ++row;
        }
    }

    public void spanColumn(int count, int rowIndex, int colIndex) {
        SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.rows.get(rowIndex)).get(colIndex);
        int colSpan = count;
        int rowSpan = cell.getRowSpan();
        cell.setColumnSpan(colSpan);
        int row = rowIndex;
        while (row < rowIndex + rowSpan && row < this.rowCount) {
            int col = colIndex;
            while (col < colIndex + colSpan && col < this.columnCount) {
                if (row != rowIndex || col != colIndex) {
                    ((ObservableList)this.rows.get(row)).set(col, (Object)cell);
                }
                ++col;
            }
            ++row;
        }
    }

    public void setRows(Collection<ObservableList<SpreadsheetCell>> rows) {
        this.rows = rows instanceof ObservableList ? (ObservableList)rows : FXCollections.observableArrayList(rows);
        this.setRowCount(rows.size());
    }

    private void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    private void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    private final boolean containsRow(SpreadsheetView spv, int index) {
        GridViewSkin skin = spv.getCellsViewSkin();
        int size = skin.getCellsSize();
        int i = 0;
        while (i < size) {
            if (skin.getCell(i).getIndex() == index) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

