/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.io.Serializable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;

public class SpreadsheetCell
implements Serializable {
    private static final long serialVersionUID = -7648169794403402662L;
    private final transient SpreadsheetCellType type;
    private final int row;
    private final int column;
    private transient int rowSpan;
    private transient int columnSpan;
    private String text;
    private transient ObservableList<String> styleClass;
    private transient ObjectProperty<Object> item = new SimpleObjectProperty<Object>((Object)this, "item"){

        protected void invalidated() {
            SpreadsheetCell.this.updateText();
        }
    };
    private transient BooleanProperty editable;
    private transient ObservableMap<Object, Object> properties;

    public SpreadsheetCell(int row, int column, int rowSpan, int columnSpan) {
        this(row, column, rowSpan, columnSpan, SpreadsheetCellType.OBJECT);
    }

    public SpreadsheetCell(int row, int column, int rowSpan, int columnSpan, SpreadsheetCellType<?> type) {
        this.row = row;
        this.column = column;
        this.rowSpan = rowSpan;
        this.columnSpan = columnSpan;
        this.type = type;
        this.text = "";
    }

    public boolean match(SpreadsheetCell cell) {
        return this.type.copy(cell, this);
    }

    public final void setItem(Object value) {
        if (this.isEditable()) {
            this.item.set(value);
        }
    }

    public final Object getItem() {
        return this.item.get();
    }

    public final ObjectProperty<?> itemProperty() {
        return this.item;
    }

    public final boolean isEditable() {
        return this.editable == null ? true : this.editable.get();
    }

    public final void setEditable(boolean readOnly) {
        this.editableProperty().set(readOnly);
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty((Object)this, "editable", true);
        }
        return this.editable;
    }

    public final String getText() {
        return this.text;
    }

    public final SpreadsheetCellType<?> getCellType() {
        return this.type;
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public final int getRowSpan() {
        return this.rowSpan;
    }

    public final void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public final int getColumnSpan() {
        return this.columnSpan;
    }

    public final void setColumnSpan(int columnSpan) {
        this.columnSpan = columnSpan;
    }

    public final ObservableList<String> getStyleClass() {
        if (this.styleClass == null) {
            this.styleClass = FXCollections.observableArrayList();
        }
        return this.styleClass;
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableHashMap();
        }
        return this.properties;
    }

    public final boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public String toString() {
        return "cell[" + this.row + "][" + this.column + "]" + this.rowSpan + "-" + this.columnSpan;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpreadsheetCell)) {
            return false;
        }
        SpreadsheetCell cell = (SpreadsheetCell)obj;
        return cell != null && cell.getRow() == this.row && cell.getColumn() == this.column && cell.getText().equals(this.text);
    }

    private void updateText() {
        this.text = this.type.toString(this.getItem());
    }
}

