/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.time.LocalDate;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public abstract class SpreadsheetCellEditor<T> {
    SpreadsheetView view;

    public SpreadsheetCellEditor(SpreadsheetView view) {
        this.view = view;
    }

    public final void endEdit(boolean b) {
        this.view.getCellsViewSkin().getSpreadsheetCellEditorImpl().endEdit(b);
    }

    public abstract void startEdit(Object var1);

    public abstract Control getEditor();

    public abstract String getControlValue();

    public abstract void end();

    public static class DateEditor
    extends SpreadsheetCellEditor<LocalDate> {
        protected final DatePicker datePicker = new DatePicker();
        protected EventHandler<KeyEvent> eh;
        protected ChangeListener<LocalDate> cl;

        public DateEditor(SpreadsheetView view) {
            super(view);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof LocalDate) {
                this.datePicker.setValue((Object)((LocalDate)value));
            }
            this.attachEnterEscapeEventHandler();
            this.datePicker.show();
            this.datePicker.getEditor().requestFocus();
        }

        @Override
        public void end() {
            if (this.datePicker.isShowing()) {
                this.datePicker.hide();
            }
            this.datePicker.removeEventFilter(KeyEvent.KEY_PRESSED, this.eh);
            this.datePicker.valueProperty().removeListener(this.cl);
        }

        public DatePicker getEditor() {
            return this.datePicker;
        }

        @Override
        public String getControlValue() {
            return this.datePicker.getEditor().getText();
        }

        protected void attachEnterEscapeEventHandler() {
            this.eh = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ENTER) {
                        DateEditor.this.endEdit(true);
                    } else if (t.getCode() == KeyCode.ESCAPE) {
                        DateEditor.this.endEdit(false);
                    }
                }
            };
            this.datePicker.addEventFilter(KeyEvent.KEY_PRESSED, this.eh);
            this.cl = new ChangeListener<LocalDate>(){

                public void changed(ObservableValue<? extends LocalDate> arg0, LocalDate arg1, LocalDate arg2) {
                    DateEditor.this.endEdit(true);
                }
            };
            this.datePicker.valueProperty().addListener(this.cl);
        }
    }

    public static class DoubleEditor
    extends SpreadsheetCellEditor<Double> {
        protected final TextField tf = new TextField();

        public DoubleEditor(SpreadsheetView view) {
            super(view);
            this.tf.setPrefHeight(20.0);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof Double) {
                this.tf.setText(((Double)value).isNaN() ? "" : value.toString());
            }
            this.tf.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.tf.setMaxHeight(20.0);
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.end();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        protected void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ENTER) {
                        DoubleEditor.this.endEdit(true);
                    } else if (t.getCode() == KeyCode.ESCAPE) {
                        DoubleEditor.this.endEdit(false);
                    }
                }
            });
            this.tf.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    try {
                        if (DoubleEditor.this.tf.getText().equals("")) {
                            DoubleEditor.this.tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        } else {
                            Double.parseDouble(DoubleEditor.this.tf.getText());
                            DoubleEditor.this.tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        }
                    }
                    catch (Exception e) {
                        DoubleEditor.this.tf.getStyleClass().add((Object)"error");
                    }
                }
            });
        }
    }

    public static class ListEditor
    extends SpreadsheetCellEditor<String> {
        protected final List<String> itemList;
        protected final ComboBox<String> cb;
        private String originalValue;

        public ListEditor(SpreadsheetView view, List<String> itemList) {
            super(view);
            this.itemList = itemList;
            this.cb = new ComboBox();
            this.cb.setVisibleRowCount(3);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof String) {
                ObservableList items = FXCollections.observableList(this.itemList);
                this.cb.setItems(items);
                this.originalValue = value.toString();
                this.cb.setValue((Object)this.originalValue);
            }
            this.attachEnterEscapeEventHandler();
            this.cb.show();
            this.cb.requestFocus();
        }

        @Override
        public void end() {
            this.cb.setOnKeyPressed(null);
        }

        public ComboBox<String> getEditor() {
            return this.cb;
        }

        @Override
        public String getControlValue() {
            return (String)this.cb.getSelectionModel().getSelectedItem();
        }

        protected void attachEnterEscapeEventHandler() {
            this.cb.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ESCAPE) {
                        ListEditor.this.cb.setValue((Object)ListEditor.this.originalValue);
                        ListEditor.this.endEdit(false);
                    } else if (t.getCode() == KeyCode.ENTER) {
                        ListEditor.this.endEdit(true);
                    }
                }
            });
        }
    }

    public static class ObjectEditor
    extends SpreadsheetCellEditor<Object> {
        protected final TextField tf = new TextField();

        public ObjectEditor(SpreadsheetView view) {
            super(view);
            this.tf.setPrefHeight(20.0);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof String) {
                this.tf.setText(value.toString());
            }
            this.tf.setMaxHeight(20.0);
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.end();
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        protected void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ENTER) {
                        ObjectEditor.this.endEdit(true);
                    } else if (t.getCode() == KeyCode.ESCAPE) {
                        ObjectEditor.this.endEdit(false);
                    }
                }
            });
        }
    }

    public static class StringEditor
    extends SpreadsheetCellEditor<String> {
        protected final TextField tf = new TextField();

        public StringEditor(SpreadsheetView view) {
            super(view);
            this.tf.setPrefHeight(20.0);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof String) {
                this.tf.setText((String)value);
            }
            this.tf.setMaxHeight(20.0);
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.end();
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        protected void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ENTER) {
                        StringEditor.this.endEdit(true);
                    } else if (t.getCode() == KeyCode.ESCAPE) {
                        StringEditor.this.endEdit(false);
                    }
                }
            });
        }
    }
}

