/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public abstract class SpreadsheetCellType<T> {
    protected transient StringConverter<T> converter;
    public static final SpreadsheetCellType<Object> OBJECT = new ObjectType();
    public static final SpreadsheetCellType<String> STRING = new StringType();
    public static final SpreadsheetCellType<Double> DOUBLE = new DoubleType();
    public static final SpreadsheetCellType<LocalDate> DATE = new DateType();

    public SpreadsheetCellType(StringConverter<T> converter) {
        this.converter = converter;
    }

    public abstract SpreadsheetCell createCell(int var1, int var2, int var3, int var4, T var5);

    public abstract SpreadsheetCellEditor<T> createEditor(SpreadsheetView var1);

    public abstract String toString(T var1);

    protected abstract boolean copy(SpreadsheetCell var1, SpreadsheetCell var2);

    public abstract T convertValue(String var1);

    public static final SpreadsheetCellType<String> LIST(List<String> items) {
        return new ListType(items);
    }

    public static class DateType
    extends SpreadsheetCellType<LocalDate> {
        public DateType() {
            this("dd/MM/yyyy");
        }

        public DateType(final String format) {
            this(new StringConverter<LocalDate>(){

                public String toString(LocalDate item) {
                    return item.format(DateTimeFormatter.ofPattern(format));
                }

                public LocalDate fromString(String str) {
                    try {
                        return LocalDate.parse(str, DateTimeFormatter.ofPattern(format));
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }

        public DateType(StringConverter<LocalDate> converter) {
            super(converter);
        }

        public String toString() {
            return "date";
        }

        @Override
        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, LocalDate value) {
            SpreadsheetCell cell = new SpreadsheetCell(row, column, rowSpan, columnSpan, this);
            cell.setItem(value);
            return cell;
        }

        @Override
        public SpreadsheetCellEditor<LocalDate> createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.DateEditor(view);
        }

        @Override
        protected boolean copy(SpreadsheetCell from, SpreadsheetCell to) {
            try {
                LocalDate temp = (LocalDate)this.converter.fromString(from.getText());
                if (temp != null) {
                    to.setItem(temp);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public LocalDate convertValue(String value) {
            try {
                return (LocalDate)this.converter.fromString(value);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String toString(LocalDate item) {
            return this.converter.toString((Object)item);
        }
    }

    public static class DoubleType
    extends SpreadsheetCellType<Double> {
        public DoubleType() {
            this(new DoubleStringConverter(){

                public String toString(Double item) {
                    if (item == null || Double.isNaN(item)) {
                        return "";
                    }
                    return super.toString(item);
                }

                public Double fromString(String str) {
                    if (str == null || str.isEmpty() || "NaN".equals(str)) {
                        return Double.NaN;
                    }
                    return super.fromString(str);
                }
            });
        }

        public DoubleType(DoubleStringConverter converter) {
            super(converter);
        }

        public String toString() {
            return "double";
        }

        @Override
        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, Double value) {
            SpreadsheetCell cell = new SpreadsheetCell(row, column, rowSpan, columnSpan, this);
            cell.setItem(value);
            return cell;
        }

        @Override
        public SpreadsheetCellEditor<Double> createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.DoubleEditor(view);
        }

        @Override
        protected boolean copy(SpreadsheetCell from, SpreadsheetCell to) {
            try {
                Double temp = (Double)this.converter.fromString(from.getText());
                to.setItem(temp);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public Double convertValue(String value) {
            try {
                return (Double)this.converter.fromString(value);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public String toString(Double item) {
            return this.converter.toString((Object)item);
        }
    }

    public static class ListType
    extends SpreadsheetCellType<String> {
        protected final List<String> items;

        public ListType(final List<String> items) {
            super(new DefaultStringConverter(){

                public String fromString(String str) {
                    if (str != null && items.contains(str)) {
                        return str;
                    }
                    return null;
                }
            });
            this.items = items;
        }

        public String toString() {
            return "list";
        }

        @Override
        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, String item) {
            SpreadsheetCell cell = new SpreadsheetCell(row, column, rowSpan, columnSpan, this);
            if (this.items != null && this.items.size() > 0) {
                if (item != null && this.items.contains(item)) {
                    cell.setItem(item);
                } else {
                    cell.setItem(this.items.get(0));
                }
            }
            return cell;
        }

        @Override
        public SpreadsheetCellEditor<String> createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.ListEditor(view, this.items);
        }

        @Override
        protected boolean copy(SpreadsheetCell from, SpreadsheetCell to) {
            String value = from.getText();
            if (this.items.contains(value)) {
                to.setItem(value);
                return true;
            }
            return false;
        }

        @Override
        public String convertValue(String value) {
            return (String)this.converter.fromString(value);
        }

        @Override
        public String toString(String item) {
            return this.converter.toString((Object)item);
        }
    }

    public static class ObjectType
    extends SpreadsheetCellType<Object> {
        public ObjectType() {
            this(new StringConverter<Object>(){

                public Object fromString(String arg0) {
                    return arg0;
                }

                public String toString(Object arg0) {
                    return arg0 == null ? "" : arg0.toString();
                }
            });
        }

        public ObjectType(StringConverter<Object> converter) {
            super(converter);
        }

        public String toString() {
            return "object";
        }

        @Override
        protected boolean copy(SpreadsheetCell from, SpreadsheetCell to) {
            to.setItem(from.getText());
            return true;
        }

        @Override
        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, Object value) {
            SpreadsheetCell cell = new SpreadsheetCell(row, column, rowSpan, columnSpan, this);
            cell.setItem(value);
            return cell;
        }

        @Override
        public SpreadsheetCellEditor<Object> createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.ObjectEditor(view);
        }

        @Override
        public Object convertValue(String value) {
            return this.converter.fromString(value);
        }

        @Override
        public String toString(Object item) {
            return this.converter.toString(item);
        }
    }

    public static class StringType
    extends SpreadsheetCellType<String> {
        public StringType() {
            this((StringConverter<String>)new DefaultStringConverter());
        }

        public StringType(StringConverter<String> converter) {
            super(converter);
        }

        public String toString() {
            return "string";
        }

        @Override
        protected boolean copy(SpreadsheetCell from, SpreadsheetCell to) {
            to.setItem(from.getText());
            return true;
        }

        @Override
        public SpreadsheetCell createCell(int row, int column, int rowSpan, int columnSpan, String value) {
            SpreadsheetCell cell = new SpreadsheetCell(row, column, rowSpan, columnSpan, this);
            cell.setItem(value);
            return cell;
        }

        @Override
        public SpreadsheetCellEditor<String> createEditor(SpreadsheetView view) {
            return new SpreadsheetCellEditor.StringEditor(view);
        }

        @Override
        public String convertValue(String value) {
            return (String)this.converter.fromString(value);
        }

        @Override
        public String toString(String item) {
            return this.converter.toString((Object)item);
        }
    }
}

