/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class SpreadsheetColumn<T> {
    private SpreadsheetView spreadsheetView;
    private TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell> column;
    private boolean canFix;
    private Integer indexColumn;
    private CheckMenuItem fixItem;

    SpreadsheetColumn(final TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell> column, SpreadsheetView spreadsheetView, Integer indexColumn) {
        this.spreadsheetView = spreadsheetView;
        this.column = column;
        this.indexColumn = indexColumn;
        this.canFix = this.initCanFix();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                column.setContextMenu(SpreadsheetColumn.this.getColumnContextMenu());
            }
        };
        Platform.runLater((Runnable)r);
        if (this.canFix) {
            column.setText(String.valueOf(column.getText()) + ".");
        }
        spreadsheetView.getGrid().getRows().addListener((ListChangeListener)new ListChangeListener<ObservableList<SpreadsheetCell>>(){

            public void onChanged(ListChangeListener.Change<? extends ObservableList<SpreadsheetCell>> arg0) {
                SpreadsheetColumn.this.initCanFix();
            }
        });
    }

    public boolean isFixed() {
        return this.spreadsheetView.getFixedColumns().contains((Object)this);
    }

    public void setFixed(boolean fixed) {
        if (fixed) {
            this.spreadsheetView.getFixedColumns().add((Object)this);
        } else {
            this.spreadsheetView.getFixedColumns().removeAll((Object[])new SpreadsheetColumn[]{this});
        }
    }

    public void setPrefWidth(double width) {
        this.column.setPrefWidth(width);
    }

    public double getWidth() {
        return this.column.getWidth();
    }

    public void setResizable(boolean b) {
        this.column.setResizable(b);
    }

    public void fitColumn() {
        if (this.column.isResizable()) {
            this.spreadsheetView.getCellsViewSkin().resizeColumnToFitContent(this.column, -1);
        }
    }

    public boolean isColumnFixable() {
        return this.canFix;
    }

    public void setText(String text) {
        this.column.setText(text);
    }

    public String getText() {
        return this.column.getText();
    }

    private ContextMenu getColumnContextMenu() {
        if (this.canFix) {
            ContextMenu contextMenu = new ContextMenu();
            this.fixItem = new CheckMenuItem("Fix");
            this.fixItem.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                    if (!SpreadsheetColumn.this.isFixed()) {
                        SpreadsheetColumn.this.setFixed(true);
                    } else {
                        SpreadsheetColumn.this.setFixed(false);
                    }
                }
            });
            contextMenu.getItems().addAll((Object[])new MenuItem[]{this.fixItem});
            return contextMenu;
        }
        return new ContextMenu();
    }

    private boolean initCanFix() {
        for (ObservableList row : this.spreadsheetView.getGrid().getRows()) {
            int columnSpan = ((SpreadsheetCell)row.get(this.indexColumn.intValue())).getColumnSpan();
            if (columnSpan <= 1 && ((SpreadsheetCell)row.get(this.indexColumn.intValue())).getRowSpan() <= 1) continue;
            return false;
        }
        return true;
    }
}

