/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;

public class SpreadsheetView
extends Control {
    private final SpreadsheetGridView cellsView;
    private Grid grid;
    private DataFormat fmt;
    private final ObservableList<Integer> fixedRows = FXCollections.observableArrayList();
    private final ObservableList<SpreadsheetColumn<?>> fixedColumns = FXCollections.observableArrayList();
    private ObservableList<SpreadsheetColumn<?>> columns = FXCollections.observableArrayList();
    private Map<SpreadsheetCellType<?>, SpreadsheetCellEditor<?>> editors = new IdentityHashMap();
    private BitSet rowFix;
    private ObservableList<SpreadsheetCell> modifiedCells = FXCollections.observableArrayList();
    final SpreadsheetHandle handle = new SpreadsheetHandle(){

        @Override
        protected SpreadsheetView getView() {
            return SpreadsheetView.this;
        }

        @Override
        protected GridViewSkin getCellsViewSkin() {
            return SpreadsheetView.this.getCellsViewSkin();
        }

        @Override
        protected SpreadsheetGridView getGridView() {
            return SpreadsheetView.this.getCellsView();
        }
    };
    private final ReadOnlyBooleanProperty showColumnHeader = new SimpleBooleanProperty((Object)true, "showColumnHeader", true);
    private final BooleanProperty showRowHeader = new SimpleBooleanProperty((Object)true, "showRowHeader", true);
    private ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> c) {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                List newRows = c.getAddedSubList();
                Iterator iterator = newRows.iterator();
                while (iterator.hasNext()) {
                    int row = (Integer)iterator.next();
                    if (SpreadsheetView.this.isRowFixable(row)) continue;
                    throw new IllegalArgumentException(this.computeReason(row));
                }
                FXCollections.sort((ObservableList)SpreadsheetView.this.fixedRows);
            }
        }

        private String computeReason(Integer element) {
            String reason = "\n This row cannot be fixed.";
            for (SpreadsheetCell cell : (ObservableList)SpreadsheetView.this.getGrid().getRows().get(element.intValue())) {
                if (cell.getRowSpan() <= 1) continue;
                reason = String.valueOf(reason) + "The cell situated at line " + cell.getRow() + " and column " + cell.getColumn() + "\n has a rowSpan of " + cell.getRowSpan() + ", it must be 1.";
                return reason;
            }
            return reason;
        }
    };
    private ListChangeListener<SpreadsheetColumn<?>> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn<?>>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn<?>> c) {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                List newRows = c.getAddedSubList();
                for (SpreadsheetColumn row : newRows) {
                    if (row.isColumnFixable()) continue;
                    throw new IllegalArgumentException(this.computeReason(row));
                }
                FXCollections.sort((ObservableList)SpreadsheetView.this.fixedRows);
            }
        }

        private String computeReason(SpreadsheetColumn<?> element) {
            int indexColumn = SpreadsheetView.this.getColumns().indexOf(element);
            String reason = "\n This column cannot be fixed.";
            for (ObservableList row : SpreadsheetView.this.getGrid().getRows()) {
                int columnSpan = ((SpreadsheetCell)row.get(indexColumn)).getColumnSpan();
                if (columnSpan <= 1 && ((SpreadsheetCell)row.get(indexColumn)).getRowSpan() <= 1) continue;
                reason = String.valueOf(reason) + "The cell situated at line " + ((SpreadsheetCell)row.get(indexColumn)).getRow() + " and column " + indexColumn + "\n has a rowSpan or a ColumnSpan superior to 1, it must be 1.";
                return reason;
            }
            return reason;
        }
    };
    private ListChangeListener<SpreadsheetCell> modifiedCellsListener = new ListChangeListener<SpreadsheetCell>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetCell> arg0) {
            while (arg0.next()) {
                if (!arg0.wasAdded()) continue;
                List newRows = arg0.getAddedSubList();
                for (SpreadsheetCell cell : newRows) {
                    if (cell.getStyleClass().contains((Object)"modified")) continue;
                    cell.getStyleClass().add((Object)"modified");
                }
            }
        }
    };

    final GridViewSkin getCellsViewSkin() {
        return (GridViewSkin)this.cellsView.getSkin();
    }

    final SpreadsheetGridView getCellsView() {
        return this.cellsView;
    }

    public SpreadsheetView() {
        this(null);
    }

    public SpreadsheetView(Grid grid) {
        this.verifyGrid(grid);
        this.getStyleClass().add((Object)"SpreadsheetView");
        this.setSkin((Skin)new Skin<SpreadsheetView>(){

            public Node getNode() {
                return SpreadsheetView.this.getCellsView();
            }

            public SpreadsheetView getSkinnable() {
                return SpreadsheetView.this;
            }

            public void dispose() {
            }
        });
        this.cellsView = new SpreadsheetGridView(this.handle);
        this.getChildren().add((Object)this.cellsView);
        SpreadsheetViewSelectionModel selectionModel = new SpreadsheetViewSelectionModel(this);
        this.cellsView.setSelectionModel(selectionModel);
        selectionModel.setCellSelectionEnabled(true);
        selectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        this.cellsView.getFocusModel().focusedCellProperty().addListener((ChangeListener)new FocusModelListener(this));
        this.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent arg0) {
                if (arg0.isShortcutDown() && arg0.getCode().compareTo((Enum)KeyCode.C) == 0) {
                    SpreadsheetView.this.copyClipBoard();
                } else if (arg0.isShortcutDown() && arg0.getCode().compareTo((Enum)KeyCode.V) == 0) {
                    SpreadsheetView.this.pasteClipboard();
                } else if (!(arg0.isShortcutDown() || arg0.isControlDown() || arg0.isAltDown() || arg0.isMetaDown() || arg0.isShiftDown() || arg0.getCode().compareTo((Enum)KeyCode.ESCAPE) == 0)) {
                    TablePosition position = SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
                    SpreadsheetView.this.cellsView.edit(position.getRow(), position.getTableColumn());
                }
            }
        });
        this.initRowFix(grid);
        this.contextMenuProperty().addListener((ChangeListener)new ChangeListener<ContextMenu>(){

            public void changed(ObservableValue<? extends ContextMenu> arg0, ContextMenu arg1, final ContextMenu arg2) {
                arg2.setOnShowing((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent arg0) {
                        if (SpreadsheetView.this.getEditingCell() != null) {
                            Runnable r = new Runnable(){

                                @Override
                                public void run() {
                                    arg2.hide();
                                }
                            };
                            Platform.runLater((Runnable)r);
                        }
                    }
                });
            }
        });
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SpreadsheetView.this.setContextMenu(SpreadsheetView.this.getSpreadsheetViewContextMenu());
            }
        };
        Platform.runLater((Runnable)r);
        this.setGrid(grid);
        this.fixedRows.addListener(this.fixedRowsListener);
        this.fixedColumns.addListener(this.fixedColumnsListener);
        this.modifiedCells.addListener(this.modifiedCellsListener);
    }

    public TablePosition<ObservableList<SpreadsheetCell>, ?> getEditingCell() {
        return this.cellsView.getEditingCell();
    }

    public ObservableList<SpreadsheetColumn<?>> getColumns() {
        return FXCollections.unmodifiableObservableList(this.columns);
    }

    public final Grid getGrid() {
        return this.grid;
    }

    public final boolean isShowColumnHeader() {
        return this.showColumnHeader.get();
    }

    public final ReadOnlyBooleanProperty showColumnHeaderProperty() {
        return this.showColumnHeader;
    }

    public final void setShowRowHeader(boolean b) {
        this.showRowHeader.setValue(Boolean.valueOf(b));
    }

    public final boolean isShowRowHeader() {
        return this.showRowHeader.get();
    }

    public final BooleanProperty showRowHeaderProperty() {
        return this.showRowHeader;
    }

    public ObservableList<Integer> getFixedRows() {
        return this.fixedRows;
    }

    public boolean isRowFixable(int row) {
        return row < this.rowFix.size() ? this.rowFix.get(row) : false;
    }

    public ObservableList<SpreadsheetColumn<?>> getFixedColumns() {
        return this.fixedColumns;
    }

    public boolean isColumnFixable(int columnIndex) {
        return columnIndex < this.getColumns().size() ? Boolean.valueOf(((SpreadsheetColumn)this.getColumns().get(columnIndex)).isColumnFixable()) : null;
    }

    public TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> getSelectionModel() {
        return this.cellsView.getSelectionModel();
    }

    public SpreadsheetCellEditor<?> getEditor(SpreadsheetCellType<?> cellType) {
        SpreadsheetCellEditor<?> cellEditor = this.editors.get(cellType);
        if (cellEditor == null) {
            cellEditor = cellType.createEditor(this);
            this.editors.put(cellType, cellEditor);
        }
        return cellEditor;
    }

    public ObservableList<SpreadsheetCell> getModifiedCells() {
        return this.modifiedCells;
    }

    private void verifyGrid(Grid grid) {
        this.verifyColumnSpan(grid);
    }

    private void verifyColumnSpan(Grid grid) {
        int i = 0;
        while (i < grid.getRows().size()) {
            ObservableList row = (ObservableList)grid.getRows().get(i);
            int count = 0;
            int j = 0;
            while (j < row.size()) {
                if (((SpreadsheetCell)row.get(j)).getColumnSpan() == 1) {
                    ++count;
                } else if (((SpreadsheetCell)row.get(j)).getColumnSpan() > 1) {
                    ++count;
                    SpreadsheetCell currentCell = (SpreadsheetCell)row.get(j);
                    int k = j + 1;
                    while (k < currentCell.getColumn() + currentCell.getColumnSpan()) {
                        if (!((SpreadsheetCell)row.get(k)).equals(currentCell)) {
                            throw new IllegalStateException("\n At row " + i + " and column " + j + ": this cell is in the range of a columnSpan but is different. \n" + "Every cell in a range of a ColumnSpan must be of the same instance.");
                        }
                        ++count;
                        ++j;
                        ++k;
                    }
                } else {
                    throw new IllegalStateException("\n At row " + i + " and column " + j + ": this cell has a negative columnSpan");
                }
                ++j;
            }
            if (count != grid.getColumnCount()) {
                throw new IllegalStateException("The row" + i + " has a number of cells different of the columnCount declared in the grid.");
            }
            ++i;
        }
    }

    private SpanType getSpanType(int row, int column) {
        Grid grid = this.getGrid();
        if (grid == null) {
            return SpanType.NORMAL_CELL;
        }
        return grid.getSpanType(this, row, column);
    }

    private ObservableList<ObservableList<SpreadsheetCell>> getItems() {
        return this.cellsView.getItems();
    }

    private GridRow getNonFixedRow(int index) {
        GridViewSkin skin = (GridViewSkin)this.cellsView.getSkin();
        return skin.getCell(this.fixedRows.size() + index);
    }

    private final boolean containsRow(int index) {
        GridViewSkin skin = (GridViewSkin)this.cellsView.getSkin();
        int size = skin.getCellsSize();
        int i = 0;
        while (i < size) {
            if (skin.getCell(i).getIndex() == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final void setGrid(Grid grid) {
        this.grid = grid;
        if (grid.getRows() != null) {
            ObservableList observableRows = FXCollections.observableArrayList(grid.getRows());
            this.cellsView.getItems().clear();
            this.cellsView.setItems(observableRows);
            int columnCount = grid.getColumnCount();
            this.columns.clear();
            int i = 0;
            while (i < columnCount) {
                final int col = i;
                TableColumn column = new TableColumn(this.getEquivColumn(col));
                column.setEditable(true);
                column.setSortable(false);
                column.impl_setReorderable(false);
                column.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList<SpreadsheetCell>, SpreadsheetCell>, ObservableValue<SpreadsheetCell>>(){

                    public ObservableValue<SpreadsheetCell> call(TableColumn.CellDataFeatures<ObservableList<SpreadsheetCell>, SpreadsheetCell> p) {
                        return new ReadOnlyObjectWrapper((Object)((SpreadsheetCell)((ObservableList)p.getValue()).get(col)));
                    }
                });
                SpreadsheetView view = this;
                column.setCellFactory((Callback)new Callback<TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell>, TableCell<ObservableList<SpreadsheetCell>, SpreadsheetCell>>(){

                    public TableCell<ObservableList<SpreadsheetCell>, SpreadsheetCell> call(TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell> p) {
                        return new CellView(SpreadsheetView.this.handle);
                    }
                });
                this.cellsView.getColumns().add((Object)column);
                SpreadsheetColumn spreadsheetColumns = new SpreadsheetColumn((TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell>)column, this, i);
                this.columns.add(spreadsheetColumns);
                ++i;
            }
        }
    }

    private final String getEquivColumn(int number) {
        String converted = "";
        while (number >= 0) {
            int remainder = number % 26;
            converted = String.valueOf((char)(remainder + 65)) + converted;
            number = number / 26 - 1;
        }
        return converted;
    }

    private void initRowFix(Grid grid) {
        ObservableList<ObservableList<SpreadsheetCell>> rows = grid.getRows();
        this.rowFix = new BitSet(rows.size());
        int r = 0;
        while (r < rows.size()) {
            block3: {
                ObservableList row = (ObservableList)rows.get(r);
                for (SpreadsheetCell cell : row) {
                    if (cell.getRowSpan() <= 1) {
                        continue;
                    }
                    break block3;
                }
                this.rowFix.set(r);
            }
            ++r;
        }
    }

    private void checkFormat() {
        this.fmt = DataFormat.lookupMimeType((String)"shuttle");
        if (this.fmt == null) {
            this.fmt = new DataFormat(new String[]{"shuttle"});
        }
    }

    private ContextMenu getSpreadsheetViewContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem item1 = new MenuItem("Copy");
        item1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SpreadsheetView.this.copyClipBoard();
            }
        });
        MenuItem item2 = new MenuItem("Paste");
        item2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                SpreadsheetView.this.pasteClipboard();
            }
        });
        contextMenu.getItems().addAll((Object[])new MenuItem[]{item1, item2});
        return contextMenu;
    }

    private void copyClipBoard() {
        this.checkFormat();
        ArrayList<SpreadsheetCell> list = new ArrayList<SpreadsheetCell>();
        ObservableList posList = this.getSelectionModel().getSelectedCells();
        for (TablePosition p : posList) {
            list.add((SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(p.getRow())).get(p.getColumn()));
        }
        ClipboardContent content = new ClipboardContent();
        content.put((Object)this.fmt, list);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void pasteClipboard() {
        this.checkFormat();
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.getContent(this.fmt) != null) {
            SpreadsheetCell p2;
            ArrayList list = (ArrayList)clipboard.getContent(this.fmt);
            int minRow = this.grid.getRowCount();
            int minCol = this.grid.getColumnCount();
            int maxRow = 0;
            int maxCol = 0;
            for (SpreadsheetCell p2 : list) {
                int tempcol = p2.getColumn();
                int temprow = p2.getRow();
                if (tempcol < minCol) {
                    minCol = tempcol;
                }
                if (tempcol > maxCol) {
                    maxCol = tempcol;
                }
                if (temprow < minRow) {
                    minRow = temprow;
                }
                if (temprow <= maxRow) continue;
                maxRow = temprow;
            }
            p2 = this.cellsView.getFocusModel().getFocusedCell();
            int offsetRow = p2.getRow() - minRow;
            int offsetCol = p2.getColumn() - minCol;
            for (SpreadsheetCell row1 : list) {
                SpanType type;
                int row = row1.getRow();
                int column = row1.getColumn();
                if (row + offsetRow >= this.getGrid().getRowCount() || column + offsetCol >= this.getGrid().getColumnCount() || row + offsetRow < 0 || column + offsetCol < 0 || (type = this.getSpanType(row + offsetRow, column + offsetCol)) != SpanType.NORMAL_CELL && type != SpanType.ROW_VISIBLE) continue;
                SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(row + offsetRow)).get(column + offsetCol);
                Object item = cell.getItem();
                boolean succeed = cell.match(row1);
                if (!succeed || item.equals(cell.getItem()) || this.getModifiedCells().contains((Object)cell)) continue;
                this.getModifiedCells().add((Object)cell);
            }
        } else if (clipboard.hasString()) {
            TablePosition p = this.cellsView.getFocusModel().getFocusedCell();
            SpreadsheetCell stringCell = SpreadsheetCellType.STRING.createCell(0, 0, 1, 1, clipboard.getString());
            ((SpreadsheetCell)((ObservableList)this.getGrid().getRows().get(p.getRow())).get(p.getColumn())).match(stringCell);
        }
    }

    private TableColumn<ObservableList<SpreadsheetCell>, ?> getTableColumnSpan(TablePosition<?, ?> t) {
        return this.cellsView.getVisibleLeafColumn(t.getColumn() + ((SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(t.getRow())).get(t.getColumn())).getColumnSpan());
    }

    private int getTableColumnSpanInt(TablePosition<?, ?> t) {
        return t.getColumn() + ((SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(t.getRow())).get(t.getColumn())).getColumnSpan();
    }

    private int getTableRowSpan(TablePosition<?, ?> t) {
        return ((SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(t.getRow())).get(t.getColumn())).getRowSpan() + ((SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(t.getRow())).get(t.getColumn())).getRow();
    }

    private TablePosition<ObservableList<SpreadsheetCell>, ?> getVisibleCell(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column, int col) {
        SpanType spanType = this.getSpanType(row, col);
        switch (spanType) {
            case NORMAL_CELL: 
            case ROW_VISIBLE: {
                return new TablePosition((TableView)this.cellsView, row, column);
            }
        }
        SpreadsheetCell cellSpan = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(row)).get(col);
        if (this.getCellsViewSkin().getCellsSize() != 0 && this.getNonFixedRow(0).getIndex() <= cellSpan.getRow()) {
            return new TablePosition((TableView)this.cellsView, cellSpan.getRow(), (TableColumn)this.cellsView.getColumns().get(cellSpan.getColumn()));
        }
        return new TablePosition((TableView)this.cellsView, this.getNonFixedRow(0).getIndex(), (TableColumn)this.cellsView.getColumns().get(cellSpan.getColumn()));
    }

    class FocusModelListener
    implements ChangeListener<TablePosition<ObservableList<SpreadsheetCell>, ?>> {
        private final TableView.TableViewFocusModel<ObservableList<SpreadsheetCell>> tfm;

        public FocusModelListener(SpreadsheetView spreadsheetView2) {
            this.tfm = SpreadsheetView.this.cellsView.getFocusModel();
        }

        public void changed(ObservableValue<? extends TablePosition<ObservableList<SpreadsheetCell>, ?>> ov, final TablePosition<ObservableList<SpreadsheetCell>, ?> t, final TablePosition<ObservableList<SpreadsheetCell>, ?> t1) {
            SpanType spanType = SpreadsheetView.this.getSpanType(t1.getRow(), t1.getColumn());
            switch (spanType) {
                case ROW_SPAN_INVISIBLE: {
                    if (!SpreadsheetView.this.isPressed() && t.getColumn() == t1.getColumn() && t.getRow() == t1.getRow() - 1) {
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                FocusModelListener.this.tfm.focus(SpreadsheetView.this.getTableRowSpan(t), t.getTableColumn());
                            }
                        };
                        Platform.runLater((Runnable)r);
                        break;
                    }
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            FocusModelListener.this.tfm.focus(t1.getRow() - 1, t1.getTableColumn());
                        }
                    };
                    Platform.runLater((Runnable)r);
                    break;
                }
                case BOTH_INVISIBLE: {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            FocusModelListener.this.tfm.focus(t1.getRow() - 1, (TableColumn)SpreadsheetView.this.cellsView.getColumns().get(t1.getColumn() - 1));
                        }
                    };
                    Platform.runLater((Runnable)r);
                    break;
                }
                case COLUMN_SPAN_INVISIBLE: {
                    if (!SpreadsheetView.this.isPressed() && t.getColumn() == t1.getColumn() - 1 && t.getRow() == t1.getRow()) {
                        Runnable r2 = new Runnable(){

                            @Override
                            public void run() {
                                FocusModelListener.this.tfm.focus(t.getRow(), SpreadsheetView.this.getTableColumnSpan(t));
                            }
                        };
                        Platform.runLater((Runnable)r2);
                        break;
                    }
                    Runnable r2 = new Runnable(){

                        @Override
                        public void run() {
                            FocusModelListener.this.tfm.focus(t1.getRow(), (TableColumn)SpreadsheetView.this.cellsView.getColumns().get(t1.getColumn() - 1));
                        }
                    };
                    Platform.runLater((Runnable)r2);
                }
            }
        }
    }

    public static enum SpanType {
        NORMAL_CELL,
        COLUMN_SPAN_INVISIBLE,
        ROW_SPAN_INVISIBLE,
        ROW_VISIBLE,
        BOTH_INVISIBLE;

    }

    private class SpreadsheetViewSelectionModel<S>
    extends TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> {
        private boolean ctrl;
        private boolean shift;
        private boolean key;
        private boolean drag;
        private MouseEvent mouseEvent;
        private final Timeline timer;
        private final EventHandler<MouseEvent> dragDoneHandler;
        private TablePosition<ObservableList<SpreadsheetCell>, ?> old;
        private final ObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>> selectedCells;

        public SpreadsheetViewSelectionModel(SpreadsheetView spreadsheetView2) {
            super((TableView)spreadsheetView2.cellsView);
            this.ctrl = false;
            this.shift = false;
            this.key = false;
            this.drag = false;
            this.timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    GridViewSkin skin = SpreadsheetView.this.getCellsViewSkin();
                    if (SpreadsheetViewSelectionModel.this.mouseEvent != null && !SpreadsheetView.this.cellsView.contains(SpreadsheetViewSelectionModel.this.mouseEvent.getX(), SpreadsheetViewSelectionModel.this.mouseEvent.getY())) {
                        double sceneX = SpreadsheetViewSelectionModel.this.mouseEvent.getSceneX();
                        double sceneY = SpreadsheetViewSelectionModel.this.mouseEvent.getSceneY();
                        double layoutX = SpreadsheetView.this.cellsView.getLayoutX();
                        double layoutY = SpreadsheetView.this.cellsView.getLayoutY();
                        double layoutXMax = layoutX + SpreadsheetView.this.cellsView.getWidth();
                        double layoutYMax = layoutY + SpreadsheetView.this.cellsView.getHeight();
                        if (sceneX > layoutXMax) {
                            skin.getHBar().increment();
                        } else if (sceneX < layoutX) {
                            skin.getHBar().decrement();
                        }
                        if (sceneY > layoutYMax) {
                            skin.getVBar().increment();
                        } else if (sceneY < layoutY) {
                            skin.getVBar().decrement();
                        }
                    }
                }
            }, new KeyValue[0])});
            this.dragDoneHandler = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    SpreadsheetViewSelectionModel.this.drag = false;
                    SpreadsheetViewSelectionModel.this.timer.stop();
                    SpreadsheetView.this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this);
                }
            };
            this.old = null;
            final SpreadsheetGridView cellsView = spreadsheetView2.cellsView;
            cellsView.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    SpreadsheetViewSelectionModel.this.key = true;
                    SpreadsheetViewSelectionModel.this.ctrl = t.isControlDown();
                    SpreadsheetViewSelectionModel.this.shift = t.isShiftDown();
                }
            });
            cellsView.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent t) {
                    SpreadsheetViewSelectionModel.this.key = false;
                    SpreadsheetViewSelectionModel.this.ctrl = t.isControlDown();
                    SpreadsheetViewSelectionModel.this.shift = t.isShiftDown();
                }
            });
            cellsView.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    cellsView.addEventHandler(MouseEvent.MOUSE_RELEASED, SpreadsheetViewSelectionModel.this.dragDoneHandler);
                    SpreadsheetViewSelectionModel.this.drag = true;
                    SpreadsheetViewSelectionModel.this.timer.setCycleCount(-1);
                    SpreadsheetViewSelectionModel.this.timer.play();
                }
            });
            cellsView.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    SpreadsheetViewSelectionModel.this.mouseEvent = e;
                }
            });
            this.selectedCells = FXCollections.observableArrayList();
        }

        public void select(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
            if (row < 0 || row >= this.getItemCount()) {
                return;
            }
            if (this.isCellSelectionEnabled() && column == null) {
                return;
            }
            TablePosition posFinal = new TablePosition(this.getTableView(), row, column);
            SpanType spanType = SpreadsheetView.this.getSpanType(row, posFinal.getColumn());
            switch (spanType) {
                case ROW_SPAN_INVISIBLE: {
                    if (this.old != null && this.key && !this.shift && this.old.getColumn() == posFinal.getColumn() && this.old.getRow() == posFinal.getRow() - 1) {
                        posFinal = SpreadsheetView.this.getVisibleCell(SpreadsheetView.this.getTableRowSpan(this.old), this.old.getTableColumn(), this.old.getColumn());
                        break;
                    }
                    posFinal = SpreadsheetView.this.getVisibleCell(row, column, posFinal.getColumn());
                    break;
                }
                case BOTH_INVISIBLE: {
                    posFinal = SpreadsheetView.this.getVisibleCell(row, column, posFinal.getColumn());
                    break;
                }
                case COLUMN_SPAN_INVISIBLE: {
                    posFinal = this.old != null && this.key && !this.shift && this.old.getColumn() == posFinal.getColumn() - 1 && this.old.getRow() == posFinal.getRow() ? SpreadsheetView.this.getVisibleCell(this.old.getRow(), SpreadsheetView.this.getTableColumnSpan(this.old), SpreadsheetView.this.getTableColumnSpanInt(this.old)) : SpreadsheetView.this.getVisibleCell(row, column, posFinal.getColumn());
                }
            }
            if (!(!posFinal.equals(this.old) || this.ctrl || this.shift || this.drag || spanType != SpanType.ROW_SPAN_INVISIBLE && spanType != SpanType.BOTH_INVISIBLE)) {
                final TablePosition FinalPos = new TablePosition((TableView)SpreadsheetView.this.cellsView, posFinal.getRow(), posFinal.getTableColumn());
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        SpreadsheetView.this.cellsView.edit(FinalPos.getRow(), FinalPos.getTableColumn());
                    }
                };
                Platform.runLater((Runnable)r);
            }
            this.old = posFinal;
            if (!this.getSelectedCells().contains((Object)posFinal)) {
                this.getSelectedCells().add((Object)posFinal);
            }
            this.updateScroll(posFinal);
            this.addSelectedRowsAndColumns(posFinal);
            this.setSelectedIndex(posFinal.getRow());
            this.setSelectedItem((ObservableList)this.getModelItem(posFinal.getRow()));
            if (this.getTableView().getFocusModel() == null) {
                return;
            }
            this.getTableView().getFocusModel().focus(posFinal.getRow(), posFinal.getTableColumn());
        }

        private void updateScroll(TablePosition<ObservableList<SpreadsheetCell>, ?> posFinal) {
            if (!this.drag && SpreadsheetView.this.getCellsViewSkin().getCellsSize() != 0 && SpreadsheetView.this.getNonFixedRow(0).getIndex() > posFinal.getRow() && !SpreadsheetView.this.getFixedRows().contains((Object)posFinal.getRow())) {
                SpreadsheetView.this.cellsView.scrollTo(posFinal.getRow());
            }
        }

        public void clearSelection(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
            TablePosition tp = new TablePosition(this.getTableView(), row, column);
            if (this.isSelectedRange(row, column, tp.getColumn()) != null) {
                TablePosition<ObservableList<SpreadsheetCell>, ?> tp1 = this.isSelectedRange(row, column, tp.getColumn());
                this.getSelectedCells().remove(tp1);
                this.removeSelectedRowsAndColumns(tp1);
                this.focus(tp1.getRow());
            } else {
                boolean csMode = this.isCellSelectionEnabled();
                for (TablePosition pos : this.getSelectedCells()) {
                    if ((csMode || pos.getRow() != row) && (!csMode || !pos.equals((Object)tp))) continue;
                    this.getSelectedCells().remove((Object)pos);
                    this.removeSelectedRowsAndColumns(pos);
                    this.focus(row);
                    return;
                }
            }
        }

        public boolean isSelected(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column) {
            if (this.isCellSelectionEnabled() && column == null || row < 0) {
                return false;
            }
            TablePosition tp1 = new TablePosition(this.getTableView(), row, column);
            return this.isSelectedRange(row, column, tp1.getColumn()) != null;
        }

        public TablePosition<ObservableList<SpreadsheetCell>, ?> isSelectedRange(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column, int col) {
            if (this.isCellSelectionEnabled() && column == null && row >= 0) {
                return null;
            }
            SpreadsheetCell cellSpan = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.cellsView.getItems().get(row)).get(col);
            int infRow = cellSpan.getRow();
            int supRow = infRow + cellSpan.getRowSpan();
            int infCol = cellSpan.getColumn();
            int supCol = infCol + cellSpan.getColumnSpan();
            for (TablePosition tp : this.getSelectedCells()) {
                if (tp.getRow() < infRow || tp.getRow() >= supRow || tp.getColumn() < infCol || tp.getColumn() >= supCol) continue;
                return tp;
            }
            return null;
        }

        private void addSelectedRowsAndColumns(TablePosition<?, ?> t) {
            SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.cellsView.getItems().get(t.getRow())).get(t.getColumn());
            int i = cell.getRow();
            while (i < cell.getRowSpan() + cell.getRow()) {
                this.getSpreadsheetViewSkin().getSelectedRows().add((Object)i);
                int j = cell.getColumn();
                while (j < cell.getColumnSpan() + cell.getColumn()) {
                    this.getSpreadsheetViewSkin().getSelectedColumns().add((Object)j);
                    ++j;
                }
                ++i;
            }
        }

        private void removeSelectedRowsAndColumns(TablePosition<?, ?> t) {
            SpreadsheetCell cell = (SpreadsheetCell)((ObservableList)SpreadsheetView.this.cellsView.getItems().get(t.getRow())).get(t.getColumn());
            int i = cell.getRow();
            while (i < cell.getRowSpan() + cell.getRow()) {
                this.getSpreadsheetViewSkin().getSelectedRows().remove((Object)i);
                int j = cell.getColumn();
                while (j < cell.getColumnSpan() + cell.getColumn()) {
                    this.getSpreadsheetViewSkin().getSelectedColumns().remove((Object)j);
                    ++j;
                }
                ++i;
            }
        }

        public void clearAndSelect(int arg0, TableColumn<ObservableList<SpreadsheetCell>, ?> arg1) {
            this.quietClearSelection();
            this.select(arg0, arg1);
        }

        public ObservableList<TablePosition> getSelectedCells() {
            return this.selectedCells;
        }

        public void selectAboveCell() {
            TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
            if (pos.getRow() == -1) {
                this.select(this.getItemCount() - 1);
            } else if (pos.getRow() > 0) {
                this.select(pos.getRow() - 1, pos.getTableColumn());
            }
        }

        public void selectBelowCell() {
            TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
            if (pos.getRow() == -1) {
                this.select(0);
            } else if (pos.getRow() < this.getItemCount() - 1) {
                this.select(pos.getRow() + 1, pos.getTableColumn());
            }
        }

        public void selectLeftCell() {
            if (!this.isCellSelectionEnabled()) {
                return;
            }
            TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
            if (pos.getColumn() - 1 >= 0) {
                this.select(pos.getRow(), this.getTableColumn(pos.getTableColumn(), -1));
            }
        }

        public void selectRightCell() {
            if (!this.isCellSelectionEnabled()) {
                return;
            }
            TablePosition<ObservableList<SpreadsheetCell>, ?> pos = this.getFocusedCell();
            if (pos.getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
                this.select(pos.getRow(), this.getTableColumn(pos.getTableColumn(), 1));
            }
        }

        public void clearSelection() {
            this.setSelectedIndex(-1);
            this.setSelectedItem((ObservableList)this.getModelItem(-1));
            this.focus(-1);
            this.quietClearSelection();
        }

        private void quietClearSelection() {
            this.getSelectedCells().clear();
            this.getSpreadsheetViewSkin().getSelectedRows().clear();
            this.getSpreadsheetViewSkin().getSelectedColumns().clear();
        }

        private TablePosition<ObservableList<SpreadsheetCell>, ?> getFocusedCell() {
            if (this.getTableView().getFocusModel() == null) {
                return new TablePosition(this.getTableView(), -1, null);
            }
            return SpreadsheetView.this.cellsView.getFocusModel().getFocusedCell();
        }

        private TableColumn<ObservableList<SpreadsheetCell>, ?> getTableColumn(TableColumn<ObservableList<SpreadsheetCell>, ?> column, int offset) {
            int columnIndex = this.getTableView().getVisibleLeafIndex(column);
            int newColumnIndex = columnIndex + offset;
            return this.getTableView().getVisibleLeafColumn(newColumnIndex);
        }

        private GridViewSkin getSpreadsheetViewSkin() {
            return SpreadsheetView.this.getCellsViewSkin();
        }
    }
}

