/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javafx.util.Callback;
import org.controlsfx.control.ButtonBar;
import org.controlsfx.control.action.AbstractAction;
import org.controlsfx.control.action.Action;
import org.controlsfx.dialog.AbstractDialogAction;
import org.controlsfx.dialog.Dialog;
import org.controlsfx.dialog.DialogResources;
import org.controlsfx.dialog.ExceptionDialog;

public final class Dialogs {
    public static final String USE_DEFAULT = "$$$";
    private Object owner;
    private String title;
    private String message;
    private String masthead;
    private boolean lightweight;
    private boolean nativeTitleBar;
    private Set<Action> actions = new HashSet<Action>();

    public static Dialogs create() {
        return new Dialogs();
    }

    private Dialogs() {
    }

    public Dialogs owner(Object owner) {
        this.owner = owner;
        return this;
    }

    public Dialogs title(String title) {
        this.title = title;
        return this;
    }

    public Dialogs message(String message) {
        this.message = message;
        return this;
    }

    public Dialogs masthead(String masthead) {
        this.masthead = masthead;
        return this;
    }

    public Dialogs actions(Collection<? extends Action> actions) {
        this.actions.clear();
        this.actions.addAll(actions);
        return this;
    }

    public Dialogs actions(Action ... actions) {
        return this.actions(Arrays.asList(actions));
    }

    public Dialogs lightweight() {
        this.lightweight = true;
        return this;
    }

    public Dialogs nativeTitleBar() {
        this.nativeTitleBar = true;
        return this;
    }

    public void showInformation() {
        this.showSimpleContentDialog(Type.INFORMATION);
    }

    public Action showConfirm() {
        return this.showSimpleContentDialog(Type.CONFIRMATION);
    }

    public Action showWarning() {
        return this.showSimpleContentDialog(Type.WARNING);
    }

    public Action showError() {
        return this.showSimpleContentDialog(Type.ERROR);
    }

    public Action showException(Throwable exception) {
        Dialog dlg = this.buildDialog(Type.ERROR);
        dlg.setContent(exception.getMessage());
        dlg.setExpandableContent(this.buildExceptionDetails(exception));
        return dlg.show();
    }

    public Action showExceptionInNewWindow(final Throwable exception) {
        Dialog dlg = this.buildDialog(Type.ERROR);
        dlg.setContent(exception.getMessage());
        AbstractAction openExceptionAction = new AbstractAction("Open Exception"){

            @Override
            public void execute(ActionEvent ae) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                String moreDetails = sw.toString();
                new ExceptionDialog((Window)Dialogs.this.owner, moreDetails, Dialogs.this.nativeTitleBar).show();
            }
        };
        ButtonBar.setType(openExceptionAction, ButtonBar.ButtonType.HELP_2);
        dlg.getActions().add((Object)openExceptionAction);
        return dlg.show();
    }

    public String showTextInput(String defaultValue) {
        Dialog dlg = this.buildDialog(Type.INPUT);
        TextField textField = new TextField(defaultValue);
        dlg.setContent(this.buildInputContent((Control)textField));
        return dlg.show() == Dialog.Actions.OK ? textField.getText() : null;
    }

    public String showTextInput() {
        return this.showTextInput("");
    }

    public <T> T showChoices(T defaultChoice, Collection<T> choices) {
        Dialog dlg = this.buildDialog(Type.INPUT);
        final Object[] response = new Object[1];
        ChangeListener changeListener = new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> ov, T t, T t1) {
                response[0] = t1;
            }
        };
        double MIN_WIDTH = 150.0;
        if (choices.size() > 10) {
            ComboBox comboBox = new ComboBox();
            comboBox.setMinWidth(150.0);
            comboBox.getItems().addAll(choices);
            comboBox.getSelectionModel().select(defaultChoice);
            comboBox.getSelectionModel().selectedItemProperty().addListener(changeListener);
            dlg.setContent(this.buildInputContent((Control)comboBox));
        } else {
            ChoiceBox choiceBox = new ChoiceBox();
            choiceBox.setMinWidth(150.0);
            choiceBox.getItems().addAll(choices);
            choiceBox.getSelectionModel().select(defaultChoice);
            choiceBox.getSelectionModel().selectedItemProperty().addListener(changeListener);
            dlg.setContent(this.buildInputContent((Control)choiceBox));
        }
        return (T)(dlg.show() == Dialog.Actions.OK ? response[0] : null);
    }

    public <T> T showChoices(Collection<T> choices) {
        return this.showChoices((T)null, choices);
    }

    public <T> T showChoices(T ... choices) {
        return this.showChoices((Collection<T>)Arrays.asList(choices));
    }

    public Action showCommandLinks(CommandLink defaultCommandLink, List<CommandLink> links) {
        final Dialog dlg = this.buildDialog(Type.INFORMATION);
        dlg.setContent(this.message);
        Node messageNode = dlg.getContent();
        messageNode.getStyleClass().add((Object)"command-link-message");
        int gapSize = 10;
        final ArrayList<Button> buttons = new ArrayList<Button>(links.size());
        GridPane content = new GridPane(){

            protected double computePrefWidth(double height) {
                double pw = 0.0;
                int i = 0;
                while (i < buttons.size()) {
                    Button btn = (Button)buttons.get(i);
                    pw = Math.min(pw, btn.prefWidth(-1.0));
                    ++i;
                }
                return pw + 10.0;
            }

            protected double computePrefHeight(double width) {
                double ph = Dialogs.this.masthead == null || Dialogs.this.masthead.isEmpty() ? 0 : 10;
                int i = 0;
                while (i < buttons.size()) {
                    Button btn = (Button)buttons.get(i);
                    ph += btn.prefHeight(width) + 10.0;
                    ++i;
                }
                return ph * 1.5;
            }
        };
        content.setHgap(10.0);
        content.setVgap(10.0);
        int row = 0;
        Node message = dlg.getContent();
        if (message != null) {
            content.add(message, 0, row++);
        }
        for (final CommandLink commandLink : links) {
            if (commandLink == null) continue;
            Button button = this.buildCommandLinkButton(commandLink);
            button.setDefaultButton(commandLink == defaultCommandLink);
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent ae) {
                    commandLink.execute(new ActionEvent((Object)dlg, ae.getTarget()));
                }
            });
            GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
            content.add((Node)button, 0, row++);
            buttons.add(button);
        }
        GridPane.setMargin((Node)((Node)buttons.get(buttons.size() - 1)), (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        dlg.setContent((Node)content);
        dlg.getActions().clear();
        return dlg.show();
    }

    public Action showCommandLinks(List<CommandLink> links) {
        return this.showCommandLinks(null, links);
    }

    public Action showCommandLinks(CommandLink defaultCommandLink, CommandLink ... links) {
        return this.showCommandLinks(defaultCommandLink, Arrays.asList(links));
    }

    public Font showFontSelector(Font font) {
        FontPanel fontPanel = new FontPanel();
        fontPanel.setFont(font);
        this.title(USE_DEFAULT);
        Dialog dlg = this.buildDialog(Type.FONT);
        dlg.setIconifiable(false);
        dlg.setContent((Node)fontPanel);
        return Dialog.Actions.OK == dlg.show() ? fontPanel.getFont() : null;
    }

    public void showWorkerProgress(Worker<?> worker) {
        Dialog dlg = this.buildDialog(Type.PROGRESS);
        dlg.setClosable(false);
        Label label = new Label();
        label.textProperty().bind((ObservableValue)worker.messageProperty());
        WorkerProgressPane content = new WorkerProgressPane(dlg);
        content.setMaxWidth(Double.MAX_VALUE);
        VBox vbox = new VBox(10.0, new Node[]{label, content});
        vbox.setMaxWidth(Double.MAX_VALUE);
        vbox.setPrefSize(300.0, 100.0);
        dlg.setContent((Node)vbox);
        content.setWorker(worker);
    }

    private Dialog buildDialog(Type dlgType) {
        String actualTitle;
        String string = this.title == null ? null : (actualTitle = USE_DEFAULT.equals(this.title) ? dlgType.getDefaultTitle() : this.title);
        String actualMasthead = this.masthead == null ? null : (USE_DEFAULT.equals(this.masthead) ? dlgType.getDefaultMasthead() : this.masthead);
        Dialog dlg = new Dialog(this.owner, actualTitle, this.lightweight, this.nativeTitleBar);
        dlg.setResizable(false);
        dlg.setIconifiable(false);
        Image image = dlgType.getImage();
        if (image != null) {
            dlg.setGraphic((Node)new ImageView(image));
        }
        dlg.setMasthead(actualMasthead);
        dlg.getActions().addAll(dlgType.getActions());
        return dlg;
    }

    private Action showSimpleContentDialog(Type dlgType) {
        Dialog dlg = this.buildDialog(dlgType);
        if (!this.actions.isEmpty()) {
            dlg.getActions().clear();
            dlg.getActions().addAll(this.actions);
        }
        dlg.setContent(this.message);
        return dlg.show();
    }

    private Node buildInputContent(final Control inputControl) {
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setMaxWidth(Double.MAX_VALUE);
        if (this.message != null && !this.message.isEmpty()) {
            Label label = new Label(this.message);
            GridPane.setHgrow((Node)label, (Priority)Priority.NEVER);
            grid.add((Node)label, 0, 0);
        }
        if (inputControl != null) {
            inputControl.setMaxWidth(Double.MAX_VALUE);
            GridPane.setHgrow((Node)inputControl, (Priority)Priority.ALWAYS);
            grid.add((Node)inputControl, 1, 0);
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                inputControl.requestFocus();
            }
        });
        return grid;
    }

    private Node buildExceptionDetails(Throwable exception) {
        Label label = new Label(DialogResources.getString("exception.dialog.label"));
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        TextArea textArea = new TextArea(sw.toString());
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane root = new GridPane();
        root.setMaxWidth(Double.MAX_VALUE);
        root.add((Node)label, 0, 0);
        root.add((Node)textArea, 0, 1);
        return root;
    }

    private Button buildCommandLinkButton(CommandLink commandLink) {
        Button button = new Button();
        button.getStyleClass().addAll((Object[])new String[]{"command-link-button"});
        button.setMaxHeight(Double.MAX_VALUE);
        button.setMaxWidth(Double.MAX_VALUE);
        button.setAlignment(Pos.CENTER_LEFT);
        final Label titleLabel = new Label(commandLink.getText());
        titleLabel.minWidthProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{label.prefWidthProperty()});
            }

            protected double computeValue() {
                return titleLabel.getPrefWidth() + 400.0;
            }
        });
        titleLabel.getStyleClass().addAll((Object[])new String[]{"line-1"});
        titleLabel.setWrapText(true);
        titleLabel.setAlignment(Pos.TOP_LEFT);
        GridPane.setVgrow((Node)titleLabel, (Priority)Priority.NEVER);
        Label messageLabel = new Label(commandLink.getLongText());
        messageLabel.getStyleClass().addAll((Object[])new String[]{"line-2"});
        messageLabel.setWrapText(true);
        messageLabel.setAlignment(Pos.TOP_LEFT);
        messageLabel.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)messageLabel, (Priority)Priority.SOMETIMES);
        Node graphic = commandLink.getGraphic();
        Node view = graphic == null ? new ImageView(DialogResources.getImage("command.link.icon")) : graphic;
        Pane graphicContainer = new Pane(new Node[]{view});
        graphicContainer.getStyleClass().add((Object)"graphic-container");
        GridPane.setValignment((Node)graphicContainer, (VPos)VPos.TOP);
        GridPane.setMargin((Node)graphicContainer, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        GridPane grid = new GridPane();
        grid.minWidthProperty().bind((ObservableValue)titleLabel.prefWidthProperty());
        grid.setMaxHeight(Double.MAX_VALUE);
        grid.setMaxWidth(Double.MAX_VALUE);
        grid.getStyleClass().add((Object)"container");
        grid.add((Node)graphicContainer, 0, 0, 1, 2);
        grid.add((Node)titleLabel, 1, 0);
        grid.add((Node)messageLabel, 1, 1);
        button.setGraphic((Node)grid);
        button.minWidthProperty().bind((ObservableValue)titleLabel.prefWidthProperty());
        return button;
    }

    public static class CommandLink
    extends AbstractDialogAction {
        public CommandLink(Node graphic, String text, String longText) {
            super(text);
            this.setLongText(longText);
            this.setGraphic(graphic);
        }

        public CommandLink(String message, String comment) {
            this(null, message, comment);
        }

        @Override
        public final void execute(ActionEvent ae) {
            Dialog dlg = (Dialog)ae.getSource();
            dlg.setResult(this);
        }

        public String toString() {
            return "CommandLink [text=" + this.getText() + ", longText=" + this.getLongText() + "]";
        }
    }

    private static class FontPanel
    extends GridPane {
        private static final double HGAP = 10.0;
        private static final double VGAP = 5.0;
        private static final Predicate<Object> MATCH_ALL = new Predicate<Object>(){

            @Override
            public boolean test(Object t) {
                return true;
            }
        };
        private static final Double[] fontSizes = new Double[]{8.0, 9.0, 11.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 36.0, 48.0, 72.0};
        private final FilteredList<String> filteredFontList = new FilteredList(FXCollections.observableArrayList((Collection)Font.getFamilies()), MATCH_ALL);
        private final FilteredList<FontStyle> filteredStyleList = new FilteredList(FXCollections.observableArrayList(), MATCH_ALL);
        private final FilteredList<Double> filteredSizeList = new FilteredList(FXCollections.observableArrayList((Object[])fontSizes), MATCH_ALL);
        private final ListView<String> fontListView = new ListView(this.filteredFontList);
        private final ListView<FontStyle> styleListView = new ListView(this.filteredStyleList);
        private final ListView<Double> sizeListView = new ListView(this.filteredSizeList);
        private final Text sample = new Text("Sample");

        private static List<FontStyle> getFontStyles(String fontFamily) {
            HashSet<FontStyle> set = new HashSet<FontStyle>();
            for (String f : Font.getFontNames((String)fontFamily)) {
                set.add(new FontStyle(f.replace(fontFamily, "")));
            }
            ArrayList<FontStyle> result = new ArrayList<FontStyle>(set);
            Collections.sort(result);
            return result;
        }

        public FontPanel() {
            this.setHgap(10.0);
            this.setVgap(5.0);
            this.setPrefSize(500.0, 300.0);
            this.setMinSize(500.0, 300.0);
            ColumnConstraints c0 = new ColumnConstraints();
            c0.setPercentWidth(60.0);
            ColumnConstraints c1 = new ColumnConstraints();
            c1.setPercentWidth(25.0);
            ColumnConstraints c2 = new ColumnConstraints();
            c2.setPercentWidth(15.0);
            this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{c0, c1, c2});
            RowConstraints r0 = new RowConstraints();
            r0.setVgrow(Priority.NEVER);
            RowConstraints r1 = new RowConstraints();
            r1.setVgrow(Priority.NEVER);
            RowConstraints r2 = new RowConstraints();
            r2.setFillHeight(true);
            r2.setVgrow(Priority.NEVER);
            RowConstraints r3 = new RowConstraints();
            r3.setPrefHeight(250.0);
            r3.setVgrow(Priority.NEVER);
            this.getRowConstraints().addAll((Object[])new RowConstraints[]{r0, r1, r2, r3});
            this.add((Node)new Label("Font"), 0, 0);
            this.add((Node)this.fontListView, 0, 1);
            this.fontListView.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> listview) {
                    return new ListCell<String>(){

                        protected void updateItem(String family, boolean empty) {
                            super.updateItem((Object)family, empty);
                            if (!empty) {
                                this.setFont(Font.font((String)family));
                                this.setText(family);
                            } else {
                                this.setText(null);
                            }
                        }
                    };
                }
            });
            ChangeListener<Object> sampleRefreshListener = new ChangeListener<Object>(){

                public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
                    FontPanel.this.refreshSample();
                }
            };
            ((MultipleSelectionModel)this.fontListView.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                    String fontFamily = (String)FontPanel.this.listSelection(FontPanel.this.fontListView);
                    FontPanel.this.styleListView.setItems(FXCollections.observableArrayList((Collection)FontPanel.getFontStyles(fontFamily)));
                    FontPanel.this.refreshSample();
                }
            });
            this.add((Node)new Label("Style"), 1, 0);
            this.add((Node)this.styleListView, 1, 1);
            ((MultipleSelectionModel)this.styleListView.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)sampleRefreshListener);
            this.add((Node)new Label("Size"), 2, 0);
            this.add((Node)this.sizeListView, 2, 1);
            ((MultipleSelectionModel)this.sizeListView.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)sampleRefreshListener);
            double height = 45.0;
            DoubleBinding sampleWidth = new DoubleBinding(){
                {
                    this.bind(new Observable[]{FontPanel.this.fontListView.widthProperty(), FontPanel.this.styleListView.widthProperty(), FontPanel.this.sizeListView.widthProperty()});
                }

                protected double computeValue() {
                    return FontPanel.this.fontListView.getWidth() + FontPanel.this.styleListView.getWidth() + FontPanel.this.sizeListView.getWidth() + 30.0;
                }
            };
            StackPane sampleStack = new StackPane(new Node[]{this.sample});
            sampleStack.setAlignment(Pos.CENTER_LEFT);
            sampleStack.setMinHeight(45.0);
            sampleStack.setPrefHeight(45.0);
            sampleStack.setMaxHeight(45.0);
            sampleStack.prefWidthProperty().bind((ObservableValue)sampleWidth);
            Rectangle clip = new Rectangle(0.0, 45.0);
            clip.widthProperty().bind((ObservableValue)sampleWidth);
            sampleStack.setClip((Node)clip);
            this.add((Node)sampleStack, 0, 3, 1, 3);
        }

        public void setFont(Font font) {
            Font _font;
            Font font2 = _font = font == null ? Font.getDefault() : font;
            if (_font != null) {
                this.selectInList(this.fontListView, _font.getFamily());
                this.selectInList(this.styleListView, new FontStyle(_font));
                this.selectInList(this.sizeListView, _font.getSize());
            }
        }

        public Font getFont() {
            try {
                FontStyle style = this.listSelection(this.styleListView);
                if (style == null) {
                    return Font.font((String)this.listSelection(this.fontListView), (double)this.listSelection(this.sizeListView));
                }
                return Font.font((String)this.listSelection(this.fontListView), (FontWeight)style.getWeight(), (FontPosture)style.getPosture(), (double)this.listSelection(this.sizeListView));
            }
            catch (Throwable ex) {
                return null;
            }
        }

        private void refreshSample() {
            System.out.println(this.getFont());
            this.sample.setFont(this.getFont());
        }

        private <T> void selectInList(final ListView<T> listView, final T selection) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    listView.scrollTo(selection);
                    listView.getSelectionModel().select(selection);
                }
            });
        }

        private <T> T listSelection(ListView<T> listView) {
            return (T)((MultipleSelectionModel)listView.selectionModelProperty().get()).getSelectedItem();
        }
    }

    private static class FontStyle
    implements Comparable<FontStyle> {
        private FontPosture posture;
        private FontWeight weight;

        public FontStyle(FontWeight weight, FontPosture posture) {
            this.posture = posture == null ? FontPosture.REGULAR : posture;
            this.weight = weight;
        }

        public FontStyle() {
            this(null, null);
        }

        public FontStyle(String styles) {
            this();
            String[] fontStyles;
            String[] stringArray = fontStyles = (styles == null ? "" : styles.trim().toUpperCase()).split(" ");
            int n = fontStyles.length;
            int n2 = 0;
            while (n2 < n) {
                String style = stringArray[n2];
                FontWeight w = FontWeight.findByName((String)style);
                if (w != null) {
                    this.weight = w;
                } else {
                    FontPosture p = FontPosture.findByName((String)style);
                    if (p != null) {
                        this.posture = p;
                    }
                }
                ++n2;
            }
        }

        public FontStyle(Font font) {
            this(font.getStyle());
        }

        public FontPosture getPosture() {
            return this.posture;
        }

        public FontWeight getWeight() {
            return this.weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.posture == null ? 0 : this.posture.hashCode());
            result = 31 * result + (this.weight == null ? 0 : this.weight.hashCode());
            return result;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            FontStyle other = (FontStyle)that;
            if (this.posture != other.posture) {
                return false;
            }
            return this.weight == other.weight;
        }

        private static String makePretty(Object o) {
            String s;
            String string = s = o == null ? "" : o.toString();
            if (!s.isEmpty()) {
                s = s.replace("_", " ");
                s = String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1).toLowerCase();
            }
            return s;
        }

        public String toString() {
            return String.format("%s %s", FontStyle.makePretty(this.weight), FontStyle.makePretty(this.posture)).trim();
        }

        private <T extends Enum<T>> int compareEnums(T e1, T e2) {
            if (e1 == e2) {
                return 0;
            }
            if (e1 == null) {
                return -1;
            }
            if (e2 == null) {
                return 1;
            }
            return e1.compareTo(e2);
        }

        @Override
        public int compareTo(FontStyle fs) {
            int result = this.compareEnums(this.weight, fs.weight);
            return result != 0 ? result : this.compareEnums(this.posture, fs.posture);
        }
    }

    private static enum Type {
        ERROR("error.image", "Error", "Error", Dialog.Actions.OK),
        INFORMATION("info.image", "Message", "Message", Dialog.Actions.OK),
        WARNING("warning.image", "Warning", "Warning", Dialog.Actions.OK),
        CONFIRMATION("confirm.image", "Select an option", "Select an option", Dialog.Actions.YES, Dialog.Actions.NO, Dialog.Actions.CANCEL),
        INPUT("confirm.image", "Select an option", "Select an option", Dialog.Actions.OK, Dialog.Actions.CANCEL),
        FONT(null, "Select Font", "Select Font", Dialog.Actions.OK, Dialog.Actions.CANCEL),
        PROGRESS("info.image", "Progress", "Progress", new Action[0]);

        private final String defaultTitle;
        private final String defaultMasthead;
        private final Collection<Action> actions;
        private final String imageResource;
        private Image image;

        private Type(String imageResource, String defaultTitle, String defaultMasthead, Action ... actions) {
            this.actions = Arrays.asList(actions);
            this.imageResource = imageResource;
            this.defaultTitle = defaultTitle;
            this.defaultMasthead = defaultMasthead;
        }

        public Image getImage() {
            if (this.image == null && this.imageResource != null) {
                this.image = DialogResources.getImage(this.imageResource);
            }
            return this.image;
        }

        public String getDefaultMasthead() {
            return this.defaultMasthead;
        }

        public String getDefaultTitle() {
            return this.defaultTitle;
        }

        public Collection<Action> getActions() {
            return this.actions;
        }
    }

    private static class WorkerProgressPane
    extends Region {
        private Worker<?> worker;
        private boolean dialogVisible = false;
        private boolean cancelDialogShow = false;
        private ChangeListener<Worker.State> stateListener = new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State old, Worker.State value) {
                switch (value) {
                    case SUCCEEDED: 
                    case CANCELLED: 
                    case FAILED: {
                        if (!WorkerProgressPane.this.dialogVisible) {
                            WorkerProgressPane.this.cancelDialogShow = true;
                            break;
                        }
                        if (old != Worker.State.SCHEDULED && old != Worker.State.RUNNING) break;
                        WorkerProgressPane.this.end();
                        break;
                    }
                    case SCHEDULED: {
                        WorkerProgressPane.this.begin();
                    }
                }
            }
        };
        private final Dialog dialog;
        private final ProgressBar progressBar;

        public final void setWorker(Worker<?> newWorker) {
            if (newWorker != this.worker) {
                if (this.worker != null) {
                    this.worker.stateProperty().removeListener(this.stateListener);
                    this.end();
                }
                this.worker = newWorker;
                if (newWorker != null) {
                    newWorker.stateProperty().addListener(this.stateListener);
                    if (newWorker.getState() == Worker.State.RUNNING || newWorker.getState() == Worker.State.SCHEDULED) {
                        this.begin();
                    }
                }
            }
        }

        public WorkerProgressPane(Dialog dialog) {
            this.dialog = dialog;
            this.progressBar = new ProgressBar();
            this.progressBar.setMaxWidth(Double.MAX_VALUE);
            this.getChildren().add((Object)this.progressBar);
            if (this.worker != null) {
                this.progressBar.progressProperty().bind((ObservableValue)this.worker.progressProperty());
            }
        }

        private void begin() {
            this.cancelDialogShow = false;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!WorkerProgressPane.this.cancelDialogShow) {
                        WorkerProgressPane.this.progressBar.progressProperty().bind((ObservableValue)WorkerProgressPane.this.worker.progressProperty());
                        WorkerProgressPane.this.dialogVisible = true;
                        WorkerProgressPane.this.dialog.show();
                    }
                }
            });
        }

        private void end() {
            this.progressBar.progressProperty().unbind();
            this.dialogVisible = false;
            this.dialog.hide();
        }

        protected void layoutChildren() {
            if (this.progressBar != null) {
                Insets insets = this.getInsets();
                double w = this.getWidth() - insets.getLeft() - insets.getRight();
                double h = this.getHeight() - insets.getTop() - insets.getBottom();
                double prefH = this.progressBar.prefHeight(-1.0);
                double x = insets.getLeft() + (w - w) / 2.0;
                double y = insets.getTop() + (h - prefH) / 2.0;
                this.progressBar.resizeRelocate(x, y, w, prefH);
            }
        }
    }
}

