/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import com.sun.javafx.Utils;
import com.sun.javafx.tk.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.dialog.FXDialog;

class LightweightDialog
extends FXDialog {
    private Scene scene;
    private Parent owner;
    private Region opaqueLayer;
    private Pane dialogStack;
    private Parent originalParent;
    private BooleanProperty focused;
    private StringProperty title;
    private BooleanProperty resizable;
    private Effect effect;
    private Effect tempEffect;
    private boolean modal = true;

    LightweightDialog(String title, Object incomingOwner) {
        Object _owner = incomingOwner;
        if (_owner == null) {
            Iterator windows = Window.impl_getWindows();
            Window window = null;
            while (windows.hasNext()) {
                window = (Window)windows.next();
                if (window.isFocused()) break;
            }
            _owner = window;
        }
        if (_owner instanceof Scene) {
            this.scene = (Scene)_owner;
        } else if (_owner instanceof Stage) {
            this.scene = ((Stage)_owner).getScene();
        } else if (_owner instanceof Tab) {
            this.owner = (Parent)((Tab)_owner).getContent();
        } else if (_owner instanceof Node) {
            this.owner = this.getFirstParent((Node)_owner);
        } else {
            throw new IllegalArgumentException("Unknown owner: " + _owner.getClass());
        }
        if (this.scene == null && this.owner != null) {
            this.scene = this.owner.getScene();
        }
        this.init(title, true);
        this.lightweightDialog.getStyleClass().addAll((Object[])new String[]{"lightweight", "custom-chrome"});
        this.toolBar.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                LightweightDialog.this.mouseDragDeltaX = LightweightDialog.this.lightweightDialog.getLayoutX() - event.getSceneX();
                LightweightDialog.this.mouseDragDeltaY = LightweightDialog.this.lightweightDialog.getLayoutY() - event.getSceneY();
            }
        });
        this.toolBar.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double w = LightweightDialog.this.lightweightDialog.getWidth();
                double h = LightweightDialog.this.lightweightDialog.getHeight();
                double DROP_SHADOW_SIZE = (LightweightDialog.this.lightweightDialog.getBoundsInParent().getWidth() - LightweightDialog.this.lightweightDialog.getLayoutBounds().getWidth()) / 2.0;
                Insets padding = LightweightDialog.this.lightweightDialog.getPadding();
                double rightPadding = padding.getRight();
                double bottomPadding = padding.getBottom();
                double minX = 0.0;
                double maxX = LightweightDialog.this.owner == null ? LightweightDialog.this.scene.getWidth() : LightweightDialog.this.owner.getLayoutBounds().getWidth();
                double newX = event.getSceneX() + LightweightDialog.this.mouseDragDeltaX;
                newX = Utils.clamp((double)minX, (double)newX, (double)(maxX - w + DROP_SHADOW_SIZE + rightPadding + minX));
                double minY = 0.0;
                double maxY = LightweightDialog.this.owner == null ? LightweightDialog.this.scene.getHeight() : LightweightDialog.this.owner.getLayoutBounds().getHeight();
                double newY = event.getSceneY() + LightweightDialog.this.mouseDragDeltaY;
                newY = Utils.clamp((double)0.0, (double)newY, (double)(maxY - h + DROP_SHADOW_SIZE + bottomPadding + minY));
                LightweightDialog.this.lightweightDialog.setLayoutX(newX);
                LightweightDialog.this.lightweightDialog.setLayoutY(newY);
            }
        });
        this.minButton = null;
        this.maxButton = null;
        this.windowBtns.getChildren().setAll((Object[])new Node[]{this.closeButton});
        EventHandler<MouseEvent> resizeHandler = new EventHandler<MouseEvent>(){
            private double width;
            private double height;
            private Point2D dragAnchor;

            public void handle(MouseEvent event) {
                EventType type = event.getEventType();
                if (type == MouseEvent.MOUSE_PRESSED) {
                    this.width = LightweightDialog.this.lightweightDialog.getWidth();
                    this.height = LightweightDialog.this.lightweightDialog.getHeight();
                    this.dragAnchor = new Point2D(event.getSceneX(), event.getSceneY());
                } else if (type == MouseEvent.MOUSE_DRAGGED) {
                    LightweightDialog.this.lightweightDialog.setPrefWidth(Math.max(LightweightDialog.this.lightweightDialog.minWidth(-1.0), this.width + (event.getSceneX() - this.dragAnchor.getX())));
                    LightweightDialog.this.lightweightDialog.setPrefHeight(Math.max(LightweightDialog.this.lightweightDialog.minHeight(-1.0), this.height + (event.getSceneY() - this.dragAnchor.getY())));
                }
            }
        };
        this.resizeCorner.setOnMousePressed((EventHandler)resizeHandler);
        this.resizeCorner.setOnMouseDragged((EventHandler)resizeHandler);
        this.lightweightDialog.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.lightweightDialog.pseudoClassStateChanged(ACTIVE_PSEUDO_CLASS, true);
    }

    @Override
    public void setModal(boolean modal) {
        this.modal = modal;
    }

    @Override
    public boolean isModal() {
        return this.modal;
    }

    public void setEffect(Effect e) {
        this.effect = e;
    }

    @Override
    public StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty((Object)this, "title");
        }
        return this.title;
    }

    @Override
    public void show() {
        if (this.owner != null) {
            this.showInParent();
        } else if (this.scene != null) {
            this.showInScene();
        }
        if (this.isModal()) {
            Parent lock = this.owner != null ? this.owner : this.scene;
            Toolkit.getToolkit().enterNestedEventLoop((Object)lock);
        }
    }

    @Override
    public void hide() {
        if (this.owner != null) {
            this.hideInParent();
        } else if (this.scene != null) {
            this.hideInScene();
        }
        if (this.isModal()) {
            Parent lock = this.owner != null ? this.owner : this.scene;
            Toolkit.getToolkit().exitNestedEventLoop((Object)lock, null);
        }
    }

    @Override
    BooleanProperty resizableProperty() {
        if (this.resizable == null) {
            this.resizable = new SimpleBooleanProperty((Object)this, "resizable", false);
        }
        return this.resizable;
    }

    @Override
    public Node getRoot() {
        return this.lightweightDialog;
    }

    @Override
    ReadOnlyDoubleProperty widthProperty() {
        return this.lightweightDialog.widthProperty();
    }

    @Override
    ReadOnlyDoubleProperty heightProperty() {
        return this.lightweightDialog.heightProperty();
    }

    BooleanProperty focusedProperty() {
        if (this.focused == null) {
            this.focused = new SimpleBooleanProperty((Object)this, "focused", true);
        }
        return this.focused;
    }

    @Override
    public void setContentPane(Pane pane) {
        this.root.setCenter((Node)pane);
    }

    @Override
    public void sizeToScene() {
    }

    @Override
    void setIconified(boolean iconified) {
    }

    @Override
    boolean isIconified() {
        return false;
    }

    @Override
    public void setIconifiable(boolean iconifiable) {
    }

    @Override
    public void setClosable(boolean closable) {
        this.closeButton.setVisible(closable);
    }

    private void hideInScene() {
        if (this.opaqueLayer != null) {
            this.opaqueLayer.setVisible(false);
        }
        this.originalParent.setEffect(this.tempEffect);
        this.lightweightDialog.setVisible(false);
        this.dialogStack.getChildren().remove((Object)this.originalParent);
        this.originalParent.getStyleClass().remove((Object)"root");
        this.scene.setRoot(this.originalParent);
    }

    private void hideInParent() {
        if (this.opaqueLayer != null) {
            this.opaqueLayer.setVisible(false);
        }
        if (this.originalParent != null) {
            this.originalParent.setEffect(this.tempEffect);
        }
        this.lightweightDialog.setVisible(false);
        this.getChildren(this.owner.getParent()).setAll((Object[])new Node[]{this.owner});
        this.dialogStack = null;
    }

    private void showInScene() {
        this.installCSSInScene();
        this.originalParent = this.scene.getRoot();
        this.buildDialogStack((Node)this.originalParent);
        this.lightweightDialog.setVisible(true);
        this.scene.setRoot((Parent)this.dialogStack);
    }

    private void showInParent() {
        this.installCSSInScene();
        ObservableList<Node> ownerParentChildren = this.getChildren(this.owner.getParent());
        int ownerPos = ownerParentChildren.indexOf((Object)this.owner);
        ownerParentChildren.remove(ownerPos);
        this.buildDialogStack((Node)this.owner);
        ownerParentChildren.add(ownerPos, (Object)this.dialogStack);
        this.lightweightDialog.setVisible(true);
    }

    private void installCSSInScene() {
        Scene _scene;
        if (this.scene != null) {
            this.scene.getStylesheets().addAll((Object[])new String[]{DIALOGS_CSS_URL.toExternalForm()});
        } else if (this.owner != null && (_scene = this.owner.getScene()) != null) {
            _scene.getStylesheets().addAll((Object[])new String[]{DIALOGS_CSS_URL.toExternalForm()});
        }
    }

    private void buildDialogStack(final Node parent) {
        this.dialogStack = new Pane(new Node[]{this.lightweightDialog}){
            private boolean isFirstRun;
            {
                super($anonymous0);
                this.isFirstRun = true;
            }

            protected void layoutChildren() {
                double w = LightweightDialog.this.getOverlayWidth();
                double h = LightweightDialog.this.getOverlayHeight();
                double x = LightweightDialog.this.getOverlayX();
                double y = LightweightDialog.this.getOverlayY();
                if (parent != null) {
                    parent.resizeRelocate(x, y, w, h);
                }
                if (LightweightDialog.this.opaqueLayer != null) {
                    LightweightDialog.this.opaqueLayer.resizeRelocate(x, y, w, h);
                }
                double dialogWidth = LightweightDialog.this.lightweightDialog.prefWidth(-1.0);
                double dialogHeight = LightweightDialog.this.lightweightDialog.prefHeight(-1.0);
                LightweightDialog.this.lightweightDialog.resize(this.snapSize(dialogWidth), this.snapSize(dialogHeight));
                if (this.isFirstRun) {
                    this.isFirstRun = false;
                    double dialogX = LightweightDialog.this.lightweightDialog.getLayoutX();
                    dialogX = dialogX == 0.0 ? w / 2.0 - dialogWidth / 2.0 : dialogX;
                    double dialogY = LightweightDialog.this.lightweightDialog.getLayoutY();
                    dialogY = dialogY == 0.0 ? h / 2.0 - dialogHeight / 2.0 : dialogY;
                    LightweightDialog.this.lightweightDialog.relocate(this.snapPosition(dialogX), this.snapPosition(dialogY));
                }
            }
        };
        this.dialogStack.setManaged(true);
        if (parent != null) {
            this.dialogStack.getChildren().add(0, (Object)parent);
            this.dialogStack.getProperties().putAll((Map)parent.getProperties());
        }
        if (this.effect == null) {
            this.opaqueLayer = new Region();
            this.opaqueLayer.getStyleClass().add((Object)"lightweight-dialog-background");
            this.dialogStack.getChildren().add(parent == null ? 0 : 1, (Object)this.opaqueLayer);
        } else if (parent != null) {
            this.tempEffect = parent.getEffect();
            parent.setEffect(this.effect);
        }
    }

    private double getOverlayWidth() {
        if (this.owner != null) {
            return this.owner.getLayoutBounds().getWidth();
        }
        if (this.scene != null) {
            return this.scene.getWidth();
        }
        return 0.0;
    }

    private double getOverlayHeight() {
        if (this.owner != null) {
            return this.owner.getLayoutBounds().getHeight();
        }
        if (this.scene != null) {
            return this.scene.getHeight();
        }
        return 0.0;
    }

    private double getOverlayX() {
        return 0.0;
    }

    private double getOverlayY() {
        return 0.0;
    }

    private Parent getFirstParent(Node n) {
        if (n == null) {
            return null;
        }
        return n instanceof Parent ? (Parent)n : this.getFirstParent((Node)n.getParent());
    }

    private ObservableList<Node> getChildren(Parent p) {
        ObservableList children = null;
        try {
            Method getChildrenMethod = Parent.class.getDeclaredMethod("getChildren", new Class[0]);
            if (getChildrenMethod != null) {
                if (!getChildrenMethod.isAccessible()) {
                    getChildrenMethod.setAccessible(true);
                }
                children = (ObservableList)getChildrenMethod.invoke((Object)p, new Object[0]);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return children;
    }
}

