/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.glyphfont;

import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import org.controlsfx.tools.Duplicatable;

public class Glyph
extends Label
implements Duplicatable<Glyph> {
    private final String fontFamily;
    private final Character character;
    private double size;
    private Color color;

    public Glyph(String fontFamily, Character character, double size, Color color) {
        super(character.toString());
        this.fontFamily = fontFamily;
        this.character = character;
        this.size = size;
        this.color = color;
        this.getStyleClass().add((Object)"glyph-font");
        this.updateStyle();
    }

    public void setSize(double size) {
        this.size = size;
        this.updateStyle();
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateStyle();
    }

    private void updateStyle() {
        StringBuilder css = new StringBuilder(String.format("-fx-font-family: %s; -fx-font-size: %fpx;", this.fontFamily, this.size));
        if (this.color == null) {
            css.append("-glyphs-color: -fx-text-background-color;");
        } else {
            css.append("-glyphs-color: rgb(");
            css.append((int)(this.color.getRed() * 255.0));
            css.append(",");
            css.append((int)(this.color.getGreen() * 255.0));
            css.append(",");
            css.append((int)this.color.getBlue() * 255);
            css.append(");");
        }
        this.setStyle(css.toString());
    }

    @Override
    public Glyph duplicate() {
        return new Glyph(this.fontFamily, this.character, this.size, this.color);
    }
}

