/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.controlsfx.control.PropertySheet;

public class BeanProperty
implements PropertySheet.Item {
    private final Object bean;
    private final PropertyDescriptor beanPropertyDescriptor;
    private final Method readMethod;

    public BeanProperty(Object bean, PropertyDescriptor propertyDescriptor) {
        this.bean = bean;
        this.beanPropertyDescriptor = propertyDescriptor;
        this.readMethod = propertyDescriptor.getReadMethod();
    }

    @Override
    public String getName() {
        return this.beanPropertyDescriptor.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.beanPropertyDescriptor.getShortDescription();
    }

    @Override
    public Class<?> getType() {
        return this.beanPropertyDescriptor.getPropertyType();
    }

    @Override
    public Object getValue() {
        try {
            return this.readMethod.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        Method writeMethod = this.beanPropertyDescriptor.getWriteMethod();
        if (writeMethod != null) {
            try {
                writeMethod.invoke(this.bean, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getCategory() {
        return this.beanPropertyDescriptor.isExpert() ? "Expert" : "Basic";
    }
}

