/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.BeanProperty;

public final class BeanPropertyUtils {
    private BeanPropertyUtils() {
    }

    public static ObservableList<PropertySheet.Item> getProperties(Object bean) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor p = propertyDescriptorArray[n2];
                if (BeanPropertyUtils.isProperty(p)) {
                    list.add((Object)new BeanProperty(bean, p));
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static boolean isProperty(PropertyDescriptor p) {
        return p.getWriteMethod() != null && !p.getPropertyType().isAssignableFrom(EventHandler.class);
    }
}

