/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import org.controlsfx.control.CustomTextField;

abstract class AbstractObjectField<T>
extends HBox {
    private static final Image image = new Image("/org/controlsfx/control/open-editor.png");
    private final CustomTextField textField = new CustomTextField();
    private ObjectProperty<T> objectProperty = new SimpleObjectProperty();

    public AbstractObjectField() {
        super(1.0);
        this.textField.setEditable(false);
        this.textField.setFocusTraversable(false);
        StackPane button = new StackPane(new Node[]{new ImageView(image)});
        button.setCursor(Cursor.DEFAULT);
        button.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                Object result;
                if (MouseButton.PRIMARY == e.getButton() && (result = AbstractObjectField.this.edit(AbstractObjectField.this.objectProperty.get())) != null) {
                    AbstractObjectField.this.objectProperty.set(result);
                }
            }
        });
        this.textField.setRight((Node)button);
        this.getChildren().add((Object)this.textField);
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.objectProperty.addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> o, T oldValue, T newValue) {
                AbstractObjectField.this.textProperty().set((Object)AbstractObjectField.this.objectToString(newValue));
            }
        });
    }

    protected StringProperty textProperty() {
        return this.textField.textProperty();
    }

    public ObjectProperty<T> getObjectProperty() {
        return this.objectProperty;
    }

    protected String objectToString(T object) {
        return object == null ? "" : object.toString();
    }

    protected abstract Class<T> getType();

    protected abstract T edit(T var1);
}

