/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Arrays;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.Editors;
import org.controlsfx.property.editor.PropertyEditor;

public class DefaultPropertyEditorFactory
implements Callback<PropertySheet.Item, PropertyEditor<?>> {
    private static Class<?>[] numericTypes = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigInteger.class, BigDecimal.class};

    public PropertyEditor<?> call(PropertySheet.Item item) {
        Class<LocalDate> type = item.getType();
        if (type != null && type == String.class) {
            return Editors.createTextEditor(item);
        }
        if (type != null && DefaultPropertyEditorFactory.isNumber(type)) {
            return Editors.createNumericEditor(item);
        }
        if (type != null && (type == Boolean.TYPE || type == Boolean.class)) {
            return Editors.createCheckEditor(item);
        }
        if (type != null && type.isAssignableFrom(LocalDate.class)) {
            return Editors.createDateEditor(item);
        }
        if (type != null && type.isAssignableFrom(Color.class)) {
            return Editors.createColorEditor(item);
        }
        if (type != null && type.isEnum()) {
            return Editors.createChoiceEditor(item, Arrays.asList(type.getEnumConstants()));
        }
        if (type != null && type == Font.class) {
            return Editors.createFontEditor(item);
        }
        return null;
    }

    private static boolean isNumber(Class<?> type) {
        if (type == null) {
            return false;
        }
        Class<?>[] classArray = numericTypes;
        int n = numericTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            if (type == cls) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

