/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;

class NumericField
extends TextField {
    private static String regex = "[-+]?[0-9]*\\.?[0-9]+";
    private final DoubleProperty value = new SimpleDoubleProperty((Object)this, "value", 0.0){

        protected void invalidated() {
            NumericField.this.setText(Double.toString(this.get()));
        }
    };

    public NumericField() {
        this.textProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
            }
        });
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public void replaceText(int start, int end, String text) {
        if (this.replaceMatches(start, end, text).booleanValue()) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        IndexRange range = this.getSelection();
        if (this.replaceMatches(range.getStart(), range.getEnd(), text).booleanValue()) {
            super.replaceSelection(text);
        }
    }

    private Boolean replaceMatches(int start, int end, String fragment) {
        return (String.valueOf(this.getText().substring(0, start)) + fragment + this.getText().substring(end)).matches(regex);
    }
}

