/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples;

import javafx.application.Application;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.ButtonBar;
import org.controlsfx.control.SegmentedButton;

public class HelloButtonBar
extends Application
implements Sample {
    @Override
    public String getSampleName() {
        return "ButtonBar";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/ButtonBar.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    private ToggleButton createToggle(String caption, final ButtonBar buttonBar, final String buttonBarOrder) {
        ToggleButton btn = new ToggleButton(caption);
        btn.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    buttonBar.setButtonOrder(buttonBarOrder);
                }
            }
        });
        return btn;
    }

    @Override
    public Node getPanel(Stage stage) {
        VBox root = new VBox(10.0);
        root.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        root.setMaxHeight(Double.MAX_VALUE);
        ButtonBar buttonBar = new ButtonBar();
        Label details = new Label("The ButtonBar allows for buttons to be positioned in a way that is OS-specific (or in any way that suits your use case. For example, try toggling the OS toggle buttons below (note, you'll want to increase the width of this window first!)\n\n");
        details.setWrapText(true);
        root.getChildren().add((Object)details);
        ToggleButton windowsBtn = this.createToggle("Windows", buttonBar, "L_E+U+FBI_YNOCAH_R");
        ToggleButton macBtn = this.createToggle("Mac OS", buttonBar, "L_HE+U+FBI_NCYOA_R");
        ToggleButton linuxBtn = this.createToggle("Linux", buttonBar, "L_HE+UNYACBXIO_R");
        windowsBtn.selectedProperty().set(true);
        SegmentedButton osChoice = new SegmentedButton((ObservableList<ToggleButton>)FXCollections.observableArrayList((Object[])new ToggleButton[]{windowsBtn, macBtn, linuxBtn}));
        root.getChildren().add((Object)osChoice);
        VBox.setVgrow((Node)osChoice, (Priority)Priority.NEVER);
        CheckBox uniformButtonBtn = new CheckBox("Set all buttons to a uniform size");
        uniformButtonBtn.selectedProperty().bindBidirectional((Property)buttonBar.buttonUniformSizeProperty());
        root.getChildren().add((Object)uniformButtonBtn);
        final Slider minSizeSlider = new Slider(0.0, 200.0, 0.0);
        Label pixelCountLabel = new Label();
        pixelCountLabel.textProperty().bind((ObservableValue)new StringBinding(){
            {
                this.bind(new Observable[]{slider.valueProperty()});
            }

            protected String computeValue() {
                return String.valueOf((int)minSizeSlider.getValue()) + "px";
            }
        });
        HBox minSizeBox = new HBox(10.0, new Node[]{new Label("Button min size:"), minSizeSlider, pixelCountLabel});
        minSizeBox.setAlignment(Pos.BASELINE_LEFT);
        buttonBar.buttonMinWidthProperty().bind((ObservableValue)minSizeSlider.valueProperty());
        root.getChildren().add((Object)minSizeBox);
        Region spacer = new Region();
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        root.getChildren().add((Object)spacer);
        buttonBar.getButtons().addAll((Object[])new ButtonBase[]{this.createButton("OK", ButtonBar.ButtonType.OK_DONE), this.createButton("Cancel", ButtonBar.ButtonType.CANCEL_CLOSE), this.createButton("Left 1", ButtonBar.ButtonType.LEFT), this.createButton("Left 2", ButtonBar.ButtonType.LEFT), this.createButton("Left 3", ButtonBar.ButtonType.LEFT), this.createButton("Right 1", ButtonBar.ButtonType.RIGHT), this.createButton("Unknown 1", ButtonBar.ButtonType.OTHER), this.createButton("Help(R)", ButtonBar.ButtonType.HELP), this.createButton("Help(L)", ButtonBar.ButtonType.HELP_2), this.createButton("Unknown 2 xxxxxxxxxx", ButtonBar.ButtonType.OTHER), this.createButton("Yes", ButtonBar.ButtonType.YES), this.createButton("No", ButtonBar.ButtonType.NO), this.createButton("Next", ButtonBar.ButtonType.NEXT_FORWARD), this.createButton("Unknown 3", ButtonBar.ButtonType.OTHER), this.createButton("Back", ButtonBar.ButtonType.BACK_PREVIOUS), this.createButton("Right 2", ButtonBar.ButtonType.RIGHT), this.createButton("Finish", ButtonBar.ButtonType.FINISH), this.createButton("Right 3", ButtonBar.ButtonType.RIGHT), this.createButton("Apply", ButtonBar.ButtonType.APPLY)});
        ScrollPane sp = new ScrollPane((Node)buttonBar);
        sp.setStyle("-fx-background-color: -fx-background; -fx-background-insets: 0");
        root.getChildren().add((Object)sp);
        VBox.setVgrow((Node)sp, (Priority)Priority.ALWAYS);
        return root;
    }

    public void start(Stage stage) throws Exception {
        stage.setTitle("ButtonBar Demo");
        Scene scene = new Scene((Parent)this.getPanel(stage), 1300.0, 300.0);
        scene.setFill((Paint)Color.WHITE);
        stage.setScene(scene);
        stage.show();
    }

    private Button createButton(String title, ButtonBar.ButtonType type) {
        Button button = new Button(title);
        ButtonBar.setType((ButtonBase)button, type);
        return button;
    }

    public static void main(String[] args) {
        HelloButtonBar.launch((String[])args);
    }
}

