/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples;

import java.util.Random;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.Sample;
import org.controlsfx.control.GridCell;
import org.controlsfx.control.GridView;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.action.AbstractAction;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.cell.ColorGridCell;
import org.controlsfx.control.cell.ImageGridCell;

public class HelloGridView
extends Application
implements Sample {
    private GridView<?> myGrid;
    private final VBox root = new VBox();

    public static void main(String[] args) {
        HelloGridView.launch((String[])new String[0]);
    }

    @Override
    public String getSampleName() {
        return "GridView";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/GridView.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    private GridView<?> getColorGrid() {
        ObservableList list = FXCollections.observableArrayList();
        GridView<Color> colorGrid = new GridView<Color>(list);
        colorGrid.setCellFactory(new Callback<GridView<Color>, GridCell<Color>>(){

            public GridCell<Color> call(GridView<Color> arg0) {
                return new ColorGridCell();
            }
        });
        Random r = new Random(System.currentTimeMillis());
        int i = 0;
        while (i < 500) {
            list.add((Object)new Color(r.nextDouble(), r.nextDouble(), r.nextDouble(), 1.0));
            ++i;
        }
        return colorGrid;
    }

    private GridView<?> getImageGrid(final boolean preserveImageProperties) {
        Image image = new Image("/org/controlsfx/samples/flowers.png", 200.0, 0.0, true, true);
        ObservableList list = FXCollections.observableArrayList();
        GridView<Image> colorGrid = new GridView<Image>(list);
        colorGrid.setCellFactory(new Callback<GridView<Image>, GridCell<Image>>(){

            public GridCell<Image> call(GridView<Image> arg0) {
                return new ImageGridCell(preserveImageProperties);
            }
        });
        int i = 0;
        while (i < 50) {
            list.add((Object)image);
            ++i;
        }
        return colorGrid;
    }

    @Override
    public Node getPanel(Stage stage) {
        SegmentedButton selector = ActionUtils.createSegmentedButton(new ActionShowGrid("Colors", this.getColorGrid()), new ActionShowGrid("Images", this.getImageGrid(false)), new ActionShowGrid("Images (preserve properties)", this.getImageGrid(true)));
        this.root.getChildren().clear();
        this.root.getChildren().add((Object)new ToolBar(new Node[]{selector}));
        ((ToggleButton)selector.getButtons().get(0)).fire();
        return this.root;
    }

    public void start(Stage primaryStage) throws Exception {
        primaryStage.setTitle("GridView");
        Scene scene = new Scene((Parent)this.getPanel(primaryStage), 540.0, 210.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    class ActionShowGrid
    extends AbstractAction {
        GridView<?> grid;

        public ActionShowGrid(String text, GridView<?> grid) {
            super(text);
            this.grid = grid;
        }

        @Override
        public void execute(ActionEvent ae) {
            if (HelloGridView.this.myGrid != null) {
                HelloGridView.this.root.getChildren().remove((Object)HelloGridView.this.myGrid);
            }
            HelloGridView.this.myGrid = this.grid;
            HelloGridView.this.root.getChildren().add((Object)HelloGridView.this.myGrid);
        }
    }
}

