/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples;

import javafx.application.Application;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.HyperlinkLabel;

public class HelloHyperlinkLabel
extends Application
implements Sample {
    private HyperlinkLabel label;

    public static void main(String[] args) {
        HelloHyperlinkLabel.launch((String[])args);
    }

    @Override
    public String getSampleName() {
        return "Hyperlink Label";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/HyperlinkLabel.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    @Override
    public Node getPanel(Stage stage) {
        VBox root = new VBox(20.0);
        root.setPadding(new Insets(30.0, 30.0, 30.0, 30.0));
        final TextField textToShowField = new TextField();
        textToShowField.setMaxWidth(Double.MAX_VALUE);
        textToShowField.setPromptText("Type text in here to display - use [] to indicate a hyperlink - e.g. [hello]");
        root.getChildren().add((Object)textToShowField);
        final TextField selectedLinkField = new TextField();
        selectedLinkField.setMaxWidth(Double.MAX_VALUE);
        selectedLinkField.setEditable(false);
        selectedLinkField.setPromptText("Click a link - I'll show you which one you clicked :-)");
        root.getChildren().add((Object)selectedLinkField);
        this.label = new HyperlinkLabel();
        this.label.textProperty().bind((ObservableValue)new StringBinding(){
            {
                this.bind(new Observable[]{textField.textProperty()});
            }

            protected String computeValue() {
                String str = textToShowField.getText();
                if (str == null || str.isEmpty()) {
                    return "Hello [world]! I [wonder] what hyperlink [you] [will] [click]";
                }
                return str;
            }
        });
        this.label.setOnAction(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Hyperlink link = (Hyperlink)event.getSource();
                String str = link == null ? "" : "You clicked on '" + link.getText() + "'";
                selectedLinkField.setText(str);
            }
        });
        root.getChildren().add((Object)this.label);
        return root;
    }

    public void start(Stage stage) {
        stage.setTitle("HyperlinkLabel Demo");
        Scene scene = new Scene((Parent)this.getPanel(stage), 520.0, 360.0);
        stage.setScene(scene);
        stage.show();
        this.label.requestFocus();
    }
}

