/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples;

import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.action.AbstractAction;
import org.controlsfx.control.action.Action;

public class HelloNotificationPane
extends Application
implements Sample {
    private NotificationPane notificationPane;
    private CheckBox cbUseDarkTheme;
    private TextField textField;

    public static void main(String[] args) {
        HelloNotificationPane.launch((String[])args);
    }

    @Override
    public String getSampleName() {
        return "Notification Pane";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/NotificationPane.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    @Override
    public Node getPanel(Stage stage) {
        this.notificationPane = new NotificationPane();
        String imagePath = HelloNotificationPane.class.getResource("notification-pane-warning.png").toExternalForm();
        ImageView image = new ImageView(imagePath);
        this.notificationPane.setGraphic((Node)image);
        this.notificationPane.getActions().addAll((Object[])new Action[]{new AbstractAction("Sync"){

            @Override
            public void execute(ActionEvent ae) {
                HelloNotificationPane.this.notificationPane.hide();
            }
        }});
        Button showBtn = new Button("Show / Hide");
        showBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                if (HelloNotificationPane.this.notificationPane.isShowing()) {
                    HelloNotificationPane.this.notificationPane.hide();
                } else {
                    HelloNotificationPane.this.notificationPane.show();
                }
            }
        });
        CheckBox cbSlideFromTop = new CheckBox("Slide from top");
        cbSlideFromTop.setSelected(true);
        this.notificationPane.showFromTopProperty().bind((ObservableValue)cbSlideFromTop.selectedProperty());
        this.cbUseDarkTheme = new CheckBox("Use dark theme");
        this.cbUseDarkTheme.setSelected(false);
        this.cbUseDarkTheme.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                HelloNotificationPane.this.updateBar();
            }
        });
        this.textField = new TextField();
        this.textField.setPromptText("Type text to display and press Enter");
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                HelloNotificationPane.this.notificationPane.show(HelloNotificationPane.this.textField.getText());
            }
        });
        VBox root = new VBox(10.0);
        root.setPadding(new Insets(50.0, 0.0, 0.0, 10.0));
        root.getChildren().addAll((Object[])new Node[]{showBtn, cbSlideFromTop, this.cbUseDarkTheme, this.textField});
        this.notificationPane.setContent((Node)root);
        this.updateBar();
        return this.notificationPane;
    }

    private void updateBar() {
        boolean useDarkTheme = this.cbUseDarkTheme.isSelected();
        if (useDarkTheme) {
            this.notificationPane.setText("Hello World! Using the dark theme");
            this.notificationPane.getStyleClass().add((Object)"dark");
        } else {
            this.notificationPane.setText("Hello World! Using the light theme");
            this.notificationPane.getStyleClass().remove((Object)"dark");
        }
    }

    public void start(Stage stage) {
        stage.setTitle("NotificationPane Demo");
        Scene scene = new Scene((Parent)this.getPanel(stage), 520.0, 360.0);
        stage.setScene(scene);
        stage.show();
    }
}

