/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples;

import java.time.LocalDate;
import java.time.Month;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.application.Application;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.action.AbstractAction;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.property.BeanPropertyUtils;

public class HelloPropertySheet
extends Application
implements Sample {
    private static Map<String, Object> customDataMap = new LinkedHashMap<String, Object>();
    private PropertySheet propertySheet = new PropertySheet();

    static {
        customDataMap.put("1. Name#First Name", "Jonathan");
        customDataMap.put("1. Name#Last Name", "Giles");
        customDataMap.put("1. Name#Birthday", LocalDate.of(1985, Month.JANUARY, 12));
        customDataMap.put("2. Billing Address#Address 1", "");
        customDataMap.put("2. Billing Address#Address 2", "");
        customDataMap.put("2. Billing Address#City", "");
        customDataMap.put("2. Billing Address#State", "");
        customDataMap.put("2. Billing Address#Zip", "");
        customDataMap.put("3. Phone#Home", "123-123-1234");
        customDataMap.put("3. Phone#Mobile", "234-234-2345");
        customDataMap.put("3. Phone#Work", "");
    }

    public static void main(String[] args) {
        HelloPropertySheet.launch((String[])new String[0]);
    }

    @Override
    public String getSampleName() {
        return "Property Sheet";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/PropertySheet.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    public void start(Stage primaryStage) throws Exception {
        primaryStage.setTitle("Property Sheet");
        Scene scene = new Scene((Parent)this.getPanel(primaryStage), 800.0, 800.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    @Override
    public Node getPanel(Stage stage) {
        VBox infoPane = new VBox(10.0);
        infoPane.setPadding(new Insets(20.0, 20.0, 20.0, 20.0));
        Button button = new Button("Title");
        TextField textField = new TextField();
        SegmentedButton segmentedButton = ActionUtils.createSegmentedButton(new ActionShowInPropertySheet("Bean: Button", button), new ActionShowInPropertySheet("Bean: TextField", textField), new ActionShowInPropertySheet("Custom Model", null));
        segmentedButton.getStyleClass().add((Object)"dark");
        ((ToggleButton)segmentedButton.getButtons().get(0)).fire();
        CheckBox toolbarModeVisible = new CheckBox("Toolbar Mode Visible");
        toolbarModeVisible.selectedProperty().bindBidirectional((Property)this.propertySheet.modeSwitcherVisibleProperty());
        CheckBox toolbarSeacrhVisible = new CheckBox("Toolbar Search Visible");
        toolbarSeacrhVisible.selectedProperty().bindBidirectional((Property)this.propertySheet.searchBoxVisibleProperty());
        infoPane.getChildren().add((Object)toolbarModeVisible);
        infoPane.getChildren().add((Object)toolbarSeacrhVisible);
        infoPane.getChildren().add((Object)segmentedButton);
        infoPane.getChildren().add((Object)button);
        infoPane.getChildren().add((Object)textField);
        SplitPane pane = new SplitPane();
        pane.getItems().addAll((Object[])new Node[]{infoPane, this.propertySheet});
        return pane;
    }

    class ActionModeChange
    extends AbstractAction {
        private PropertySheet.Mode mode;

        public ActionModeChange(String title, PropertySheet.Mode mode) {
            super(title);
            this.mode = mode;
        }

        @Override
        public void execute(ActionEvent ae) {
            HelloPropertySheet.this.propertySheet.modeProperty().set((Object)this.mode);
        }
    }

    class ActionShowInPropertySheet
    extends AbstractAction {
        private Object bean;

        public ActionShowInPropertySheet(String title, Object bean) {
            super(title);
            this.bean = bean;
        }

        private ObservableList<PropertySheet.Item> getCustomModelProperties() {
            ObservableList list = FXCollections.observableArrayList();
            for (String key : customDataMap.keySet()) {
                list.add((Object)new CustomPropertyItem(key));
            }
            return list;
        }

        @Override
        public void execute(ActionEvent ae) {
            Service<ObservableList<PropertySheet.Item>> service = new Service<ObservableList<PropertySheet.Item>>(){

                protected Task<ObservableList<PropertySheet.Item>> createTask() {
                    return new Task<ObservableList<PropertySheet.Item>>(){

                        protected ObservableList<PropertySheet.Item> call() throws Exception {
                            return ActionShowInPropertySheet.this.bean == null ? ActionShowInPropertySheet.this.getCustomModelProperties() : BeanPropertyUtils.getProperties(ActionShowInPropertySheet.this.bean);
                        }
                    };
                }
            };
            service.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent e) {
                    HelloPropertySheet.this.propertySheet.getItems().setAll((Collection)((ObservableList)e.getSource().getValue()));
                }
            });
            service.start();
        }
    }

    class CustomPropertyItem
    implements PropertySheet.Item {
        private String key;
        private String category;
        private String name;

        public CustomPropertyItem(String key) {
            this.key = key;
            String[] skey = key.split("#");
            this.category = skey[0];
            this.name = skey[1];
        }

        @Override
        public Class<?> getType() {
            return customDataMap.get(this.key).getClass();
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public Object getValue() {
            return customDataMap.get(this.key);
        }

        @Override
        public void setValue(Object value) {
            customDataMap.put(this.key, value);
        }
    }
}

