/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples;

import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.RangeSlider;

public class HelloRangeSlider
extends Application
implements Sample {
    public static void main(String[] args) {
        HelloRangeSlider.launch((String[])args);
    }

    @Override
    public String getSampleName() {
        return "RangeSlider";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/RangeSlider.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    @Override
    public Node getPanel(Stage stage) {
        VBox root = new VBox(15.0);
        Region horizontalRangeSlider = this.createHorizontalSlider();
        Region verticalRangeSlider = this.createVerticalSlider();
        root.getChildren().addAll((Object[])new Node[]{horizontalRangeSlider, verticalRangeSlider});
        return root;
    }

    public void start(Stage stage) {
        stage.setTitle("RangeSlider Demo");
        Scene scene = new Scene((Parent)this.getPanel(stage), 520.0, 360.0);
        stage.setScene(scene);
        stage.show();
    }

    Region createHorizontalSlider() {
        TextField minField = new TextField();
        minField.setPrefColumnCount(5);
        TextField maxField = new TextField();
        maxField.setPrefColumnCount(5);
        RangeSlider hSlider = new RangeSlider(0.0, 100.0, 10.0, 90.0);
        hSlider.setShowTickMarks(true);
        hSlider.setShowTickLabels(true);
        hSlider.setBlockIncrement(10.0);
        hSlider.setPrefWidth(200.0);
        minField.setText("" + hSlider.getLowValue());
        maxField.setText("" + hSlider.getHighValue());
        minField.setEditable(false);
        minField.setPromptText("Min");
        maxField.setEditable(false);
        maxField.setPromptText("Max");
        minField.textProperty().bind((ObservableValue)hSlider.lowValueProperty().asString("%.2f"));
        maxField.textProperty().bind((ObservableValue)hSlider.highValueProperty().asString("%.2f"));
        HBox box = new HBox(10.0);
        box.getChildren().addAll((Object[])new Node[]{minField, hSlider, maxField});
        box.setPadding(new Insets(20.0, 0.0, 0.0, 20.0));
        box.setFillHeight(false);
        return box;
    }

    Region createVerticalSlider() {
        TextField minField = new TextField();
        minField.setPrefColumnCount(5);
        TextField maxField = new TextField();
        maxField.setPrefColumnCount(5);
        RangeSlider vSlider = new RangeSlider(0.0, 200.0, 30.0, 150.0);
        vSlider.setOrientation(Orientation.VERTICAL);
        vSlider.setPrefHeight(200.0);
        vSlider.setBlockIncrement(10.0);
        vSlider.setShowTickMarks(true);
        vSlider.setShowTickLabels(true);
        minField.setText("" + vSlider.getLowValue());
        maxField.setText("" + vSlider.getHighValue());
        minField.setEditable(false);
        minField.setPromptText("Min");
        maxField.setEditable(false);
        maxField.setPromptText("Max");
        minField.textProperty().bind((ObservableValue)vSlider.lowValueProperty().asString("%.2f"));
        maxField.textProperty().bind((ObservableValue)vSlider.highValueProperty().asString("%.2f"));
        VBox box = new VBox(10.0);
        box.setPadding(new Insets(0.0, 0.0, 0.0, 20.0));
        box.setFillWidth(false);
        box.getChildren().addAll((Object[])new Node[]{maxField, vSlider, minField});
        return box;
    }
}

