/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples;

import javafx.application.Application;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.Rating;

public class HelloRating
extends Application
implements Sample {
    public static void main(String[] args) {
        HelloRating.launch((String[])args);
    }

    @Override
    public String getSampleName() {
        return "Rating";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/Rating.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    @Override
    public Node getPanel(Stage stage) {
        VBox root = new VBox(20.0);
        root.setPadding(new Insets(30.0, 30.0, 30.0, 30.0));
        Rating rating = new Rating();
        HBox controls_row1 = new HBox(5.0);
        ChoiceBox orientation = new ChoiceBox(FXCollections.observableArrayList((Object[])Orientation.values()));
        orientation.getSelectionModel().select((Object)Orientation.HORIZONTAL);
        rating.orientationProperty().bind((ObservableValue)orientation.getSelectionModel().selectedItemProperty());
        ChoiceBox ratingValue = new ChoiceBox(FXCollections.observableArrayList((Object[])new Double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0}));
        ratingValue.getSelectionModel().select((Object)rating.getRating());
        ChoiceBox maxValue = new ChoiceBox(FXCollections.observableArrayList((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}));
        maxValue.getSelectionModel().select(rating.getMax());
        rating.maxProperty().bind((ObservableValue)maxValue.getSelectionModel().selectedItemProperty());
        controls_row1.getChildren().addAll((Object[])new Node[]{orientation, ratingValue, maxValue});
        CheckBox partialRating = new CheckBox("Allow partial ratings");
        partialRating.selectedProperty().bindBidirectional((Property)rating.partialRatingProperty());
        CheckBox updateOnHover = new CheckBox("Update rating on hover");
        updateOnHover.selectedProperty().bindBidirectional((Property)rating.updateOnHoverProperty());
        root.getChildren().addAll((Object[])new Node[]{controls_row1, partialRating, updateOnHover, rating});
        rating.ratingProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                System.out.println("Rating = " + t1);
            }
        });
        return root;
    }

    public void start(Stage stage) {
        stage.setTitle("Rating Demo");
        Scene scene = new Scene((Parent)this.getPanel(stage), 520.0, 360.0);
        stage.setScene(scene);
        stage.show();
    }
}

