/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.spreadsheet.GridBase;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class HelloSpreadsheetView
extends Application
implements Sample {
    public static void main(String[] args) {
        HelloSpreadsheetView.launch((String[])args);
    }

    @Override
    public String getSampleName() {
        return "SpreadsheetView";
    }

    @Override
    public Node getPanel(Stage stage) {
        BorderPane borderPane = new BorderPane();
        int rowCount = 50;
        int columnCount = 10;
        GridBase grid = new GridBase(rowCount, columnCount);
        this.normalGrid(grid);
        this.buildBothGrid(grid);
        SpreadsheetView spreadSheetView = new SpreadsheetView(grid);
        borderPane.setCenter((Node)spreadSheetView);
        borderPane.setLeft((Node)this.buildCommonControlGrid(spreadSheetView, borderPane, "Both"));
        return borderPane;
    }

    private GridPane buildCommonControlGrid(final SpreadsheetView spv, final BorderPane borderPane, String gridType) {
        GridPane grid = new GridPane();
        grid.setHgap(5.0);
        grid.setVgap(5.0);
        grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        CheckBox rowHeader = new CheckBox("Row Header");
        rowHeader.setSelected(true);
        rowHeader.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                spv.setShowRowHeader(arg2);
            }
        });
        CheckBox columnHeader = new CheckBox("Column Header");
        columnHeader.setSelected(true);
        columnHeader.setDisable(true);
        columnHeader.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
            }
        });
        ChoiceBox typeOfGrid = new ChoiceBox(FXCollections.observableArrayList((Object[])new String[]{"Normal", "Both"}));
        typeOfGrid.setValue((Object)gridType);
        typeOfGrid.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                if (arg2.equals(0)) {
                    int rowCount = 50;
                    int columnCount = 10;
                    GridBase grid = new GridBase(rowCount, columnCount);
                    HelloSpreadsheetView.this.normalGrid(grid);
                    SpreadsheetView spreadSheetView = new SpreadsheetView(grid);
                    borderPane.setCenter((Node)spreadSheetView);
                    borderPane.setLeft((Node)HelloSpreadsheetView.this.buildCommonControlGrid(spreadSheetView, borderPane, "Normal"));
                } else {
                    int rowCount = 50;
                    int columnCount = 10;
                    GridBase grid = new GridBase(rowCount, columnCount);
                    HelloSpreadsheetView.this.normalGrid(grid);
                    HelloSpreadsheetView.this.buildBothGrid(grid);
                    SpreadsheetView spreadSheetView = new SpreadsheetView(grid);
                    borderPane.setCenter((Node)spreadSheetView);
                    borderPane.setLeft((Node)HelloSpreadsheetView.this.buildCommonControlGrid(spreadSheetView, borderPane, "Both"));
                }
            }
        });
        grid.add((Node)rowHeader, 1, 1);
        grid.add((Node)columnHeader, 1, 2);
        grid.add((Node)new Label("Span model:"), 1, 3);
        grid.add((Node)typeOfGrid, 1, 4);
        return grid;
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/spreadsheet/SpreadsheetView.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle("SpreadsheetView");
        Scene scene = new Scene((Parent)this.getPanel(primaryStage), 600.0, 400.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    private void normalGrid(GridBase grid) {
        ArrayList<ObservableList<SpreadsheetCell>> rows = new ArrayList<ObservableList<SpreadsheetCell>>(grid.getRowCount());
        int row = 0;
        while (row < grid.getRowCount()) {
            ObservableList dataRow = FXCollections.observableArrayList();
            int column = 0;
            while (column < grid.getColumnCount()) {
                dataRow.add((Object)this.generateCell(row, column, 1, 1));
                ++column;
            }
            rows.add((ObservableList<SpreadsheetCell>)dataRow);
            ++row;
        }
        grid.setRows(rows);
    }

    private SpreadsheetCell generateCell(int row, int column, int rowSpan, int colSpan) {
        SpreadsheetCell cell;
        List<String> stringListTextCell = Arrays.asList("Shanghai", "Paris", "New York City", "Bangkok", "Singapore", "Johannesburg", "Berlin", "Wellington", "London", "Montreal");
        double random = Math.random();
        if (random < 0.1) {
            List<String> stringList = Arrays.asList("China", "France", "New Zealand", "United States", "Germany", "Canada");
            cell = SpreadsheetCellType.LIST(stringList).createCell(row, column, rowSpan, colSpan, stringList.get((int)(Math.random() * 6.0)));
        } else {
            cell = random >= 0.1 && random < 0.25 ? SpreadsheetCellType.STRING.createCell(row, column, rowSpan, colSpan, stringListTextCell.get((int)(Math.random() * 10.0))) : (random >= 0.25 && random < 0.75 ? SpreadsheetCellType.DOUBLE.createCell(row, column, rowSpan, colSpan, (double)Math.round(Math.random() * 100.0 * 100.0) / 100.0) : SpreadsheetCellType.DATE.createCell(row, column, rowSpan, colSpan, LocalDate.now().plusDays((int)(Math.random() * 10.0))));
        }
        if (row % 5 == 0) {
            cell.getStyleClass().add((Object)"five_rows");
        }
        if (column == 0 && rowSpan == 1) {
            cell.getStyleClass().add((Object)"row_header");
        }
        if (row == 0) {
            cell.getStyleClass().add((Object)"col_header");
        }
        return cell;
    }

    private void buildBothGrid(GridBase grid) {
        grid.spanRow(2, 2, 2);
        grid.spanColumn(2, 2, 2);
        grid.spanRow(4, 2, 4);
        grid.spanColumn(5, 8, 2);
        grid.spanRow(15, 3, 8);
        grid.spanRow(3, 5, 5);
        grid.spanColumn(3, 5, 5);
        grid.spanRow(2, 10, 4);
        grid.spanColumn(3, 10, 4);
        grid.spanRow(2, 12, 3);
        grid.spanColumn(3, 22, 3);
        grid.spanRow(1, 27, 4);
        grid.spanColumn(4, 30, 3);
        grid.spanRow(4, 30, 3);
    }
}

