/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.CustomTextField;
import org.controlsfx.control.TextFields;

public class HelloTextFields
extends Application
implements Sample {
    private static final Image image = new Image("/org/controlsfx/samples/security-low.png");

    @Override
    public String getSampleName() {
        return "TextFields";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/TextFields.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    @Override
    public Node getPanel(Stage stage) {
        GridPane grid = new GridPane();
        grid.setVgap(10.0);
        grid.setHgap(10.0);
        grid.setPadding(new Insets(30.0, 30.0, 0.0, 30.0));
        int row = 0;
        grid.add((Node)new Label("Normal TextField: "), 0, row);
        grid.add((Node)new TextField(), 1, row++);
        grid.add((Node)new Label("SearchField: "), 0, row);
        grid.add((Node)TextFields.createSearchField(), 1, row++);
        grid.add((Node)new Label("CustomTextField (no additional nodes): "), 0, row);
        grid.add((Node)new CustomTextField(), 1, row++);
        grid.add((Node)new Label("CustomTextField (w/ right node): "), 0, row);
        CustomTextField customTextField1 = new CustomTextField();
        customTextField1.setRight((Node)new ImageView(image));
        grid.add((Node)customTextField1, 1, row++);
        grid.add((Node)new Label("CustomTextField (w/ left node): "), 0, row);
        CustomTextField customTextField2 = new CustomTextField();
        customTextField2.setLeft((Node)new ImageView(image));
        grid.add((Node)customTextField2, 1, row++);
        grid.add((Node)new Label("CustomTextField (w/ left + right node): "), 0, row);
        CustomTextField customTextField3 = new CustomTextField();
        ImageView imageView = new ImageView(image);
        customTextField3.setLeft((Node)imageView);
        customTextField3.setRight((Node)new ImageView(image));
        grid.add((Node)customTextField3, 1, row++);
        return grid;
    }

    public void start(Stage stage) throws Exception {
        stage.setTitle("CustomTextField Demo");
        Scene scene = new Scene((Parent)this.getPanel(stage), 550.0, 550.0);
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        HelloTextFields.launch((String[])args);
    }
}

