/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples.actions;

import java.util.Arrays;
import java.util.Collection;
import javafx.application.Application;
import javafx.beans.property.BooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.action.AbstractAction;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionGroup;
import org.controlsfx.control.action.ActionUtils;

public class HelloActionGroup
extends Application
implements Sample {
    private static final ImageView image = new ImageView(new Image("/org/controlsfx/samples/security-low.png"));
    private Collection<? extends Action> actions = Arrays.asList(new ActionGroup("Group 1", (Node)image, new DummyAction("Action 1.1", (Node)image), new DummyAction("Action 1.2")), new ActionGroup("Group 2", (Node)image, new DummyAction("Action 2.1"), ActionUtils.ACTION_SEPARATOR, new ActionGroup("Action 2.2", new DummyAction("Action 2.2.1"), new DummyAction("Action 2.2.2")), new DummyAction("Action 2.3")), ActionUtils.ACTION_SEPARATOR, new DummyAction("Action 3", (Node)image), new ActionGroup("Group 4", (Node)image, new DummyAction("Action 4.1", (Node)image), new DummyAction("Action 4.2")));

    private ObservableList<Action> flatten(Collection<? extends Action> actions, ObservableList<Action> dest) {
        for (Action action : actions) {
            if (action == null || action == ActionUtils.ACTION_SEPARATOR) continue;
            dest.add((Object)action);
            if (!(action instanceof ActionGroup)) continue;
            this.flatten((Collection<? extends Action>)((ActionGroup)action).getActions(), dest);
        }
        return dest;
    }

    @Override
    public String getSampleName() {
        return "Action Group";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/action/ActionGroup.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    @Override
    public Node getPanel(Stage stage) {
        VBox root = new VBox(10.0);
        root.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        root.setMaxHeight(Double.MAX_VALUE);
        Label overview = new Label("MenuBar, ToolBar and ContextMenu presented here are effortlesly built out of the same action tree. Action properties can be dynamically changed, triggering changes in all related controls");
        overview.setWrapText(true);
        root.getChildren().add((Object)overview);
        HBox hbox = new HBox(10.0);
        final ComboBox cbActions = new ComboBox(this.flatten(this.actions, (ObservableList<Action>)FXCollections.observableArrayList()));
        cbActions.getSelectionModel().select(0);
        hbox.getChildren().add((Object)new Label("Dynamically enable/disable action: "));
        hbox.getChildren().add((Object)cbActions);
        AbstractAction toggleAction = new AbstractAction("Enable/Disable"){

            @Override
            public void execute(ActionEvent ae) {
                Action action = (Action)cbActions.getSelectionModel().getSelectedItem();
                if (action != null) {
                    BooleanProperty p;
                    p.set(!(p = action.disabledProperty()).get());
                }
            }
        };
        hbox.getChildren().add((Object)ActionUtils.createButton(toggleAction));
        root.getChildren().add((Object)hbox);
        root.getChildren().add((Object)new Separator());
        VBox examplesPane = new VBox(5.0);
        examplesPane.setStyle("-fx-background-color: white;-fx-border-color: gray;-fx-border-width: 2;-fx-border-style: dotted");
        root.getChildren().add((Object)examplesPane);
        Insets topMargin = new Insets(7.0, 7.0, 0.0, 7.0);
        Insets margin = new Insets(0.0, 7.0, 7.0, 7.0);
        this.addWithMargin(examplesPane, (Control)new Label("MenuBar"), topMargin).setStyle("-fx-font-weight: bold;");
        this.addWithMargin(examplesPane, (Control)ActionUtils.createMenuBar(this.actions), margin);
        this.addWithMargin(examplesPane, (Control)new Label("ToolBar (with text on controls)"), topMargin).setStyle("-fx-font-weight: bold;");
        this.addWithMargin(examplesPane, (Control)ActionUtils.createToolBar(this.actions, ActionUtils.ActionTextBehavior.SHOW), margin);
        this.addWithMargin(examplesPane, (Control)new Label("ToolBar (no text on controls)"), topMargin).setStyle("-fx-font-weight: bold;");
        this.addWithMargin(examplesPane, (Control)ActionUtils.createToolBar(this.actions, ActionUtils.ActionTextBehavior.HIDE), margin);
        this.addWithMargin(examplesPane, (Control)new Label("ContextMenu"), topMargin).setStyle("-fx-font-weight: bold;");
        Label context = new Label("Right-click to see the context menu");
        this.addWithMargin(examplesPane, (Control)context, margin);
        context.setContextMenu(ActionUtils.createContextMenu(this.actions));
        context.setStyle("-fx-background-color: #E0E0E0 ;-fx-border-color: black;-fx-border-style: dotted");
        context.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        VBox.setVgrow((Node)context, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)examplesPane, (Priority)Priority.ALWAYS);
        return root;
    }

    private Control addWithMargin(VBox parent, Control control, Insets insets) {
        parent.getChildren().add((Object)control);
        VBox.setMargin((Node)control, (Insets)insets);
        return control;
    }

    public void start(Stage stage) throws Exception {
        stage.setTitle("Action Group Demo");
        Scene scene = new Scene((Parent)this.getPanel(stage), 1300.0, 300.0);
        scene.setFill((Paint)Color.WHITE);
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        HelloActionGroup.launch((String[])args);
    }

    static class DummyAction
    extends AbstractAction {
        public DummyAction(String name, Node image) {
            super(name);
            this.setGraphic(image);
        }

        public DummyAction(String name) {
            super(name);
        }

        @Override
        public void execute(ActionEvent ae) {
            System.out.println(String.format("Action '%s' is executed", this.getText()));
        }

        public String toString() {
            return this.getText();
        }
    }
}

