/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples.actions;

import java.util.Arrays;
import java.util.Collection;
import javafx.application.Application;
import javafx.beans.property.BooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.action.AbstractAction;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionGroup;
import org.controlsfx.control.action.ActionMap;
import org.controlsfx.control.action.ActionProxy;
import org.controlsfx.control.action.ActionUtils;

public class HelloActionProxy
extends Application
implements Sample {
    private static final String imagePath = "/org/controlsfx/samples/security-low.png";
    private static final ImageView image = new ImageView(new Image("/org/controlsfx/samples/security-low.png"));
    private Collection<? extends Action> actions;

    public HelloActionProxy() {
        ActionMap.register(this);
        this.actions = Arrays.asList(new ActionGroup("Group 1", (Node)image, ActionMap.actions("action11", "action12")), new ActionGroup("Group 2", (Node)image, ActionMap.actions("action21", "---", "action22", "action221", "action222", "action23")), ActionUtils.ACTION_SEPARATOR, ActionMap.action("action3"), new ActionGroup("Group 4", (Node)image, ActionMap.actions("action41", "action42")));
    }

    @ActionProxy(text="Action 1.1", graphic="/org/controlsfx/samples/security-low.png", accelerator="ctrl+shift+T")
    private void action11() {
        System.out.println("Action 1.1 is executed");
    }

    @ActionProxy(text="Action 1.2", graphic="http://icons.iconarchive.com/icons/custom-icon-design/mini-3/16/teacher-male-icon.png")
    private void action12() {
        System.out.println("Action 1.2 is executed");
    }

    @ActionProxy(text="Action 2.1", graphic="/org/controlsfx/samples/security-low.png")
    private void action21() {
        System.out.println("Action 2.1 is executed");
    }

    @ActionProxy(text="Action 2.2", graphic="/org/controlsfx/samples/security-low.png")
    private void action22() {
        System.out.println("Action 2.2 is executed");
    }

    @ActionProxy(text="Action 2.2.1", graphic="/org/controlsfx/samples/security-low.png")
    private void action221() {
        System.out.println("Action 2.2,1 is executed");
    }

    @ActionProxy(text="Action 2.2.2", graphic="/org/controlsfx/samples/security-low.png")
    private void action222() {
        System.out.println("Action 2.2.2 is executed");
    }

    @ActionProxy(text="Action 2.3", graphic="/org/controlsfx/samples/security-low.png")
    private void action23() {
        System.out.println("Action 2.3 is executed");
    }

    @ActionProxy(text="Action 3", graphic="font>FontAwesome|STAR")
    private void action3() {
        System.out.println("Action 3 is executed");
    }

    @ActionProxy(text="Action 4.1", graphic="/org/controlsfx/samples/security-low.png")
    private void action41() {
        System.out.println("Action 4.1 is executed");
    }

    @ActionProxy(text="Action 4.2", graphic="/org/controlsfx/samples/security-low.png")
    private void action42() {
        System.out.println("Action 4.2 is executed");
    }

    private ObservableList<Action> flatten(Collection<? extends Action> actions, ObservableList<Action> dest) {
        for (Action action : actions) {
            if (action == null || action == ActionUtils.ACTION_SEPARATOR) continue;
            dest.add((Object)action);
            if (!(action instanceof ActionGroup)) continue;
            this.flatten((Collection<? extends Action>)((ActionGroup)action).getActions(), dest);
        }
        return dest;
    }

    @Override
    public String getSampleName() {
        return "Action Proxy";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/action/ActionProxy.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    @Override
    public Node getPanel(Stage stage) {
        VBox root = new VBox(10.0);
        root.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        root.setMaxHeight(Double.MAX_VALUE);
        Label overview = new Label("MenuBar, ToolBar and ContextMenu presented here are effortlesly built out of the same action tree. Action properties can be dynamically changed, triggering changes in all related controls");
        overview.setWrapText(true);
        root.getChildren().add((Object)overview);
        HBox hbox = new HBox(10.0);
        final ComboBox cbActions = new ComboBox(this.flatten(this.actions, (ObservableList<Action>)FXCollections.observableArrayList()));
        cbActions.getSelectionModel().select(0);
        hbox.getChildren().add((Object)new Label("Dynamically enable/disable action: "));
        hbox.getChildren().add((Object)cbActions);
        AbstractAction toggleAction = new AbstractAction("Enable/Disable"){

            @Override
            public void execute(ActionEvent ae) {
                Action action = (Action)cbActions.getSelectionModel().getSelectedItem();
                if (action != null) {
                    BooleanProperty p;
                    p.set(!(p = action.disabledProperty()).get());
                }
            }
        };
        hbox.getChildren().add((Object)ActionUtils.createButton(toggleAction));
        root.getChildren().add((Object)hbox);
        root.getChildren().add((Object)new Separator());
        VBox examplesPane = new VBox(5.0);
        examplesPane.setStyle("-fx-background-color: white;-fx-border-color: gray;-fx-border-width: 2;-fx-border-style: dotted");
        root.getChildren().add((Object)examplesPane);
        Insets topMargin = new Insets(7.0, 7.0, 0.0, 7.0);
        Insets margin = new Insets(0.0, 7.0, 7.0, 7.0);
        this.addWithMargin(examplesPane, (Control)new Label("MenuBar"), topMargin).setStyle("-fx-font-weight: bold;");
        this.addWithMargin(examplesPane, (Control)ActionUtils.createMenuBar(this.actions), margin);
        this.addWithMargin(examplesPane, (Control)new Label("ToolBar (with text on controls)"), topMargin).setStyle("-fx-font-weight: bold;");
        this.addWithMargin(examplesPane, (Control)ActionUtils.createToolBar(this.actions, ActionUtils.ActionTextBehavior.SHOW), margin);
        this.addWithMargin(examplesPane, (Control)new Label("ToolBar (no text on controls)"), topMargin).setStyle("-fx-font-weight: bold;");
        this.addWithMargin(examplesPane, (Control)ActionUtils.createToolBar(this.actions, ActionUtils.ActionTextBehavior.HIDE), margin);
        this.addWithMargin(examplesPane, (Control)new Label("ContextMenu"), topMargin).setStyle("-fx-font-weight: bold;");
        Label context = new Label("Right-click to see the context menu");
        this.addWithMargin(examplesPane, (Control)context, margin);
        context.setContextMenu(ActionUtils.createContextMenu(this.actions));
        context.setStyle("-fx-background-color: #E0E0E0 ;-fx-border-color: black;-fx-border-style: dotted");
        context.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        VBox.setVgrow((Node)context, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)examplesPane, (Priority)Priority.ALWAYS);
        return root;
    }

    private Control addWithMargin(VBox parent, Control control, Insets insets) {
        parent.getChildren().add((Object)control);
        VBox.setMargin((Node)control, (Insets)insets);
        return control;
    }

    public void start(Stage stage) throws Exception {
        stage.setTitle("Action Proxy Demo");
        Scene scene = new Scene((Parent)this.getPanel(stage), 1300.0, 300.0);
        scene.setFill((Paint)Color.WHITE);
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        HelloActionProxy.launch((String[])args);
    }
}

