/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples.checked;

import javafx.application.Application;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.CheckTreeView;

public class HelloCheckTreeView
extends Application
implements Sample {
    @Override
    public String getSampleName() {
        return "CheckTreeView";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/control/CheckTreeView.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    @Override
    public Node getPanel(Stage stage) {
        GridPane grid = new GridPane();
        grid.setVgap(10.0);
        grid.setHgap(10.0);
        grid.setPadding(new Insets(30.0, 30.0, 0.0, 30.0));
        CheckBoxTreeItem root = new CheckBoxTreeItem((Object)"Root");
        root.setExpanded(true);
        root.getChildren().addAll((Object[])new TreeItem[]{new CheckBoxTreeItem((Object)"Jonathan"), new CheckBoxTreeItem((Object)"Eugene"), new CheckBoxTreeItem((Object)"Henri"), new CheckBoxTreeItem((Object)"Samir")});
        final Label checkedItemsLabel = new Label();
        final Label selectedItemsLabel = new Label();
        CheckTreeView checkTreeView = new CheckTreeView(root);
        checkTreeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        checkTreeView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<TreeItem<String>>(){

            public void onChanged(ListChangeListener.Change<? extends TreeItem<String>> c) {
                HelloCheckTreeView.this.updateText(selectedItemsLabel, (ObservableList<? extends TreeItem<String>>)c.getList());
            }
        });
        checkTreeView.getCheckModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<TreeItem<String>>(){

            public void onChanged(ListChangeListener.Change<? extends TreeItem<String>> c) {
                HelloCheckTreeView.this.updateText(checkedItemsLabel, (ObservableList<? extends TreeItem<String>>)c.getList());
            }
        });
        grid.add(checkTreeView, 0, 0, 1, 3);
        grid.add((Node)new Label("Checked items: "), 1, 0);
        grid.add((Node)checkedItemsLabel, 2, 0);
        grid.add((Node)new Label("Selected items: "), 1, 1);
        grid.add((Node)selectedItemsLabel, 2, 1);
        return grid;
    }

    protected void updateText(Label label, ObservableList<? extends TreeItem<String>> list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int max = list.size();
        while (i < max) {
            sb.append((String)((TreeItem)list.get(i)).getValue());
            if (i < max - 1) {
                sb.append(", ");
            }
            ++i;
        }
        label.setText(sb.toString());
    }

    public void start(Stage stage) throws Exception {
        stage.setTitle("CheckTreeView Demo");
        Scene scene = new Scene((Parent)this.getPanel(stage), 550.0, 550.0);
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        HelloCheckTreeView.launch((String[])args);
    }
}

