/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples.dialogs;

import java.util.Arrays;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.control.ButtonBar;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.action.Action;
import org.controlsfx.dialog.AbstractDialogAction;
import org.controlsfx.dialog.Dialog;
import org.controlsfx.dialog.Dialogs;
import org.controlsfx.dialog.DialogsAccessor;

public class HelloDialog
extends Application
implements Sample {
    private final CheckBox cbUseLightweightDialog = new CheckBox("Use Lightweight Dialogs");
    private final CheckBox cbUseNativeTitleBar = new CheckBox("Use Native TitleBar");
    private final CheckBox cbShowMasthead = new CheckBox("Show Masthead");
    private final CheckBox cbSetOwner = new CheckBox("Set Owner");
    private static final String WINDOWS = "Windows";
    private static final String MAC_OS = "Mac OS";
    private static final String LINUX = "Linux";
    private Stage stage;

    @Override
    public String getSampleName() {
        return "Dialogs";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/dialog/Dialogs.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    private ToggleButton createToggle(final String caption) {
        ToggleButton btn = new ToggleButton(caption);
        btn.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                DialogsAccessor.setMacOS(HelloDialog.MAC_OS.equals(caption));
                DialogsAccessor.setWindows(HelloDialog.WINDOWS.equals(caption));
                DialogsAccessor.setLinux(HelloDialog.LINUX.equals(caption));
            }
        });
        return btn;
    }

    private boolean includeOwner() {
        return this.cbSetOwner.isSelected() || this.cbUseLightweightDialog.isSelected();
    }

    @Override
    public Node getPanel(final Stage stage) {
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        int row = 0;
        grid.add(this.createLabel("Operating system button placement: "), 0, 0);
        ToggleButton windowsBtn = this.createToggle(WINDOWS);
        ToggleButton macBtn = this.createToggle(MAC_OS);
        ToggleButton linuxBtn = this.createToggle(LINUX);
        windowsBtn.selectedProperty().set(true);
        SegmentedButton operatingSystem = new SegmentedButton((ObservableList<ToggleButton>)FXCollections.observableArrayList((Object[])new ToggleButton[]{windowsBtn, macBtn, linuxBtn}));
        grid.add((Node)operatingSystem, 1, row, 3, 1);
        grid.add(this.createLabel("Common Dialog attributes: "), 0, 1);
        grid.add((Node)new HBox(10.0, new Node[]{this.cbUseLightweightDialog, this.cbUseNativeTitleBar, this.cbShowMasthead, this.cbSetOwner}), 1, ++row);
        grid.add(this.createLabel("Information Dialog: "), 0, ++row);
        Button Hyperlink2 = new Button("Show");
        Hyperlink2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                HelloDialog.this.configureSampleDialog(Dialogs.create().title("JavaFX").masthead(HelloDialog.this.isMastheadVisible() ? "Wouldn't this be nice?" : null).message("A collection of pre-built JavaFX dialogs?\nSeems like a great idea to me...")).showInformation();
            }
        });
        grid.add((Node)new HBox(10.0, new Node[]{Hyperlink2}), 1, row);
        grid.add(this.createLabel("Confirmation Dialog: "), 0, ++row);
        final CheckBox cbShowCancel = new CheckBox("Show Cancel Button");
        cbShowCancel.setSelected(true);
        Button Hyperlink3 = new Button("Show");
        Hyperlink3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Action[] actionArray;
                Dialogs dialogs = HelloDialog.this.configureSampleDialog(Dialogs.create().title("You do want dialogs right?").masthead(HelloDialog.this.isMastheadVisible() ? "Just Checkin'" : null).message("I was a bit worried that you might not want them, so I wanted to double check."));
                if (!cbShowCancel.isSelected()) {
                    Action[] actionArray2 = new Action[2];
                    actionArray2[0] = Dialog.Actions.YES;
                    actionArray = actionArray2;
                    actionArray2[1] = Dialog.Actions.NO;
                } else {
                    actionArray = new Action[]{};
                }
                Action response = dialogs.actions(actionArray).showConfirm();
                System.out.println("response: " + response);
            }
        });
        grid.add((Node)new HBox(10.0, new Node[]{Hyperlink3, cbShowCancel}), 1, row);
        grid.add(this.createLabel("Warning Dialog: "), 0, ++row);
        Button Hyperlink6a = new Button("Show");
        Hyperlink6a.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Action response = HelloDialog.this.configureSampleDialog(Dialogs.create().title("I'm warning you!").masthead(HelloDialog.this.isMastheadVisible() ? "I'm glad I didn't need to use this..." : null).message("This is a warning")).showWarning();
                System.out.println("response: " + response);
            }
        });
        grid.add((Node)new HBox(10.0, new Node[]{Hyperlink6a}), 1, row);
        grid.add(this.createLabel("Error Dialog: "), 0, ++row);
        Button Hyperlink7a = new Button("Show");
        Hyperlink7a.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Action response = HelloDialog.this.configureSampleDialog(Dialogs.create().title("It looks like you're making a bad decision").message("Exception Encountered").masthead(HelloDialog.this.isMastheadVisible() ? "Better change your mind - this is really your last chance! Even longer text that should probably wrap" : null)).showError();
                System.out.println("response: " + response);
            }
        });
        grid.add((Node)new HBox(10.0, new Node[]{Hyperlink7a}), 1, row);
        grid.add(this.createLabel("'Exception' Dialog: "), 0, ++row);
        Button Hyperlink5a = new Button("Show");
        Hyperlink5a.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Action response = HelloDialog.this.configureSampleDialog(Dialogs.create().title("It looks like you're making a bad decision").message("Better change your mind - this is really your last chance!").masthead(HelloDialog.this.isMastheadVisible() ? "Exception Encountered" : null)).showException(new RuntimeException("Pending Bad Decision Exception"));
                System.out.println("response: " + response);
            }
        });
        Button Hyperlink5b = new Button("Open in new window");
        Hyperlink5b.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Action response = HelloDialog.this.configureSampleDialog(Dialogs.create().message("Better change your mind - this is really your last chance!").title("It looks like you're making a bad decision").masthead(HelloDialog.this.isMastheadVisible() ? "Exception Encountered" : null)).showExceptionInNewWindow(new RuntimeException("Pending Bad Decision Exception"));
                System.out.println("response: " + response);
            }
        });
        grid.add((Node)new HBox(10.0, new Node[]{Hyperlink5a, Hyperlink5b}), 1, row);
        grid.add(this.createLabel("Input Dialog: "), 0, ++row);
        Button Hyperlink8 = new Button("TextField");
        Hyperlink8.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                String response = HelloDialog.this.configureSampleDialog(Dialogs.create().title("Name Check").masthead(HelloDialog.this.isMastheadVisible() ? "Please type in your name" : null).message("What is your name?")).showTextInput();
                System.out.println("response: " + response);
            }
        });
        Button Hyperlink9 = new Button("Initial Value Set");
        Hyperlink9.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                String response = HelloDialog.this.configureSampleDialog(Dialogs.create().title("Name Guess").masthead(HelloDialog.this.isMastheadVisible() ? "Name Guess" : null).message("Pick a name?")).showTextInput("Jonathan");
                System.out.println("response: " + response);
            }
        });
        Button Hyperlink10 = new Button("Set Choices (< 10)");
        Hyperlink10.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                String response = HelloDialog.this.configureSampleDialog(Dialogs.create().title("Name Guess").masthead(HelloDialog.this.isMastheadVisible() ? "Name Guess" : null).message("Pick a name?")).showChoices("Matthew", "Jonathan", "Ian", "Sue", "Hannah");
                System.out.println("response: " + response);
            }
        });
        Button Hyperlink11 = new Button("Set Choices (>= 10)");
        Hyperlink11.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                String response = HelloDialog.this.configureSampleDialog(Dialogs.create().title("Name Guess").masthead(HelloDialog.this.isMastheadVisible() ? "Name Guess" : null).message("Pick a name?")).showChoices("Matthew", "Jonathan", "Ian", "Sue", "Hannah", "Julia", "Denise", "Stephan", "Sarah", "Ron", "Ingrid");
                System.out.println("response: " + response);
            }
        });
        grid.add((Node)new HBox(10.0, new Node[]{Hyperlink8, Hyperlink9, Hyperlink10, Hyperlink11}), 1, row);
        grid.add(this.createLabel("Other pre-built dialogs: "), 0, ++row);
        Button Hyperlink12 = new Button("Command Links");
        Hyperlink12.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                List<Dialogs.CommandLink> links = Arrays.asList(new Dialogs.CommandLink("Add a network that is in the range of this computer", "This shows you a list of networks that are currently available and lets you connect to one."), new Dialogs.CommandLink("Manually create a network profile", "This creates a new network profile or locates an existing one and saves it on your computer"), new Dialogs.CommandLink("Create an ad hoc network", "This creates a temporary network for sharing files or and Internet connection"));
                Action response = HelloDialog.this.configureSampleDialog(Dialogs.create().title("Manually connect to wireless network").masthead(HelloDialog.this.isMastheadVisible() ? "Manually connect to wireless network" : null).message("How do you want to add a network?")).showCommandLinks(links.get(1), links);
                System.out.println("response: " + response);
            }
        });
        Button Hyperlink12a = new Button("Font Chooser");
        Hyperlink12a.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Font response = HelloDialog.this.configureSampleDialog(Dialogs.create()).showFontSelector(null);
                System.out.println("font: " + response);
            }
        });
        Button Hyperlink12b = new Button("Progress");
        Hyperlink12b.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Task<Object> worker = new Task<Object>(){

                    protected Object call() throws Exception {
                        int i = 0;
                        while (i < 100) {
                            this.updateProgress(i, 99L);
                            System.out.println("progress: " + i);
                            Thread.sleep(100L);
                            ++i;
                        }
                        return null;
                    }
                };
                HelloDialog.this.configureSampleDialog(Dialogs.create().title("Progress").masthead(HelloDialog.this.isMastheadVisible() ? "Please wait whilst the install completes..." : null).message("Now Loading...")).showWorkerProgress((Worker<?>)worker);
                Thread th = new Thread((Runnable)worker);
                th.setDaemon(true);
                th.start();
            }
        });
        grid.add((Node)new HBox(10.0, new Node[]{Hyperlink12, Hyperlink12a, Hyperlink12b}), 1, row);
        grid.add(this.createLabel("Custom Dialog: "), 0, ++row);
        Button Hyperlink14 = new Button("Show");
        Hyperlink14.setOnAction((EventHandler)new EventHandler<ActionEvent>(){
            final TextField txUserName = new TextField();
            final PasswordField txPassword = new PasswordField();
            final Action actionLogin = new AbstractDialogAction("Login", new Dialog.ActionTrait[]{Dialog.ActionTrait.CLOSING, Dialog.ActionTrait.DEFAULT}){
                {
                    ButtonBar.setType(this, ButtonBar.ButtonType.OK_DONE);
                }

                @Override
                public void execute(ActionEvent ae) {
                    Dialog dlg = (Dialog)ae.getSource();
                    dlg.setResult(this);
                }

                public String toString() {
                    return "LOGIN";
                }
            };

            private void validate() {
                this.actionLogin.disabledProperty().set(this.txUserName.getText().trim().isEmpty() || this.txPassword.getText().trim().isEmpty());
            }

            public void handle(ActionEvent arg0) {
                Dialog dlg = new Dialog(HelloDialog.this.includeOwner() ? stage : null, "Login Dialog", HelloDialog.this.cbUseLightweightDialog.isSelected(), HelloDialog.this.cbUseNativeTitleBar.isSelected());
                if (HelloDialog.this.cbShowMasthead.isSelected()) {
                    dlg.setMasthead("Login to ControlsFX");
                }
                ChangeListener<String> changeListener = new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                        this.validate();
                    }
                };
                this.txUserName.textProperty().addListener((ChangeListener)changeListener);
                this.txPassword.textProperty().addListener((ChangeListener)changeListener);
                GridPane content = new GridPane();
                content.setHgap(10.0);
                content.setVgap(10.0);
                content.add((Node)new Label("User name"), 0, 0);
                content.add((Node)this.txUserName, 1, 0);
                GridPane.setHgrow((Node)this.txUserName, (Priority)Priority.ALWAYS);
                content.add((Node)new Label("Password"), 0, 1);
                content.add((Node)this.txPassword, 1, 1);
                GridPane.setHgrow((Node)this.txPassword, (Priority)Priority.ALWAYS);
                dlg.setResizable(false);
                dlg.setIconifiable(false);
                dlg.setGraphic((Node)new ImageView(HelloDialog.class.getResource("login.png").toString()));
                dlg.setContent((Node)content);
                dlg.getActions().addAll((Object[])new Action[]{this.actionLogin, Dialog.Actions.CANCEL});
                this.validate();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        txUserName.requestFocus();
                    }
                });
                Action response = dlg.show();
                System.out.println("response: " + response);
            }
        });
        grid.add((Node)new HBox(10.0, new Node[]{Hyperlink14}), 1, row);
        return grid;
    }

    private Dialogs configureSampleDialog(Dialogs dialog) {
        if (this.cbSetOwner.isSelected()) {
            dialog.owner(this.includeOwner() ? this.stage : null);
        }
        if (this.cbUseLightweightDialog.isSelected()) {
            dialog.lightweight();
        }
        if (this.cbUseNativeTitleBar.isSelected()) {
            dialog.nativeTitleBar();
        }
        return dialog;
    }

    public void start(Stage stage) {
        this.stage = stage;
        stage.setTitle("Dialog Sample");
        Scene scene = new Scene((Parent)this.getPanel(stage), 800.0, 400.0);
        scene.setFill((Paint)Color.WHITE);
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private Node createLabel(String text) {
        Label label = new Label(text);
        label.setFont(Font.font((double)13.0));
        return label;
    }

    private boolean isMastheadVisible() {
        return this.cbShowMasthead.isSelected();
    }
}

