/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.samples.dialogs;

import java.util.Date;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.controlsfx.Sample;
import org.controlsfx.dialog.Dialogs;

public class HelloLightweightDialogInTabPane
extends Application
implements Sample {
    private Stage stage;

    @Override
    public String getSampleName() {
        return "Lightweight Dialogs";
    }

    @Override
    public String getJavaDocURL() {
        return "http://docs.controlsfx.org/org/controlsfx/dialog/Dialogs.html";
    }

    @Override
    public boolean includeInSamples() {
        return true;
    }

    @Override
    public Node getPanel(Stage stage) {
        Tab tab1 = new Tab("Tab 1");
        this.buildTab1(tab1);
        Tab tab2 = new Tab("Tab 2");
        this.buildTab2(tab2);
        TabPane tabPane = new TabPane();
        tabPane.getStyleClass().add((Object)"floating");
        tabPane.getTabs().addAll((Object[])new Tab[]{tab1, tab2});
        tabPane.setPadding(new Insets(10.0));
        StackPane pane = new StackPane(new Node[]{tabPane});
        return pane;
    }

    private void buildTab1(final Tab tab1) {
        Button showDialogBtn = new Button("Show lightweight dialog in this Tab");
        showDialogBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                Dialogs.create().lightweight().owner(tab1).title("Lightweight Dialog").message("This should only block Tab 1 - try going to Tab 2").showInformation();
            }
        });
        Button printToConsole = new Button("Print to console");
        printToConsole.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                System.out.println(new Date());
            }
        });
        VBox tab1Content = new VBox(10.0);
        tab1Content.setPadding(new Insets(10.0));
        tab1Content.getChildren().setAll((Object[])new Node[]{showDialogBtn, printToConsole});
        tab1.setContent((Node)tab1Content);
    }

    private void buildTab2(Tab tab2) {
        final ListView listView = new ListView();
        listView.getItems().setAll((Object[])new String[]{"Jonathan", "Eugene", "Hendrik", "Danno", "Paru"});
        GridPane.setHgrow((Node)listView, (Priority)Priority.ALWAYS);
        Button showDialogBtn = new Button("Show dialog in list");
        showDialogBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                Dialogs.create().lightweight().owner(listView).title("Lightweight Dialog").message("This should only block the listview").showInformation();
            }
        });
        Button printToConsole = new Button("Print to console");
        printToConsole.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                System.out.println(new Date());
            }
        });
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0));
        grid.add((Node)listView, 0, 0, 1, 3);
        grid.add((Node)showDialogBtn, 1, 0);
        grid.add((Node)printToConsole, 1, 1);
        tab2.setContent((Node)grid);
    }

    public void start(Stage stage) {
        this.stage = stage;
        stage.setTitle("Lightweight Dialogs Sample");
        Scene scene = new Scene((Parent)this.getPanel(stage), 800.0, 400.0);
        scene.setFill((Paint)Color.WHITE);
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }
}

