/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.applications.desktop;

import edu.uic.cs.nlp.chiqat.applications.desktop.SystemConfig;
import edu.uic.cs.nlp.chiqat.framework.IPluginClientHost;
import edu.uic.cs.nlp.chiqat.framework.Message;
import edu.uic.cs.nlp.chiqat.framework.PluginManager;
import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.ShowViewMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.User;
import edu.uic.cs.nlp.chiqat.framework.messages.UserLoginMessage;
import edu.uic.cs.nlp.chiqat.plugin.base.BasePluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginMenuItemDefinition;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewDefinition;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import edu.uic.cs.nlp.toolbox.MiscFuncs;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class Program
extends Application
implements EventHandler<ActionEvent>,
IPluginClientHost {
    protected static String[] CommandLineArgs = null;
    protected PluginManager m_PluginManager = null;
    protected Group m_PluginViewGroup = null;
    protected Scene m_PluginScene = null;
    protected Stage m_PrimaryStage = null;
    protected Menu m_ActionsMenu = null;
    protected List<PluginViewFx> m_CentrePaneOrder = new ArrayList<PluginViewFx>();
    protected List<Stage> m_PopupWindows = new ArrayList<Stage>();
    protected BorderPane m_HintBoarderPane = null;
    protected User m_User = null;
    protected Random m_Rand = new Random(System.currentTimeMillis());

    public void start(Stage primaryStage) {
        SystemConfig cfg;
        String appBinDir = this.GetAppBinDir();
        System.out.println("AppBinDir = " + appBinDir);
        String sysConfig = (String)this.getParameters().getNamed().get("syscfg");
        if (sysConfig == null || sysConfig.length() == 0) {
            sysConfig = String.valueOf(appBinDir) + "/Config/ChiQatCfg.xml";
        }
        if (!(cfg = new SystemConfig()).Load(sysConfig)) {
            System.out.println("Invalid config");
            return;
        }
        if (appBinDir != null && appBinDir != "" && cfg.CFG_AppDataDir == "") {
            cfg.CFG_AppDataDir = appBinDir;
        }
        this.m_PrimaryStage = primaryStage;
        this.AddWindowLogging();
        this.m_PluginManager = PluginManager.Create(cfg.CFG_AppDataDir, cfg.CFG_PluginDir.startsWith("/") ? cfg.CFG_PluginDir : String.valueOf(cfg.CFG_AppDataDir) + "/" + cfg.CFG_PluginDir, cfg.CFG_BluePrint);
        if (this.m_PluginManager == null) {
            System.out.println("Can't get plugins");
            return;
        }
        primaryStage.setTitle("ChiQat");
        this.m_PluginViewGroup = new Group();
        this.m_PluginScene = new Scene((Parent)this.m_PluginViewGroup, 800.0, 600.0, (Paint)Color.WHITE);
        primaryStage.setScene(this.m_PluginScene);
        this.m_PluginManager.SetClientHost(this);
        this.UpdatePluginScene();
        this.m_PrimaryStage.show();
        this.UpdateTitleBar();
        this.m_PrimaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                try {
                    Program.this.LogMessage("User Logged Out", "");
                    Program.this.LogMessage("Application Exit", "");
                    Platform.exit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void AddWindowLogging() {
        this.m_PrimaryStage.iconifiedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                Program.this.LogMessage("Application Window Minimized", t1 != false ? "Yes" : "No");
            }
        });
        this.m_PrimaryStage.maximizedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                Program.this.LogMessage("Application Window Maximized", t1 != false ? "Yes" : "No");
            }
        });
    }

    protected void LogMessage(String type, String arg1) {
        LogMsg msg = new LogMsg();
        msg.m_MessageId = "Log";
        msg.m_MsgType = type;
        msg.m_Level = LogMsg.LogEntryLevel.Lel_Info;
        msg.m_bDebug = false;
        msg.m_Arg1 = arg1;
        this.m_PluginManager.SendMessage(msg);
    }

    private void UpdatePluginScene() {
        this.m_PluginViewGroup.getChildren().clear();
        List<PluginViewDefinition> views = this.m_PluginManager.GetAllViews();
        Node mainNode = this.HostPluginsInHintBasedLayout(views);
        this.m_PluginViewGroup.getChildren().add((Object)mainNode);
    }

    public void stop() throws Exception {
        this.m_PluginManager.Shutdown();
        super.stop();
    }

    private Node HostPluginsInFlowLayout(List<PluginViewDefinition> views) {
        FlowPane flow = new FlowPane();
        flow.setHgap(10.0);
        flow.setVgap(10.0);
        flow.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        flow.setStyle("-fx-background-color: DAE6F3;");
        for (PluginViewDefinition view : views) {
            flow.getChildren().add((Object)view.CreateView());
        }
        flow.prefHeightProperty().bind((ObservableValue)this.m_PluginScene.heightProperty());
        flow.prefWidthProperty().bind((ObservableValue)this.m_PluginScene.widthProperty());
        return flow;
    }

    private Node HostPluginsInHintBasedLayout(List<PluginViewDefinition> views) {
        BorderPane basePane = new BorderPane();
        MenuBar menuBar = new MenuBar();
        basePane.setTop((Node)menuBar);
        this.m_ActionsMenu = new Menu("Actions");
        menuBar.getMenus().add((Object)this.m_ActionsMenu);
        this.m_HintBoarderPane = new BorderPane();
        this.m_HintBoarderPane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        basePane.setCenter((Node)this.m_HintBoarderPane);
        for (PluginViewDefinition view : views) {
            if ((view.m_iHostHint & 0x1000) == 0 || this.m_CentrePaneOrder.size() != 0) continue;
            PluginViewFx v = view.CreateView();
            this.ShowPluginView(view.m_ViewTypeId, "Default", false);
        }
        basePane.prefHeightProperty().bind((ObservableValue)this.m_PluginScene.heightProperty());
        basePane.prefWidthProperty().bind((ObservableValue)this.m_PluginScene.widthProperty());
        this.RefreshStandardMenuItems();
        return basePane;
    }

    public void handle(ActionEvent event) {
        String id = ((MenuItem)event.getSource()).getId();
        if (id.compareTo("MenuItemClick") == 0) {
            PluginMenuItemDefinition def = (PluginMenuItemDefinition)((MenuItem)event.getSource()).getUserData();
            this.m_PluginManager.SendMessage(def.m_Message);
        }
    }

    private Node HostPluginsInTab(List<PluginViewDefinition> views) {
        TabPane tabPane = new TabPane();
        BorderPane mainPane = new BorderPane();
        for (PluginViewDefinition view : views) {
            Tab tabA = new Tab();
            tabA.setText("Tab A");
            tabPane.getTabs().add((Object)tabA);
            tabA.setContent((Node)view.CreateView());
        }
        mainPane.setCenter((Node)tabPane);
        mainPane.prefHeightProperty().bind((ObservableValue)this.m_PluginScene.heightProperty());
        mainPane.prefWidthProperty().bind((ObservableValue)this.m_PluginScene.widthProperty());
        return mainPane;
    }

    public static void main(String[] args) {
        CommandLineArgs = args;
        Program.launch((String[])args);
    }

    @Override
    public void OnPluginMessage(Message msg) {
        switch (msg.m_MessageId) {
            case "CloseView": {
                this.ClosePluginView(msg.m_StringData);
                break;
            }
            case "ShowView": {
                ShowViewMsg showMsg = (ShowViewMsg)msg;
                this.ShowView(showMsg);
                break;
            }
            case "UserLoggedIn": {
                UserLoginMessage userMsg = (UserLoginMessage)msg;
                this.m_User = userMsg.m_User;
                this.RefreshStandardMenuItems();
                this.UpdateCentrePaneWithTopView();
                this.UpdateTitleBar();
            }
        }
    }

    public void UpdateTitleBar() {
        String userId = "";
        if (this.m_User != null) {
            userId = this.m_User.getId();
            int iId = Integer.parseInt(userId);
            int iDoM = Calendar.getInstance().get(5);
            userId = Integer.toHexString(iId += iDoM);
        } else {
            userId = Integer.toHexString(this.m_Rand.nextInt(1000) + 7);
        }
        this.m_PrimaryStage.setTitle("ChiQat [" + userId + "]");
    }

    private PluginViewFx FindPluginView(String viewTypeId, String viewId) {
        int i = 0;
        while (i < this.m_CentrePaneOrder.size()) {
            if (this.m_CentrePaneOrder.get(i).GetViewId().compareToIgnoreCase(viewId) == 0 && this.m_CentrePaneOrder.get(i).GetViewTypeId().compareToIgnoreCase(viewTypeId) == 0) {
                return this.m_CentrePaneOrder.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void ClosePluginView(PluginViewFx view) {
        this.ClosePluginView(view.GetViewId());
    }

    protected void ClosePluginView(String viewId) {
        int i = 0;
        while (i < this.m_CentrePaneOrder.size()) {
            if (this.m_CentrePaneOrder.get(i).GetViewId().compareToIgnoreCase(viewId) == 0) {
                this.m_CentrePaneOrder.remove(i);
                --i;
            }
            ++i;
        }
        if (this.m_CentrePaneOrder.size() == 0) {
            PluginViewDefinition view = this.m_PluginManager.GetDefaultView();
            this.ShowPluginView(view.m_ViewTypeId, null, false);
        }
        this.UpdateCentrePaneWithTopView();
    }

    protected void RefreshStandardMenuItems() {
        List<BasePluginInstance> insts = this.m_PluginManager.GetAllPluginInstances();
        for (BasePluginInstance inst : insts) {
            for (PluginMenuItemDefinition def : inst.m_MenuItemDefs) {
                this.AddMenuItem(def);
            }
        }
    }

    protected void ShowFocusedMenuItems(PluginViewFx v) {
        ObservableList actionItems = this.m_ActionsMenu.getItems();
        int i = 0;
        while (i < actionItems.size()) {
            Object o = ((MenuItem)actionItems.get(i)).getUserData();
            if (o != null) {
                PluginMenuItemDefinition menuItemDef = (PluginMenuItemDefinition)o;
                if (menuItemDef.m_OwnerViewId != null && menuItemDef.m_OwnerViewId != "" && v.GetViewId().compareTo(menuItemDef.m_OwnerViewId) != 0) {
                    actionItems.remove(i--);
                }
            }
            ++i;
        }
        if (v != null) {
            for (PluginMenuItemDefinition def : v.m_MenuItemDefs) {
                this.AddMenuItem(def);
            }
        }
    }

    protected void AddMenuItem(PluginMenuItemDefinition def) {
        boolean bItemAllowed;
        boolean bl = bItemAllowed = !def.m_bAdminOnly || this.m_User != null && this.m_User.IsAdmin();
        if (bItemAllowed) {
            boolean bExists = false;
            int i = 0;
            while (i < this.m_ActionsMenu.getItems().size() && !bExists) {
                if (((MenuItem)this.m_ActionsMenu.getItems().get(i)).getUserData() == def) {
                    bExists = true;
                }
                ++i;
            }
            if (!bExists) {
                Vector<String> parts = MiscFuncs.ParseString(def.m_Text, '|');
                MenuItem menuItem = new MenuItem((String)parts.get(parts.size() - 1));
                this.m_ActionsMenu.getItems().add((Object)menuItem);
                menuItem.setUserData((Object)def);
                menuItem.setId("MenuItemClick");
                menuItem.onActionProperty().set((Object)this);
            }
        } else {
            int i = 0;
            while (i < this.m_ActionsMenu.getItems().size()) {
                if (((MenuItem)this.m_ActionsMenu.getItems().get(i)).getUserData() == def) {
                    this.m_ActionsMenu.getItems().remove(i--);
                }
                ++i;
            }
        }
    }

    private void ShowView(ShowViewMsg showMsg) {
        this.ShowPluginView(showMsg.m_ViewTypeId, showMsg.m_ViewId, showMsg.m_bPopup);
    }

    protected void ShowViewInPopupWindow(PluginViewFx view) {
        Stage stage = null;
        for (Stage s : this.m_PopupWindows) {
            Parent p = s.getScene().getRoot();
            if (p != view) continue;
            stage = s;
        }
        if (stage == null) {
            stage = new Stage();
            stage.setScene(new Scene((Parent)view));
            stage.setTitle(view.GetTitle());
            stage.initModality(Modality.WINDOW_MODAL);
            this.m_PopupWindows.add(stage);
            stage.show();
        } else {
            stage.show();
            stage.requestFocus();
        }
    }

    protected void ShowViewInMainWindow(PluginViewFx view) {
        int i = 0;
        while (i < this.m_CentrePaneOrder.size()) {
            if (this.m_CentrePaneOrder.get(i) == view) {
                this.m_CentrePaneOrder.remove(i--);
            }
            ++i;
        }
        this.m_CentrePaneOrder.add(view);
        this.UpdateCentrePaneWithTopView();
    }

    public void ShowPluginView(String viewTypeId, String viewId, boolean bPopup) {
        int i;
        PluginViewFx view = null;
        if (bPopup) {
            i = 0;
            while (i < this.m_PopupWindows.size()) {
                PluginViewFx pfx = (PluginViewFx)this.m_PopupWindows.get(i).getScene().getRoot();
                if (pfx.GetViewId().compareTo(viewId) == 0 && pfx.GetViewTypeId().compareTo(viewTypeId) == 0) {
                    view = pfx;
                    break;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.m_CentrePaneOrder.size()) {
                if (this.m_CentrePaneOrder.get(i).GetViewId().compareTo(viewId) == 0 && this.m_CentrePaneOrder.get(i).GetViewTypeId().compareTo(viewTypeId) == 0) {
                    view = this.m_CentrePaneOrder.get(i);
                    break;
                }
                ++i;
            }
        }
        if (view == null) {
            List<PluginViewDefinition> views = this.m_PluginManager.GetAllViews();
            for (PluginViewDefinition v : views) {
                if (v.m_ViewTypeId.compareTo(viewTypeId) != 0) continue;
                view = v.CreateView(viewId);
                break;
            }
        }
        if (bPopup) {
            this.ShowViewInPopupWindow(view);
        } else {
            this.ShowViewInMainWindow(view);
        }
    }

    protected void UpdateCentrePaneWithTopView() {
        PluginViewFx view = null;
        if (this.m_CentrePaneOrder.size() > 0) {
            view = this.m_CentrePaneOrder.get(this.m_CentrePaneOrder.size() - 1);
        }
        this.m_HintBoarderPane.setCenter(view);
        this.ShowFocusedMenuItems(view);
    }

    protected String GetAppBinDir() {
        int iIndex;
        if (CommandLineArgs != null && CommandLineArgs.length > 0) {
            return CommandLineArgs[0];
        }
        URL location = Program.class.getProtectionDomain().getCodeSource().getLocation();
        String appPath = location.getPath();
        try {
            appPath = URLDecoder.decode(appPath, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int iDirIndex = appPath.lastIndexOf(47);
        String appDir = "";
        if (iDirIndex != -1) {
            appDir = appPath.substring(0, iDirIndex);
        }
        if ((iIndex = appDir.indexOf("Projects/ChiQat-PC")) != -1) {
            appDir = appDir.substring(0, iIndex + "Projects/ChiQat-PC".length());
        }
        return String.valueOf(appDir) + "/Bin";
    }
}

